/*
 * Decompiled with CFR 0.152.
 */
package edu.princeton.cs.algs4;

import java.util.Iterator;
import java.util.NoSuchElementException;

public class IndexMinPQ<Key extends Comparable<Key>>
implements Iterable<Integer> {
    private int N;
    private int[] pq;
    private int[] qp;
    private Key[] keys;

    public IndexMinPQ(int NMAX) {
        this.keys = new Comparable[NMAX + 1];
        this.pq = new int[NMAX + 1];
        this.qp = new int[NMAX + 1];
        int i = 0;
        while (i <= NMAX) {
            this.qp[i] = -1;
            ++i;
        }
    }

    public boolean isEmpty() {
        return this.N == 0;
    }

    public boolean contains(int k) {
        return this.qp[k] != -1;
    }

    public int size() {
        return this.N;
    }

    public void insert(int k, Key key) {
        if (this.contains(k)) {
            throw new NoSuchElementException("item is already in pq");
        }
        this.qp[k] = ++this.N;
        this.pq[this.N] = k;
        this.keys[k] = key;
        this.swim(this.N);
    }

    public int minIndex() {
        if (this.N == 0) {
            throw new NoSuchElementException("Priority queue underflow");
        }
        return this.pq[1];
    }

    public Key minKey() {
        if (this.N == 0) {
            throw new NoSuchElementException("Priority queue underflow");
        }
        return this.keys[this.pq[1]];
    }

    public int delMin() {
        if (this.N == 0) {
            throw new NoSuchElementException("Priority queue underflow");
        }
        int min = this.pq[1];
        this.exch(1, this.N--);
        this.sink(1);
        this.qp[min] = -1;
        this.keys[this.pq[this.N + 1]] = null;
        this.pq[this.N + 1] = -1;
        return min;
    }

    public Key keyOf(int k) {
        if (!this.contains(k)) {
            throw new NoSuchElementException("item is not in pq");
        }
        return this.keys[k];
    }

    public void change(int k, Key key) {
        this.changeKey(k, key);
    }

    public void changeKey(int k, Key key) {
        if (!this.contains(k)) {
            throw new NoSuchElementException("item is not in pq");
        }
        this.keys[k] = key;
        this.swim(this.qp[k]);
        this.sink(this.qp[k]);
    }

    public void decreaseKey(int k, Key key) {
        if (!this.contains(k)) {
            throw new NoSuchElementException("item is not in pq");
        }
        if (this.keys[k].compareTo(key) <= 0) {
            throw new RuntimeException("illegal decrease");
        }
        this.keys[k] = key;
        this.swim(this.qp[k]);
    }

    public void increaseKey(int k, Key key) {
        if (!this.contains(k)) {
            throw new NoSuchElementException("item is not in pq");
        }
        if (this.keys[k].compareTo(key) >= 0) {
            throw new RuntimeException("illegal decrease");
        }
        this.keys[k] = key;
        this.sink(this.qp[k]);
    }

    public void delete(int k) {
        if (!this.contains(k)) {
            throw new NoSuchElementException("item is not in pq");
        }
        int index = this.qp[k];
        this.exch(index, this.N--);
        this.swim(index);
        this.sink(index);
        this.keys[k] = null;
        this.qp[k] = -1;
    }

    private boolean greater(int i, int j) {
        return this.keys[this.pq[i]].compareTo(this.keys[this.pq[j]]) > 0;
    }

    private void exch(int i, int j) {
        int swap = this.pq[i];
        this.pq[i] = this.pq[j];
        this.pq[j] = swap;
        this.qp[this.pq[i]] = i;
        this.qp[this.pq[j]] = j;
    }

    private void swim(int k) {
        while (k > 1 && this.greater(k / 2, k)) {
            this.exch(k, k / 2);
            k /= 2;
        }
    }

    private void sink(int k) {
        while (2 * k <= this.N) {
            int j = 2 * k;
            if (j < this.N && this.greater(j, j + 1)) {
                ++j;
            }
            if (!this.greater(k, j)) break;
            this.exch(k, j);
            k = j;
        }
    }

    @Override
    public Iterator<Integer> iterator() {
        return new HeapIterator();
    }

    private class HeapIterator
    implements Iterator<Integer> {
        private IndexMinPQ<Key> copy;

        public HeapIterator() {
            this.copy = new IndexMinPQ(IndexMinPQ.this.pq.length - 1);
            int i = 1;
            while (i <= IndexMinPQ.this.N) {
                this.copy.insert(IndexMinPQ.this.pq[i], IndexMinPQ.this.keys[IndexMinPQ.this.pq[i]]);
                ++i;
            }
        }

        @Override
        public boolean hasNext() {
            return !this.copy.isEmpty();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.copy.delMin();
        }
    }
}

