/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.graphview.core.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openstreetmap.josm.tools.Logging;

public final class ValueStringParser {
    private static final Pattern DEC_POINT_PATTERN = Pattern.compile("^(\\-?\\d+)\\.(\\d+)$");
    private static final Pattern KMH_PATTERN = Pattern.compile("^(\\d+)\\s*km/h$");
    private static final Pattern MPH_PATTERN = Pattern.compile("^(\\d+)\\s*mph$");
    private static final float KM_PER_MILE = 1.609344f;
    private static final Pattern M_PATTERN = Pattern.compile("^([\\d\\.]+)\\s*m$");
    private static final Pattern KM_PATTERN = Pattern.compile("^([\\d\\.]+)\\s*km$");
    private static final Pattern MI_PATTERN = Pattern.compile("^([\\d\\.]+)\\s*mi$");
    private static final Pattern FEET_INCHES_PATTERN = Pattern.compile("^([\\d]+)'\\s*([\\d]+)\"");
    private static final double M_PER_MI = 1609.344;
    private static final double M_PER_INCH = (double)0.0254f;
    private static final Pattern T_PATTERN = Pattern.compile("^([\\d\\.]+)\\s*t$");
    private static final Pattern INCLINE_PATTERN = Pattern.compile("^(\\-?\\d+(?:\\.\\d+)?)\\s*%$");

    private ValueStringParser() {
    }

    public static Float parseOsmDecimal(String value, boolean allowNegative) {
        try {
            int weight = Integer.parseInt(value);
            if (weight >= 0 || allowNegative) {
                return Float.valueOf(weight);
            }
        }
        catch (NumberFormatException nfe) {
            Logging.trace((Throwable)nfe);
        }
        Matcher matcher = DEC_POINT_PATTERN.matcher(value);
        if (matcher.matches()) {
            String stringBeforePoint = matcher.group(1);
            String stringAfterPoint = matcher.group(2);
            if (stringBeforePoint.length() > 0 || stringAfterPoint.length() > 0) {
                try {
                    float beforePoint = Integer.parseInt(stringBeforePoint);
                    float afterPoint = Integer.parseInt(stringAfterPoint);
                    double result = (double)Math.signum(beforePoint) * ((double)Math.abs(beforePoint) + Math.pow(10.0, -stringAfterPoint.length()) * (double)afterPoint);
                    if (result >= 0.0 || allowNegative) {
                        return Float.valueOf((float)result);
                    }
                }
                catch (NumberFormatException nfe) {
                    Logging.trace((Throwable)nfe);
                }
            }
        }
        return null;
    }

    public static Float parseSpeed(String value) {
        Matcher mphMatcher;
        Float speed = ValueStringParser.parseOsmDecimal(value, false);
        if (speed != null) {
            return speed;
        }
        Matcher kmhMatcher = KMH_PATTERN.matcher(value);
        if (kmhMatcher.matches()) {
            String kmhString = kmhMatcher.group(1);
            try {
                return Float.valueOf(Integer.parseInt(kmhString));
            }
            catch (NumberFormatException nfe) {
                Logging.trace((Throwable)nfe);
            }
        }
        if ((mphMatcher = MPH_PATTERN.matcher(value)).matches()) {
            String mphString = mphMatcher.group(1);
            try {
                int mph = Integer.parseInt(mphString);
                return Float.valueOf(1.609344f * (float)mph);
            }
            catch (NumberFormatException nfe) {
                Logging.trace((Throwable)nfe);
            }
        }
        return null;
    }

    public static Float parseMeasure(String value) {
        Float measure = ValueStringParser.parseOsmDecimal(value, false);
        if (measure != null) {
            return measure;
        }
        Matcher mMatcher = M_PATTERN.matcher(value);
        if (mMatcher.matches()) {
            String mString = mMatcher.group(1);
            return ValueStringParser.parseOsmDecimal(mString, false);
        }
        Matcher kmMatcher = KM_PATTERN.matcher(value);
        if (kmMatcher.matches()) {
            String kmString = kmMatcher.group(1);
            float km = ValueStringParser.parseOsmDecimal(kmString, false).floatValue();
            return Float.valueOf(1000.0f * km);
        }
        Matcher miMatcher = MI_PATTERN.matcher(value);
        if (miMatcher.matches()) {
            String miString = miMatcher.group(1);
            float mi = ValueStringParser.parseOsmDecimal(miString, false).floatValue();
            return Float.valueOf((float)(1609.344 * (double)mi));
        }
        Matcher feetInchesMatcher = FEET_INCHES_PATTERN.matcher(value);
        if (feetInchesMatcher.matches()) {
            String feetString = feetInchesMatcher.group(1);
            String inchesString = feetInchesMatcher.group(2);
            try {
                int feet = Integer.parseInt(feetString);
                int inches = Integer.parseInt(inchesString);
                if (feet >= 0 && inches >= 0 && inches < 12) {
                    return Float.valueOf((float)((double)0.0254f * (double)(12 * feet + inches)));
                }
            }
            catch (NumberFormatException nfe) {
                Logging.trace((Throwable)nfe);
            }
        }
        return null;
    }

    public static Float parseWeight(String value) {
        Float weight = ValueStringParser.parseOsmDecimal(value, false);
        if (weight != null) {
            return weight;
        }
        Matcher tMatcher = T_PATTERN.matcher(value);
        if (tMatcher.matches()) {
            String tString = tMatcher.group(1);
            return ValueStringParser.parseOsmDecimal(tString, false);
        }
        return null;
    }

    public static Float parseIncline(String value) {
        Matcher inclineMatcher = INCLINE_PATTERN.matcher(value);
        if (inclineMatcher.matches()) {
            String inclineString = inclineMatcher.group(1);
            return ValueStringParser.parseOsmDecimal(inclineString, true);
        }
        return null;
    }
}

