/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.utilsplugin2.search;

import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.search.PushbackTokenizer;
import org.openstreetmap.josm.data.osm.search.SearchCompiler;

public abstract class RangeMatch
extends SearchCompiler.Match {
    private final long min;
    private final long max;

    public RangeMatch(long min, long max) {
        this.min = Math.min(min, max);
        this.max = Math.max(min, max);
    }

    public RangeMatch(PushbackTokenizer.Range range) {
        this(range.getStart(), range.getEnd());
    }

    protected abstract Long getNumber(OsmPrimitive var1);

    protected abstract String getString();

    public boolean match(OsmPrimitive osm) {
        Long num = this.getNumber(osm);
        if (num == null) {
            return false;
        }
        return num >= this.min && num <= this.max;
    }

    public String toString() {
        return String.valueOf(this.getString()) + "=" + this.min + "-" + this.max;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.max ^ this.max >>> 32);
        result = 31 * result + (int)(this.min ^ this.min >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        RangeMatch other = (RangeMatch)((Object)obj);
        if (this.max != other.max) {
            return false;
        }
        return this.min == other.min;
    }
}

