/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.alignways.geometry;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.plugins.alignways.geometry.AlignWaysGeomLine;

public class AlignWaysGeomPoint {
    double x;
    double y;

    public AlignWaysGeomPoint(double x, double y) {
        this.setX(x);
        this.setY(y);
    }

    public AlignWaysGeomPoint(EastNorth eastNorth) {
        this.x = eastNorth.getX();
        this.y = eastNorth.getY();
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public void setX(double x) {
        this.x = x;
    }

    public void setY(double y) {
        this.y = y;
    }

    public static boolean isSetCollinear(ArrayList<AlignWaysGeomPoint> awPts) {
        if (awPts.size() <= 1) {
            return false;
        }
        if (awPts.size() == 2) {
            return true;
        }
        AlignWaysGeomLine line = new AlignWaysGeomLine(awPts.get(0), awPts.get(1));
        int i = 2;
        while (i < awPts.size()) {
            if (!line.isPointOnLine(awPts.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static int getMiddleOf3(AlignWaysGeomPoint pt1, AlignWaysGeomPoint pt2, AlignWaysGeomPoint pt3) {
        int midPtXIdx = AlignWaysGeomPoint.getMiddleOf3(pt1.x, pt2.x, pt3.x);
        int midPtYIdx = AlignWaysGeomPoint.getMiddleOf3(pt1.y, pt2.y, pt3.y);
        if (midPtXIdx == 0 && midPtYIdx == 0) {
            return 2;
        }
        if (midPtXIdx == 0) {
            return midPtYIdx;
        }
        if (midPtYIdx == 0) {
            return midPtXIdx;
        }
        if (midPtXIdx == midPtYIdx) {
            return midPtXIdx;
        }
        return 0;
    }

    private static int getMiddleOf3(double d1, double d2, double d3) {
        Double[] dValues = new Double[]{d1, d2, d3};
        ArrayList<Double> alValues = new ArrayList<Double>(Arrays.asList(dValues));
        Collections.sort(alValues);
        if (Math.abs(alValues.get(1) - alValues.get(0)) < 0.01 || Math.abs(alValues.get(1) - alValues.get(2)) < 0.01) {
            return 0;
        }
        if (Math.abs(alValues.get(1) - d1) < 0.01) {
            return 1;
        }
        if (Math.abs(alValues.get(1) - d2) < 0.01) {
            return 2;
        }
        if (Math.abs(alValues.get(1) - d3) < 0.01) {
            return 3;
        }
        return 0;
    }
}

