/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.elevation.grid;

import org.openstreetmap.gui.jmapviewer.Tile;
import org.openstreetmap.gui.jmapviewer.interfaces.TileJob;
import org.openstreetmap.gui.jmapviewer.interfaces.TileLoader;
import org.openstreetmap.gui.jmapviewer.interfaces.TileLoaderListener;
import org.openstreetmap.josm.tools.CheckParameterUtil;

public class ElevationGridTileLoader
implements TileLoader {
    protected TileLoaderListener listener;

    public ElevationGridTileLoader(TileLoaderListener listener) {
        CheckParameterUtil.ensureParameterNotNull((Object)listener);
        this.listener = listener;
    }

    public TileJob createTileLoaderJob(final Tile tile) {
        CheckParameterUtil.ensureParameterNotNull((Object)tile);
        return new TileJob(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Tile tile2 = tile;
                synchronized (tile2) {
                    if (tile.isLoaded() && !tile.hasError() || tile.isLoading()) {
                        return;
                    }
                    tile.initLoading();
                }
                try {
                    try {
                        tile.loadImage(null);
                        tile.setLoaded(true);
                        ElevationGridTileLoader.this.listener.tileLoadingFinished(tile, true);
                    }
                    catch (Exception e) {
                        tile.setError(e.getMessage());
                        ElevationGridTileLoader.this.listener.tileLoadingFinished(tile, false);
                        tile.finishLoading();
                    }
                }
                finally {
                    tile.finishLoading();
                }
            }

            public void submit() {
                this.run();
            }

            public void submit(boolean force) {
                this.submit();
            }
        };
    }

    public void cancelOutstandingTasks() {
    }
}

