/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.elevation.grid;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.plugins.elevation.ElevationHelper;
import org.openstreetmap.josm.plugins.elevation.grid.EleCoordinate;

public class EleVertex {
    private static final int NPOINTS = 3;
    private static final double MIN_DIST = 90.0;
    private double avrgEle = Double.NaN;
    private double area = Double.NaN;
    private final EleCoordinate[] points = new EleCoordinate[3];

    public EleVertex(EleCoordinate p1, EleCoordinate p2, EleCoordinate p3) {
        this.points[0] = p1;
        this.points[1] = p2;
        this.points[2] = p3;
        double z = 0.0;
        boolean eleValid = true;
        EleCoordinate[] eleCoordinateArray = this.points;
        int n = this.points.length;
        int n2 = 0;
        while (n2 < n) {
            EleCoordinate point = eleCoordinateArray[n2];
            if (ElevationHelper.isValidElevation(p1.getEle())) {
                z += point.getEle();
            } else {
                eleValid = false;
                break;
            }
            ++n2;
        }
        this.avrgEle = eleValid ? z / 3.0 : ElevationHelper.NO_ELEVATION;
        double a = p1.greatCircleDistance(p2);
        double b = p2.greatCircleDistance(p3);
        double c = p1.greatCircleDistance(p3);
        double s = (a + b + c) / 2.0;
        double sq = s * (s - a) * (s - b) * (s - c);
        this.area = Math.sqrt(sq);
    }

    public List<EleVertex> divide() {
        Object[] edges = new TriangleEdge[3];
        int k = 0;
        int i = 0;
        while (i < this.points.length) {
            EleCoordinate c1 = this.points[i];
            int j = i + 1;
            while (j < this.points.length) {
                EleCoordinate c2 = this.points[j];
                edges[k++] = new TriangleEdge(i, j, c1.greatCircleDistance(c2));
                ++j;
            }
            ++i;
        }
        Arrays.sort(edges);
        Object longest = edges[0];
        EleCoordinate pI = this.points[((TriangleEdge)longest).getI()];
        EleCoordinate pJ = this.points[((TriangleEdge)longest).getJ()];
        EleCoordinate pK = this.points[((TriangleEdge)longest).getK()];
        EleCoordinate newP = this.getMid(pI, pJ);
        ArrayList<EleVertex> res = new ArrayList<EleVertex>();
        res.add(new EleVertex(pI, pK, newP));
        res.add(new EleVertex(pJ, pK, newP));
        return res;
    }

    public boolean isFinished() {
        return this.getArea() < 900.0;
    }

    public double getArea() {
        return this.area;
    }

    public EleCoordinate getMid(EleCoordinate c1, EleCoordinate c2) {
        double hgtZ;
        double x = (c1.getX() + c2.getX()) / 2.0;
        double y = (c1.getY() + c2.getY()) / 2.0;
        double z = (c1.getEle() + c2.getEle()) / 2.0;
        if (c1.greatCircleDistance(c2) > 90.0 && ElevationHelper.isValidElevation(hgtZ = ElevationHelper.getSrtmElevation(new LatLon(y, x)))) {
            z = hgtZ;
        }
        return new EleCoordinate(y, x, z);
    }

    public EleCoordinate get(int index) {
        if (index < 0 || index >= 3) {
            throw new IllegalArgumentException("Invalid index: " + index);
        }
        return this.points[index];
    }

    public double getEle() {
        return this.avrgEle;
    }

    public String toString() {
        return "EleVertex [avrgEle=" + this.avrgEle + ", area=" + this.area + ", points=" + Arrays.toString((Object[])this.points) + ']';
    }

    static class TriangleEdge
    implements Comparable<TriangleEdge> {
        private final int i;
        private final int j;
        private final double dist;

        TriangleEdge(int i, int j, double dist) {
            this.i = i;
            this.j = j;
            this.dist = dist;
        }

        public int getI() {
            return this.i;
        }

        public int getJ() {
            return this.j;
        }

        public int getK() {
            if (this.i == 0) {
                return this.j == 1 ? 2 : 1;
            }
            if (this.i == 1) {
                return this.j == 0 ? 2 : 0;
            }
            return this.j == 0 ? 1 : 0;
        }

        public double getDist() {
            return this.dist;
        }

        @Override
        public int compareTo(TriangleEdge o) {
            return (int)(o.getDist() - this.dist);
        }

        public String toString() {
            return "TriangleEdge [i=" + this.i + ", j=" + this.j + ", dist=" + this.dist + "]";
        }
    }
}

