/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugin.download_along;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.geom.Area;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.actions.DownloadAlongAction;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.gpx.DownloadAlongPanel;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Shortcut;
import org.openstreetmap.josm.tools.Utils;

class DownloadAlongWayAction
extends DownloadAlongAction {
    private static final String PREF_DOWNLOAD_ALONG_WAY_DISTANCE = "downloadAlongWay.distance";
    private static final String PREF_DOWNLOAD_ALONG_WAY_AREA = "downloadAlongWay.area";
    private static final String PREF_DOWNLOAD_ALONG_WAY_OSM = "downloadAlongWay.download.osm";
    private static final String PREF_DOWNLOAD_ALONG_WAY_GPS = "downloadAlongWay.download.gps";

    DownloadAlongWayAction() {
        super(I18n.tr((String)"Download along...", (Object[])new Object[0]), "download_along", I18n.tr((String)"Download OSM data along the selected ways.", (Object[])new Object[0]), Shortcut.registerShortcut((String)"tools:download_along", (String)I18n.tr((String)"Tool: {0}", (Object[])new Object[]{I18n.tr((String)"Download Along", (Object[])new Object[0])}), (int)68, (int)5007), true);
    }

    public void actionPerformed(ActionEvent e) {
        Collection selectedWays = this.getLayerManager().getEditDataSet().getSelectedWays();
        if (selectedWays.isEmpty()) {
            JOptionPane.showMessageDialog((Component)MainApplication.getMainFrame(), I18n.tr((String)"Please select 1 or more ways to download along", (Object[])new Object[0]));
            return;
        }
        DownloadAlongPanel panel = new DownloadAlongPanel(PREF_DOWNLOAD_ALONG_WAY_OSM, PREF_DOWNLOAD_ALONG_WAY_GPS, PREF_DOWNLOAD_ALONG_WAY_DISTANCE, PREF_DOWNLOAD_ALONG_WAY_AREA, null);
        if (0 != panel.showInDownloadDialog(I18n.tr((String)"Download from OSM along selected ways", (Object[])new Object[0]), HelpUtil.ht((String)"/Tools/DownloadAlong"))) {
            return;
        }
        Logging.info((String)"Starting area computation");
        long start = System.currentTimeMillis();
        double scale = DownloadAlongWayAction.calcScale(selectedWays);
        double bufferDist = panel.getDistance();
        double bufferY = bufferDist / 100000.0;
        double bufferX = bufferY / scale;
        double maxArea = panel.getArea() / 10000.0 / scale;
        Path2D.Double path = new Path2D.Double();
        Rectangle2D.Double r = new Rectangle2D.Double();
        for (Way way : selectedWays) {
            LatLon previous = null;
            for (Node p : way.getNodes()) {
                LatLon c = p.getCoor();
                for (LatLon latLon : DownloadAlongWayAction.calcBetween(previous, c, bufferDist)) {
                    ((Rectangle2D)r).setRect(latLon.lon() - bufferX, latLon.lat() - bufferY, 2.0 * bufferX, 2.0 * bufferY);
                    path.append(r, false);
                }
                previous = c;
            }
        }
        Area a = new Area(path);
        Logging.info((String)("Area computed in " + Utils.getDurationString((long)(System.currentTimeMillis() - start))));
        DownloadAlongWayAction.confirmAndDownloadAreas((Area)a, (double)maxArea, (boolean)panel.isDownloadOsmData(), (boolean)panel.isDownloadGpxData(), (String)I18n.tr((String)"Download from OSM along selected ways", (Object[])new Object[0]), (ProgressMonitor)NullProgressMonitor.INSTANCE);
    }

    private static Collection<? extends LatLon> calcBetween(LatLon p1, LatLon p2, double bufferDist) {
        ArrayList<LatLon> intermediateNodes = new ArrayList<LatLon>();
        intermediateNodes.add(p2);
        if (p1 != null && p2.greatCircleDistance(p1) > bufferDist) {
            Double d = p2.greatCircleDistance(p1) / bufferDist;
            int nbNodes = d.intValue();
            if (Logging.isDebugEnabled()) {
                Logging.debug((String)I18n.tr((String)"{0} intermediate nodes to download.", (Object[])new Object[]{nbNodes}));
                Logging.debug((String)I18n.tr((String)"between {0} {1} and {2} {3}", (Object[])new Object[]{p2.lat(), p2.lon(), p1.lat(), p1.lon()}));
            }
            double latStep = (p2.lat() - p1.lat()) / (double)(nbNodes + 1);
            double lonStep = (p2.lon() - p1.lon()) / (double)(nbNodes + 1);
            for (int i = 1; i <= nbNodes; ++i) {
                LatLon intermediate = new LatLon(p1.lat() + (double)i * latStep, p1.lon() + (double)i * lonStep);
                intermediateNodes.add(intermediate);
                if (!Logging.isTraceEnabled()) continue;
                Logging.trace((String)I18n.tr((String)"  adding {0} {1}", (Object[])new Object[]{intermediate.lat(), intermediate.lon()}));
            }
        }
        return intermediateNodes;
    }

    private static double calcScale(Collection<Way> selectedWays) {
        double latsum = 0.0;
        int latcnt = 0;
        for (Way way : selectedWays) {
            for (Node n : way.getNodes()) {
                latsum += n.getCoor().lat();
                ++latcnt;
            }
        }
        if (latcnt > 0) {
            double avglat = latsum / (double)latcnt;
            return Math.cos(Math.toRadians(avglat));
        }
        return 1.0;
    }

    protected void updateEnabledState() {
        if (this.getLayerManager().getEditDataSet() == null) {
            this.setEnabled(false);
        } else {
            this.updateEnabledState(this.getLayerManager().getEditDataSet().getSelected());
        }
    }

    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        this.setEnabled(selection.stream().anyMatch(Way.class::isInstance));
    }
}

