/*
 * Decompiled with CFR 0.152.
 */
package poly;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.io.importexport.OsmExporter;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.I18n;
import poly.PolyType;

public class PolyExporter
extends OsmExporter {
    public PolyExporter() {
        super(PolyType.FILE_FILTER);
    }

    public void exportData(File file, Layer layer) throws IOException {
        if (layer instanceof OsmDataLayer) {
            if (((OsmDataLayer)layer).getDataSet().getWays().stream().anyMatch(w -> !w.isClosed())) {
                throw new IOException(I18n.tr((String)"Data contains unclosed ways.", (Object[])new Object[0]));
            }
            try (BufferedWriter writer = Files.newBufferedWriter(file.toPath(), StandardCharsets.UTF_8, new OpenOption[0]);){
                DataSet ds = ((OsmDataLayer)layer).getDataSet();
                HashSet<Way> written = new HashSet<Way>();
                boolean firstFile = true;
                String fileName = file.getName();
                if (fileName.lastIndexOf(46) > 0) {
                    fileName = fileName.substring(0, fileName.lastIndexOf(46));
                }
                for (Relation rel : ds.getRelations()) {
                    if (!rel.isMultipolygon()) continue;
                    if (!firstFile) {
                        writer.newLine();
                    }
                    PolyExporter.writeRelation(writer, fileName, rel, written);
                    firstFile = false;
                }
                if (firstFile) {
                    writer.write(fileName);
                }
                int counter = 1;
                for (Way w2 : ds.getWays()) {
                    if (written.contains(w2)) continue;
                    PolyExporter.writeWay(writer, w2, counter);
                }
                writer.write("END");
                writer.newLine();
            }
        }
    }

    private static void writeRelation(BufferedWriter writer, String fileName, Relation rel, Set<Way> written) throws IOException {
        String polygonName = fileName;
        if (rel.getName() != null) {
            polygonName = rel.getName();
        }
        writer.write(polygonName);
        writer.newLine();
        int counter = 1;
        for (RelationMember rm : rel.getMembers()) {
            if (!rm.isWay()) continue;
            if ("inner".equals(rm.getRole())) {
                writer.write(33);
            }
            Way w = rm.getWay();
            counter = PolyExporter.writeWay(writer, w, counter);
            written.add(w);
        }
    }

    private static int writeWay(BufferedWriter writer, Way w, int counter) throws IOException {
        String name = w.getName();
        if (name == null) {
            name = String.valueOf(counter++);
        }
        writer.write(name);
        writer.newLine();
        for (Node n : w.getNodes()) {
            writer.write(String.format(Locale.ENGLISH, "   %f   %f", n.getCoor().lon(), n.getCoor().lat()));
            writer.newLine();
        }
        writer.write("END");
        writer.newLine();
        return counter;
    }
}

