/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.hssf.record.StandardRecord;
import org.apache.poi.util.HexDump;
import org.apache.poi.util.LittleEndianOutput;

public final class FilePassRecord
extends StandardRecord {
    public static final short sid = 47;
    private int _encryptionType;
    private int _encryptionInfo;
    private int _minorVersionNo;
    private byte[] _docId;
    private byte[] _saltData;
    private byte[] _saltHash;
    private static final int ENCRYPTION_XOR = 0;
    private static final int ENCRYPTION_OTHER = 1;
    private static final int ENCRYPTION_OTHER_RC4 = 1;
    private static final int ENCRYPTION_OTHER_CAPI_2 = 2;
    private static final int ENCRYPTION_OTHER_CAPI_3 = 3;

    public FilePassRecord(RecordInputStream recordInputStream) {
        this._encryptionType = recordInputStream.readUShort();
        switch (this._encryptionType) {
            case 0: {
                throw new RecordFormatException("HSSF does not currently support XOR obfuscation");
            }
            case 1: {
                break;
            }
            default: {
                throw new RecordFormatException("Unknown encryption type " + this._encryptionType);
            }
        }
        this._encryptionInfo = recordInputStream.readUShort();
        switch (this._encryptionInfo) {
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                throw new RecordFormatException("HSSF does not currently support CryptoAPI encryption");
            }
            default: {
                throw new RecordFormatException("Unknown encryption info " + this._encryptionInfo);
            }
        }
        this._minorVersionNo = recordInputStream.readUShort();
        if (this._minorVersionNo != 1) {
            throw new RecordFormatException("Unexpected VersionInfo number for RC4Header " + this._minorVersionNo);
        }
        this._docId = FilePassRecord.read(recordInputStream, 16);
        this._saltData = FilePassRecord.read(recordInputStream, 16);
        this._saltHash = FilePassRecord.read(recordInputStream, 16);
    }

    private static byte[] read(RecordInputStream recordInputStream, int n) {
        byte[] byArray = new byte[n];
        recordInputStream.readFully(byArray);
        return byArray;
    }

    @Override
    public void serialize(LittleEndianOutput littleEndianOutput) {
        littleEndianOutput.writeShort(this._encryptionType);
        littleEndianOutput.writeShort(this._encryptionInfo);
        littleEndianOutput.writeShort(this._minorVersionNo);
        littleEndianOutput.write(this._docId);
        littleEndianOutput.write(this._saltData);
        littleEndianOutput.write(this._saltHash);
    }

    @Override
    protected int getDataSize() {
        return 54;
    }

    @Override
    public short getSid() {
        return 47;
    }

    @Override
    public Object clone() {
        return this;
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[FILEPASS]\n");
        stringBuffer.append("    .type = ").append(HexDump.shortToHex(this._encryptionType)).append("\n");
        stringBuffer.append("    .info = ").append(HexDump.shortToHex(this._encryptionInfo)).append("\n");
        stringBuffer.append("    .ver  = ").append(HexDump.shortToHex(this._minorVersionNo)).append("\n");
        stringBuffer.append("    .docId= ").append(HexDump.toHex(this._docId)).append("\n");
        stringBuffer.append("    .salt = ").append(HexDump.toHex(this._saltData)).append("\n");
        stringBuffer.append("    .hash = ").append(HexDump.toHex(this._saltHash)).append("\n");
        stringBuffer.append("[/FILEPASS]\n");
        return stringBuffer.toString();
    }
}

