/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.turnlanes.gui;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.osm.DataSelectionListener;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.event.AbstractDatasetChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataSetListener;
import org.openstreetmap.josm.data.osm.event.NodeMovedEvent;
import org.openstreetmap.josm.data.osm.event.PrimitivesAddedEvent;
import org.openstreetmap.josm.data.osm.event.PrimitivesRemovedEvent;
import org.openstreetmap.josm.data.osm.event.RelationMembersChangedEvent;
import org.openstreetmap.josm.data.osm.event.SelectionEventManager;
import org.openstreetmap.josm.data.osm.event.TagsChangedEvent;
import org.openstreetmap.josm.data.osm.event.WayNodesChangedEvent;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.gui.layer.MainLayerManager;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.plugins.turnlanes.gui.GuiContainer;
import org.openstreetmap.josm.plugins.turnlanes.gui.JunctionPane;
import org.openstreetmap.josm.plugins.turnlanes.gui.ValidationPanel;
import org.openstreetmap.josm.plugins.turnlanes.model.ModelContainer;
import org.openstreetmap.josm.tools.I18n;

public class TurnLanesDialog
extends ToggleDialog
implements MainLayerManager.ActiveLayerChangeListener,
DataSelectionListener {
    private final DataSetListener dataSetListener = new DataSetListener(){

        public void wayNodesChanged(WayNodesChangedEvent event) {
            this.refresh();
        }

        public void tagsChanged(TagsChangedEvent event) {
            this.refresh();
        }

        public void relationMembersChanged(RelationMembersChangedEvent event) {
            this.refresh();
        }

        public void primitivesRemoved(PrimitivesRemovedEvent event) {
            this.refresh();
        }

        public void primitivesAdded(PrimitivesAddedEvent event) {
            this.refresh();
        }

        public void otherDatasetChange(AbstractDatasetChangedEvent event) {
            this.refresh();
        }

        public void nodeMoved(NodeMovedEvent event) {
            this.refresh();
        }

        public void dataChanged(DataChangedEvent event) {
            this.refresh();
        }

        private void refresh() {
            if (TurnLanesDialog.this.editing) {
                TurnLanesDialog.this.junctionPane.refresh();
            }
        }
    };
    private final JosmAction editAction = new EditAction();
    private final JosmAction validateAction = new ValidateAction();
    private static final long serialVersionUID = -1998375221636611358L;
    private static final String CARD_EDIT = "EDIT";
    private static final String CARD_VALIDATE = "VALIDATE";
    private final JPanel body = new JPanel();
    private final JunctionPane junctionPane = new JunctionPane(GuiContainer.empty());
    private final JToggleButton editButton = new JToggleButton((Action)this.editAction);
    private final JToggleButton validateButton = new JToggleButton((Action)this.validateAction);
    private final Set<OsmPrimitive> selected = new HashSet<OsmPrimitive>();
    private boolean editing = true;
    private boolean wasShowing = false;

    public TurnLanesDialog() {
        super(I18n.tr((String)"Turn Lanes", (Object[])new Object[0]), "turnlanes.png", I18n.tr((String)"Edit turn lanes", (Object[])new Object[0]), null, 200);
        MainApplication.getLayerManager().addActiveLayerChangeListener((MainLayerManager.ActiveLayerChangeListener)this);
        SelectionEventManager.getInstance().addSelectionListener((DataSelectionListener)this);
        JPanel buttonPanel = new JPanel(new GridLayout(1, 2, 4, 4));
        ButtonGroup group = new ButtonGroup();
        group.add(this.editButton);
        group.add(this.validateButton);
        buttonPanel.add(this.editButton);
        buttonPanel.add(this.validateButton);
        this.body.setLayout(new CardLayout(4, 4));
        this.add(buttonPanel, "South");
        this.add(this.body, "Center");
        this.body.add((Component)this.junctionPane, CARD_EDIT);
        this.body.add((Component)new ValidationPanel(), CARD_VALIDATE);
        this.editButton.doClick();
    }

    protected void stateChanged() {
        if (this.isShowing && !this.wasShowing) {
            this.refresh();
        }
        this.wasShowing = this.isShowing;
    }

    void refresh() {
        if (this.isShowing && this.editing) {
            Collection<OsmPrimitive> s = Collections.unmodifiableCollection(this.selected);
            List nodes = OsmPrimitive.getFilteredList(s, Node.class);
            List ways = OsmPrimitive.getFilteredList(s, Way.class);
            ModelContainer mc = nodes.isEmpty() ? ModelContainer.empty() : ModelContainer.createEmpty(nodes, ways);
            this.junctionPane.setJunction(new GuiContainer(mc));
        }
    }

    public void activeOrEditLayerChanged(MainLayerManager.ActiveLayerChangeEvent e) {
        OsmDataLayer newLayer;
        OsmDataLayer oldLayer = e.getPreviousDataLayer();
        if (oldLayer != null) {
            oldLayer.getDataSet().removeDataSetListener(this.dataSetListener);
        }
        if ((newLayer = MainApplication.getLayerManager().getEditLayer()) != null) {
            newLayer.getDataSet().addDataSetListener(this.dataSetListener);
        }
    }

    public void selectionChanged(DataSelectionListener.SelectionChangeEvent event) {
        if (this.selected.equals(new HashSet(event.getSelection()))) {
            return;
        }
        this.selected.clear();
        this.selected.addAll(event.getSelection());
        this.refresh();
    }

    public void destroy() {
        super.destroy();
        MainApplication.getLayerManager().removeActiveLayerChangeListener((MainLayerManager.ActiveLayerChangeListener)this);
        SelectionEventManager.getInstance().removeSelectionListener((DataSelectionListener)this);
        this.editAction.destroy();
        this.validateAction.destroy();
    }

    private class ValidateAction
    extends JosmAction {
        private static final long serialVersionUID = 7510740945725851427L;

        ValidateAction() {
            super(I18n.tr((String)"Validate", (Object[])new Object[0]), "dialogs/validator", I18n.tr((String)"Validate turn- and lane-length-relations for consistency.", (Object[])new Object[0]), null, false);
        }

        public void actionPerformed(ActionEvent e) {
            CardLayout cl = (CardLayout)TurnLanesDialog.this.body.getLayout();
            cl.show(TurnLanesDialog.this.body, TurnLanesDialog.CARD_VALIDATE);
            TurnLanesDialog.this.editing = false;
            TurnLanesDialog.this.validateButton.setSelected(true);
        }
    }

    private class EditAction
    extends JosmAction {
        private static final long serialVersionUID = 4114119073563457706L;

        EditAction() {
            super(I18n.tr((String)"Edit", (Object[])new Object[0]), "dialogs/edit", I18n.tr((String)"Edit turn relations and lane lengths for selected node.", (Object[])new Object[0]), null, false);
        }

        public void actionPerformed(ActionEvent e) {
            CardLayout cl = (CardLayout)TurnLanesDialog.this.body.getLayout();
            cl.show(TurnLanesDialog.this.body, TurnLanesDialog.CARD_EDIT);
            TurnLanesDialog.this.editing = true;
            TurnLanesDialog.this.editButton.setSelected(true);
            TurnLanesDialog.this.refresh();
        }
    }
}

