/*
 * Decompiled with CFR 0.152.
 */
package CreateGridOfWaysPlugin;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.LinkedList;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.UndoRedoHandler;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Shortcut;

public final class CreateGridOfWaysAction
extends JosmAction {
    public CreateGridOfWaysAction() {
        super(I18n.tr((String)"Create grid of ways", (Object[])new Object[0]), "creategridofways", I18n.tr((String)"Forms a grid of ways in base to two existing that have various nodes and one in common", (Object[])new Object[0]), Shortcut.registerShortcut((String)"tools:CreateGridOfWays", (String)I18n.tr((String)"Tool: {0}", (Object[])new Object[]{I18n.tr((String)"Create grid of ways", (Object[])new Object[0])}), (int)71, (int)5005), true);
    }

    public void actionPerformed(ActionEvent e) {
        int c;
        DataSet ds = this.getLayerManager().getEditDataSet();
        Collection sel = ds.getSelected();
        LinkedList nodesWay1 = new LinkedList();
        LinkedList nodesWay2 = new LinkedList();
        if (sel.size() != 2 || !(sel.toArray()[0] instanceof Way) || !(sel.toArray()[1] instanceof Way)) {
            JOptionPane.showMessageDialog((Component)MainApplication.getMainFrame(), I18n.tr((String)"Select two ways with a node in common", (Object[])new Object[0]));
            return;
        }
        nodesWay1.addAll(((Way)sel.toArray()[0]).getNodes());
        nodesWay2.addAll(((Way)sel.toArray()[1]).getNodes());
        Node nodeCommon = null;
        for (Node n : nodesWay1) {
            for (Node m : nodesWay2) {
                if (!n.equals((Object)m)) continue;
                if (nodeCommon != null) {
                    JOptionPane.showMessageDialog((Component)MainApplication.getMainFrame(), I18n.tr((String)"Select two ways with alone a node in common", (Object[])new Object[0]));
                    return;
                }
                nodeCommon = n;
            }
        }
        if (nodeCommon == null) {
            Logging.error((String)"Cannot find common node");
            return;
        }
        Way[] w2 = new Way[nodesWay2.size() - 1];
        for (int c2 = 0; c2 < w2.length; ++c2) {
            w2[c2] = new Way();
        }
        Way[] w1 = new Way[nodesWay1.size() - 1];
        for (int c3 = 0; c3 < w1.length; ++c3) {
            w1[c3] = new Way();
        }
        LinkedList<AddCommand> cmds = new LinkedList<AddCommand>();
        int c1 = 0;
        LatLon llc = nodeCommon.getCoor();
        for (Node n1 : nodesWay1) {
            LatLon ll1 = n1.getCoor();
            if (ll1 == null || llc == null) {
                Logging.warn((String)"Null coordinates: {0} / {1}", (Object[])new Object[]{n1, nodeCommon});
                continue;
            }
            double latDif = ll1.lat() - llc.lat();
            double lonDif = ll1.lon() - llc.lon();
            int c2 = 0;
            for (Node n2 : nodesWay2) {
                if (n1.equals((Object)nodeCommon) && n2.equals((Object)nodeCommon)) continue;
                if (n2.equals((Object)nodeCommon)) {
                    w1[c1].addNode(n1);
                    continue;
                }
                if (n1.equals((Object)nodeCommon)) {
                    w2[c2++].addNode(n2);
                    continue;
                }
                LatLon ll2 = n2.getCoor();
                Node nodeOfGrid = new Node(new LatLon(ll2.lat() + latDif, ll2.lon() + lonDif));
                cmds.add(new AddCommand(ds, (OsmPrimitive)nodeOfGrid));
                w1[c1].addNode(nodeOfGrid);
                w2[c2++].addNode(nodeOfGrid);
            }
            if (n1.equals((Object)nodeCommon)) continue;
            ++c1;
        }
        for (c = 0; c < w1.length; ++c) {
            cmds.add(new AddCommand(ds, (OsmPrimitive)w1[c]));
        }
        for (c = 0; c < w2.length; ++c) {
            cmds.add(new AddCommand(ds, (OsmPrimitive)w2[c]));
        }
        UndoRedoHandler.getInstance().add((Command)new SequenceCommand(I18n.tr((String)"Create a grid of ways", (Object[])new Object[0]), cmds));
        MainApplication.getMap().repaint();
    }
}

