/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.miscellaneous;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.analysis.CharArrayMap;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.KeywordAttribute;
import org.apache.lucene.util.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StemmerOverrideFilter
extends TokenFilter {
    private final CharArrayMap<String> dictionary;
    private final CharTermAttribute termAtt = this.addAttribute(CharTermAttribute.class);
    private final KeywordAttribute keywordAtt = this.addAttribute(KeywordAttribute.class);

    public StemmerOverrideFilter(Version matchVersion, TokenStream input, Map<?, String> dictionary) {
        super(input);
        this.dictionary = dictionary instanceof CharArrayMap ? (CharArrayMap<String>)dictionary : CharArrayMap.copy(matchVersion, dictionary);
    }

    @Override
    public boolean incrementToken() throws IOException {
        if (this.input.incrementToken()) {
            String stem;
            if (!this.keywordAtt.isKeyword() && (stem = this.dictionary.get(this.termAtt.buffer(), 0, this.termAtt.length())) != null) {
                this.termAtt.setEmpty().append(stem);
                this.keywordAtt.setKeyword(true);
            }
            return true;
        }
        return false;
    }
}

