/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.osmrec.parsers;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import org.geotools.geometry.jts.JTS;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeocentricCRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import org.openstreetmap.josm.plugins.osmrec.container.OSMNode;
import org.openstreetmap.josm.plugins.osmrec.container.OSMRelation;
import org.openstreetmap.josm.plugins.osmrec.container.OSMWay;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.XmlUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class OSMParser
extends DefaultHandler {
    private static final CoordinateReferenceSystem sourceCRS = DefaultGeographicCRS.WGS84;
    private static final CoordinateReferenceSystem targetCRS = DefaultGeocentricCRS.CARTESIAN;
    private final GeometryFactory geometryFactory = new GeometryFactory();
    private static MathTransform transform = null;
    private final List<OSMNode> nodeList;
    private final List<OSMRelation> relationList;
    private final Map<String, OSMNode> nodesWithIDs;
    private final List<OSMWay> wayList;
    private final String osmXmlFileName;
    private OSMNode nodeTmp;
    private OSMWay wayTmp;
    private OSMRelation relationTmp;
    private boolean inWay = false;
    private boolean inNode = false;
    private boolean inRelation = false;

    public OSMParser(String osmXmlFileName) {
        this.osmXmlFileName = osmXmlFileName;
        this.nodeList = new ArrayList<OSMNode>();
        this.wayList = new ArrayList<OSMWay>();
        this.relationList = new ArrayList<OSMRelation>();
        this.nodesWithIDs = new HashMap<String, OSMNode>();
        try {
            transform = CRS.findMathTransform((CoordinateReferenceSystem)sourceCRS, (CoordinateReferenceSystem)targetCRS, (boolean)true);
        }
        catch (FactoryException ex) {
            Logger.getLogger(OSMParser.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void parseDocument() {
        try {
            XmlUtils.newSafeSAXParser().parse(this.osmXmlFileName, (DefaultHandler)this);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            Logging.error((Throwable)e);
        }
    }

    @Override
    public void startElement(String s, String s1, String elementName, Attributes attributes) throws SAXException {
        if (elementName.equalsIgnoreCase("node")) {
            this.nodeTmp = new OSMNode();
            this.nodeTmp.setID(attributes.getValue("id"));
            this.nodeTmp.setUser(attributes.getValue("user"));
            double longitude = Double.parseDouble(attributes.getValue("lon"));
            double latitude = Double.parseDouble(attributes.getValue("lat"));
            Coordinate targetGeometry = null;
            Coordinate sourceCoordinate = new Coordinate(longitude, latitude);
            try {
                targetGeometry = JTS.transform((Coordinate)sourceCoordinate, null, (MathTransform)transform);
            }
            catch (MismatchedDimensionException | TransformException ex) {
                Logger.getLogger(OSMParser.class.getName()).log(Level.SEVERE, null, ex);
            }
            Point geom = this.geometryFactory.createPoint(new Coordinate(targetGeometry));
            this.nodeTmp.setGeometry((Geometry)geom);
            this.inNode = true;
            this.inWay = false;
            this.inRelation = false;
        } else if (elementName.equalsIgnoreCase("way")) {
            this.wayTmp = new OSMWay();
            this.wayTmp.setID(attributes.getValue("id"));
            if (attributes.getValue("user") != null) {
                this.wayTmp.setUser(attributes.getValue("user"));
            } else {
                this.wayTmp.setUser("undefined");
            }
            this.inWay = true;
            this.inNode = false;
            this.inRelation = false;
        } else if (elementName.equalsIgnoreCase("relation")) {
            this.relationTmp = new OSMRelation();
            this.relationTmp.setID(attributes.getValue("id"));
            this.inRelation = true;
            this.inWay = false;
            this.inNode = false;
        } else if (elementName.equalsIgnoreCase("nd")) {
            this.wayTmp.addNodeReference(attributes.getValue("ref"));
        } else if (elementName.equalsIgnoreCase("tag")) {
            if (this.inNode) {
                this.nodeTmp.setTagKeyValue(attributes.getValue("k"), attributes.getValue("v"));
            } else if (this.inWay) {
                this.wayTmp.setTagKeyValue(attributes.getValue("k"), attributes.getValue("v"));
            } else if (this.inRelation) {
                this.relationTmp.setTagKeyValue(attributes.getValue("k"), attributes.getValue("v"));
            }
        } else if (elementName.equalsIgnoreCase("member")) {
            this.relationTmp.addMemberReference(attributes.getValue("ref"));
        }
    }

    @Override
    public void endElement(String s, String s1, String element) throws SAXException {
        if (element.equalsIgnoreCase("node")) {
            this.nodeList.add(this.nodeTmp);
            this.nodesWithIDs.put(this.nodeTmp.getID(), this.nodeTmp);
        }
        if (element.equalsIgnoreCase("way")) {
            List<String> references = this.wayTmp.getNodeReferences();
            for (String entry : references) {
                Geometry geometry = this.nodesWithIDs.get(entry).getGeometry();
                this.wayTmp.addNodeGeometry(geometry);
            }
            Geometry geom = this.geometryFactory.buildGeometry(this.wayTmp.getNodeGeometries());
            if (this.wayTmp.getNumberOfNodes() > 3 && this.wayTmp.getNodeGeometries().get(0).equals(this.wayTmp.getNodeGeometries().get(this.wayTmp.getNodeGeometries().size() - 1))) {
                LinearRing linear;
                if (!this.wayTmp.getTagKeyValue().containsKey("barrier") && !this.wayTmp.getTagKeyValue().containsKey("highway")) {
                    linear = this.geometryFactory.createLinearRing(geom.getCoordinates());
                    Polygon poly = new Polygon(linear, null, this.geometryFactory);
                    this.wayTmp.setGeometry((Geometry)poly);
                } else {
                    linear = this.geometryFactory.createLinearRing(geom.getCoordinates());
                    this.wayTmp.setGeometry((Geometry)linear);
                }
            } else if (this.wayTmp.getNumberOfNodes() > 1) {
                LineString lineString = this.geometryFactory.createLineString(geom.getCoordinates());
                this.wayTmp.setGeometry((Geometry)lineString);
            } else {
                Point point = this.geometryFactory.createPoint(geom.getCoordinate());
                this.wayTmp.setGeometry((Geometry)point);
            }
            this.wayList.add(this.wayTmp);
        }
        if (element.equalsIgnoreCase("relation")) {
            this.relationList.add(this.relationTmp);
        }
    }

    public List<OSMNode> getNodeList() {
        return this.nodeList;
    }

    public List<OSMWay> getWayList() {
        return this.wayList;
    }

    public List<OSMRelation> getRelationList() {
        return this.relationList;
    }

    public Map<String, OSMNode> getNodesWithIDs() {
        return this.nodesWithIDs;
    }
}

