/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.formula.function;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.poi.hssf.record.formula.function.FunctionMetadata;
import org.apache.poi.hssf.record.formula.function.FunctionMetadataRegistry;

final class FunctionDataBuilder {
    private int _maxFunctionIndex = -1;
    private final Map<String, FunctionMetadata> _functionDataByName;
    private final Map<Integer, FunctionMetadata> _functionDataByIndex;
    private final Set<Integer> _mutatingFunctionIndexes;

    public FunctionDataBuilder(int n) {
        this._functionDataByName = new HashMap<String, FunctionMetadata>(n * 3 / 2);
        this._functionDataByIndex = new HashMap<Integer, FunctionMetadata>(n * 3 / 2);
        this._mutatingFunctionIndexes = new HashSet<Integer>();
    }

    public void add(int n, String string, int n2, int n3, byte by, byte[] byArray, boolean bl) {
        FunctionMetadata functionMetadata;
        FunctionMetadata functionMetadata2 = new FunctionMetadata(n, string, n2, n3, by, byArray);
        Integer n4 = n;
        if (n > this._maxFunctionIndex) {
            this._maxFunctionIndex = n;
        }
        if ((functionMetadata = this._functionDataByName.get(string)) != null) {
            if (!bl || !this._mutatingFunctionIndexes.contains(n4)) {
                throw new RuntimeException("Multiple entries for function name '" + string + "'");
            }
            this._functionDataByIndex.remove(functionMetadata.getIndex());
        }
        if ((functionMetadata = this._functionDataByIndex.get(n4)) != null) {
            if (!bl || !this._mutatingFunctionIndexes.contains(n4)) {
                throw new RuntimeException("Multiple entries for function index (" + n + ")");
            }
            this._functionDataByName.remove(functionMetadata.getName());
        }
        if (bl) {
            this._mutatingFunctionIndexes.add(n4);
        }
        this._functionDataByIndex.put(n4, functionMetadata2);
        this._functionDataByName.put(string, functionMetadata2);
    }

    public FunctionMetadataRegistry build() {
        FunctionMetadata[] functionMetadataArray = new FunctionMetadata[this._functionDataByName.size()];
        this._functionDataByName.values().toArray(functionMetadataArray);
        FunctionMetadata[] functionMetadataArray2 = new FunctionMetadata[this._maxFunctionIndex + 1];
        for (int i = 0; i < functionMetadataArray.length; ++i) {
            FunctionMetadata functionMetadata;
            functionMetadataArray2[functionMetadata.getIndex()] = functionMetadata = functionMetadataArray[i];
        }
        return new FunctionMetadataRegistry(functionMetadataArray2, this._functionDataByName);
    }
}

