/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.JunctionChecker;

import java.awt.Component;
import java.io.IOException;
import java.util.Iterator;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.DataSource;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.plugins.JunctionChecker.ChannelDiGraphLayer;
import org.openstreetmap.josm.plugins.JunctionChecker.JunctionCheckerPlugin;
import org.openstreetmap.josm.plugins.JunctionChecker.connectedness.DiGraphSealer;
import org.openstreetmap.josm.plugins.JunctionChecker.connectedness.StrongConnectednessCalculator;
import org.openstreetmap.josm.plugins.JunctionChecker.converting.ChannelDigraphBuilder;
import org.openstreetmap.josm.plugins.JunctionChecker.datastructure.OSMGraph;
import org.openstreetmap.josm.plugins.JunctionChecker.filter.ExecuteFilter;
import org.openstreetmap.josm.plugins.JunctionChecker.reader.XMLFilterReader;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.SAXException;

public class DigraphCreationTask
extends PleaseWaitRunnable {
    private final JunctionCheckerPlugin plugin;
    private final boolean sealGraph;
    private boolean canceled;
    private final boolean calculateSCC;
    private static final String WAYFILTERFILE = "/resources/xml/waysfilter.xml";

    public DigraphCreationTask(JunctionCheckerPlugin plugin, boolean sealGraph, boolean calculateSCC) {
        super(I18n.tr((String)"Create Channel Digraph", (Object[])new Object[0]), false);
        this.plugin = plugin;
        this.sealGraph = sealGraph;
        this.calculateSCC = calculateSCC;
    }

    protected void cancel() {
        this.canceled = true;
        this.progressMonitor.cancel();
    }

    protected void finish() {
        if (this.canceled) {
            this.removeDigraphLayer();
        }
    }

    private void removeDigraphLayer() {
        ChannelDiGraphLayer layer = this.plugin.getChannelDigraphLayer();
        if (MainApplication.getLayerManager().containsLayer((Layer)layer)) {
            MainApplication.getLayerManager().removeLayer((Layer)layer);
        }
    }

    protected void realRun() throws SAXException, IOException, OsmTransferException {
        if (MainApplication.getMap() == null || !MainApplication.getMap().isVisible() || !(MainApplication.getLayerManager().getActiveLayer() instanceof OsmDataLayer)) {
            JOptionPane.showMessageDialog((Component)MainApplication.getMainFrame(), I18n.tr((String)"this layer is no osm data layer", (Object[])new Object[0]));
            return;
        }
        this.removeDigraphLayer();
        int tickscounter = 4;
        if (this.sealGraph) {
            ++tickscounter;
        }
        if (this.calculateSCC) {
            ++tickscounter;
        }
        this.getProgressMonitor().setTicksCount(tickscounter);
        tickscounter = 1;
        this.getProgressMonitor().subTask(I18n.tr((String)"Converting OSM graph into Channel Digraph", (Object[])new Object[0]));
        this.getProgressMonitor().setTicks(tickscounter++);
        OSMGraph graph = new OSMGraph();
        this.plugin.setOsmlayer((OsmDataLayer)MainApplication.getLayerManager().getActiveLayer());
        DataSet ds = MainApplication.getLayerManager().getEditDataSet();
        Iterator it = ds.getNodes().iterator();
        while (it.hasNext()) {
            graph.addNode((Node)it.next());
        }
        Iterator itway = ds.getWays().iterator();
        while (itway.hasNext()) {
            graph.addWay((Way)itway.next());
        }
        Iterator itrel = ds.getRelations().iterator();
        while (itrel.hasNext()) {
            graph.addRelation((Relation)itrel.next());
        }
        Iterator itdata = ds.getDataSources().iterator();
        while (itdata.hasNext()) {
            Bounds b = ((DataSource)itdata.next()).bounds;
            graph.setBbbottom(b.getMin().getY());
            graph.setBbleft(b.getMin().getX());
            graph.setBbright(b.getMax().getX());
            graph.setBbtop(b.getMax().getY());
        }
        this.getProgressMonitor().subTask(I18n.tr((String)"filtering ways", (Object[])new Object[0]));
        this.getProgressMonitor().setTicks(tickscounter++);
        XMLFilterReader reader = new XMLFilterReader(WAYFILTERFILE);
        reader.parseXML();
        ExecuteFilter ef = new ExecuteFilter(reader.getFilters(), graph);
        ef.filter();
        this.getProgressMonitor().subTask(I18n.tr((String)"creating Channel-Digraph", (Object[])new Object[0]));
        this.getProgressMonitor().setTicks(tickscounter++);
        ChannelDigraphBuilder cdgb = new ChannelDigraphBuilder(ef.getOutgoinggraph());
        cdgb.buildChannelDigraph();
        StrongConnectednessCalculator scc = new StrongConnectednessCalculator(cdgb.getDigraph());
        if (this.sealGraph) {
            this.getProgressMonitor().subTask(I18n.tr((String)"sealing Digraph", (Object[])new Object[0]));
            this.getProgressMonitor().setTicks(tickscounter++);
            DiGraphSealer sealer = new DiGraphSealer(cdgb.getDigraph(), cdgb.getNewid());
            sealer.sealingGraph();
        }
        if (this.calculateSCC) {
            this.getProgressMonitor().subTask(I18n.tr((String)"calculating Strong Connectedness", (Object[])new Object[0]));
            this.getProgressMonitor().setTicks(tickscounter++);
            scc.calculateSCC();
        }
        this.getProgressMonitor().subTask(I18n.tr((String)"creating DigraphLayer", (Object[])new Object[0]));
        this.getProgressMonitor().setTicks(tickscounter++);
        this.plugin.setChannelDigraph(cdgb.getDigraph());
        this.plugin.getOsmlayer().setBackgroundLayer(true);
        this.plugin.getChannelDigraphLayer().setDigraph(cdgb.getDigraph());
        this.plugin.setChannelDigraph(cdgb.getDigraph());
        this.plugin.getJcMapMode().setDigraph(cdgb.getDigraph());
        this.plugin.setNormalMapMode(MainApplication.getMap().mapMode);
        MainApplication.getMap().selectMapMode((MapMode)this.plugin.getJcMapMode());
        MainApplication.getLayerManager().addLayer((Layer)this.plugin.getChannelDigraphLayer());
        MainApplication.getLayerManager().setActiveLayer((Layer)this.plugin.getChannelDigraphLayer());
    }
}

