/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.aggregates;

import java.util.ArrayList;
import java.util.List;
import org.apache.poi.hssf.model.RecordStream;
import org.apache.poi.hssf.record.DVALRecord;
import org.apache.poi.hssf.record.DVRecord;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.aggregates.RecordAggregate;

public final class DataValidityTable
extends RecordAggregate {
    private final DVALRecord _headerRec;
    private final List<Record> _validationList;

    public DataValidityTable(RecordStream recordStream) {
        this._headerRec = (DVALRecord)recordStream.getNext();
        ArrayList<Record> arrayList = new ArrayList<Record>();
        while (recordStream.peekNextClass() == DVRecord.class) {
            arrayList.add(recordStream.getNext());
        }
        this._validationList = arrayList;
    }

    public DataValidityTable() {
        this._headerRec = new DVALRecord();
        this._validationList = new ArrayList<Record>();
    }

    @Override
    public void visitContainedRecords(RecordAggregate.RecordVisitor recordVisitor) {
        if (this._validationList.isEmpty()) {
            return;
        }
        recordVisitor.visitRecord(this._headerRec);
        for (int i = 0; i < this._validationList.size(); ++i) {
            recordVisitor.visitRecord(this._validationList.get(i));
        }
    }
}

