/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.fr.cadastre.edigeo.pci;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.WordUtils;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.UploadPolicy;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.AbstractReader;
import org.openstreetmap.josm.io.IllegalDataException;
import org.openstreetmap.josm.plugins.fr.cadastre.download.CadastreDownloadData;
import org.openstreetmap.josm.plugins.fr.cadastre.edigeo.EdigeoFileTHF;
import org.openstreetmap.josm.plugins.fr.cadastre.edigeo.EdigeoFileVEC;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;

public class EdigeoPciReader
extends AbstractReader {
    private static final BiPredicate<CadastreDownloadData, OsmPrimitive> water = (x, p) -> !x.isDownloadWater();
    private static final BiPredicate<CadastreDownloadData, OsmPrimitive> build = (x, p) -> !x.isDownloadBuilding();
    private static final BiPredicate<CadastreDownloadData, OsmPrimitive> symbo = (x, p) -> !x.isDownloadSymbol();
    private static final BiPredicate<CadastreDownloadData, OsmPrimitive> parce = (x, p) -> !x.isDownloadParcel();
    private static final BiPredicate<CadastreDownloadData, OsmPrimitive> addre = (x, p) -> !x.isDownloadAddress();
    private static final BiPredicate<CadastreDownloadData, OsmPrimitive> local = (x, p) -> !x.isDownloadLocality();
    private static final BiPredicate<CadastreDownloadData, OsmPrimitive> commu = (x, p) -> !x.isDownloadCommune();
    private static final Map<String, List<String>> highways = new HashMap<String, List<String>>();

    private static void setName(OsmPrimitive p, String input) {
        if (input != null) {
            String name = input.replaceAll("    ", " ").replaceAll("   ", " ").replaceAll("  ", " ");
            if (name.matches("([A-Za-z] )+[A-Za-z]")) {
                name = name.replaceAll(" ", "");
            }
            if (name.length() > 2 && StringUtils.isAllUpperCase((CharSequence)name.replaceAll(" ", "").replaceAll("'", "").replaceAll("-", ""))) {
                name = WordUtils.capitalizeFully((String)name);
            }
            p.put("name", name);
        }
    }

    private static boolean setCorrectHighway(OsmPrimitive p, String[] words) {
        String type = words[0];
        for (Map.Entry<String, List<String>> e : highways.entrySet()) {
            if (!e.getValue().contains(type)) continue;
            p.put("highway", e.getKey());
            return true;
        }
        return false;
    }

    static DataSet parseDataSet(InputStream in, File file, CadastreDownloadData data, ProgressMonitor instance) throws IOException {
        if (in != null) {
            in.close();
        }
        try {
            return new EdigeoPciReader().parse(file.toPath(), data, instance);
        }
        catch (IOException e) {
            throw e;
        }
        catch (AssertionError | Exception e) {
            Logging.error((Throwable)e);
            throw new IOException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DataSet parse(Path path, CadastreDownloadData data, ProgressMonitor instance) throws IOException, ReflectiveOperationException {
        Path tmpDir = null;
        Path thfPath = path;
        try {
            if (thfPath.toString().endsWith(".tar.bz2")) {
                try (InputStream fin = Files.newInputStream(path, new OpenOption[0]);
                     BufferedInputStream in = new BufferedInputStream(fin);
                     BZip2CompressorInputStream bzIn = new BZip2CompressorInputStream((InputStream)in);
                     TarArchiveInputStream tar = new TarArchiveInputStream((InputStream)bzIn);){
                    TarArchiveEntry entry;
                    tmpDir = Files.createTempDirectory(Utils.getJosmTempDir().toPath(), "cadastre", new FileAttribute[0]);
                    while ((entry = tar.getNextTarEntry()) != null) {
                        File file = tmpDir.resolve(entry.getName()).toFile();
                        try (FileOutputStream out = new FileOutputStream(file);){
                            if (IOUtils.copy((InputStream)tar, (OutputStream)out) < entry.getSize()) {
                                throw new IOException(String.format("Unable to write ''%s'' entirely", file));
                            }
                            if (!file.toString().endsWith(".THF")) continue;
                            thfPath = file.toPath();
                        }
                    }
                }
            }
            DataSet ds = new DataSet();
            ds.setUploadPolicy(UploadPolicy.BLOCKED);
            EdigeoFileTHF thf = new EdigeoFileTHF(thfPath).read().fill(ds, data);
            ds.setName(thf.getSupport().getBlockIdentifier());
            DataSet dataSet = ds;
            return dataSet;
        }
        finally {
            if (tmpDir != null) {
                Utils.deleteDirectory((File)tmpDir.toFile());
            }
        }
    }

    protected DataSet doParseDataSet(InputStream source, ProgressMonitor progressMonitor) throws IllegalDataException {
        return null;
    }

    static {
        highways.put("motorway", Arrays.asList("Autoroute"));
        highways.put("trunk", Arrays.asList("Rocade"));
        highways.put("secondary", Arrays.asList("Avenue", "Boulevard", "Allee", "All\u00e9e", "Allees", "All\u00e9es", "Pont", "Port", "Route"));
        highways.put("residential", Arrays.asList("Chemin", "Impasse", "Place", "Rue", "Quai", "Voie", "Grand Rue"));
        EdigeoFileVEC.addIgnoredScdObjects("PTCANV_id", "BORNE_id", "BOULON_id", "CROIX_id", "SYMBLIM_id");
        EdigeoFileVEC.addIgnoredObject("SYM_id", "30", "31", "32", "62", "64", "98");
        EdigeoFileVEC.addObjectPostProcessor("12", symbo, "historic=wayside_cross");
        EdigeoFileVEC.addObjectPostProcessor("14", symbo, "amenity=place_of_worship;religion=christian");
        EdigeoFileVEC.addObjectPostProcessor("15", symbo, "amenity=place_of_worship;religion=muslim");
        EdigeoFileVEC.addObjectPostProcessor("16", symbo, "amenity=place_of_worship;religion=jewish");
        EdigeoFileVEC.addObjectPostProcessor("17", commu, "boundary=administrative;admin_level=2");
        EdigeoFileVEC.addObjectPostProcessor("18", commu, "boundary=administrative;admin_level=6");
        EdigeoFileVEC.addObjectPostProcessor("19", commu, "boundary=administrative;admin_level=8");
        EdigeoFileVEC.addObjectPostProcessor("21", symbo, "highway=road");
        EdigeoFileVEC.addObjectPostProcessor("22", symbo, "highway=road");
        EdigeoFileVEC.addObjectPostProcessor((o, p) -> {
            String highwayValue = "path";
            if (p instanceof Way) {
                Way w = (Way)p;
                Predicate<Way> isBuilding = x -> x.hasKey("building");
                if (w.firstNode().getParentWays().stream().anyMatch(isBuilding) || w.lastNode().getParentWays().stream().anyMatch(isBuilding)) {
                    highwayValue = "footway";
                }
            }
            p.put("highway", highwayValue);
            p.remove("SYM_id");
        }, symbo, "SYM_id", "23");
        EdigeoFileVEC.addObjectPostProcessor("24", symbo, "man_made=pipeline");
        EdigeoFileVEC.addObjectPostProcessor("25", symbo, "man_made=pipeline");
        EdigeoFileVEC.addObjectPostProcessor("26", symbo, "aerialway=cable_car");
        EdigeoFileVEC.addObjectPostProcessor("27", symbo, "power=line");
        EdigeoFileVEC.addObjectPostProcessor("29", symbo, "railway=rail");
        EdigeoFileVEC.addObjectPostProcessor("33", symbo, "bridge=yes");
        EdigeoFileVEC.addObjectPostProcessor("34", water, "landuse=reservoir;natural=water;water=reservoir");
        EdigeoFileVEC.addObjectPostProcessor("37", symbo, "tunnel=yes");
        EdigeoFileVEC.addObjectPostProcessor("47", symbo, "railway=halt");
        EdigeoFileVEC.addObjectPostProcessor("48", symbo, "railway=stop");
        EdigeoFileVEC.addObjectPostProcessor("49", symbo, "railway=station");
        EdigeoFileVEC.addObjectPostProcessor("50", symbo, "man_made=mast");
        EdigeoFileVEC.addObjectPostProcessor("51", symbo, "landuse=cemetery;religion=christian");
        EdigeoFileVEC.addObjectPostProcessor("52", symbo, "landuse=cemetery;religion=muslim");
        EdigeoFileVEC.addObjectPostProcessor("53", symbo, "landuse=cemetery;religion=jewish");
        EdigeoFileVEC.addObjectPostProcessor("63", symbo, "man_made=water_well");
        EdigeoFileVEC.addObjectPostProcessor("65", water, "leisure=swimming_pool;access=private");
        EdigeoFileVEC.addObjectPostProcessor((o, p) -> {
            String t;
            String v;
            StringBuffer sb = new StringBuffer(p.get("TEX_id").trim());
            p.remove("TEX_id");
            Iterator<String> iterator = Arrays.asList("TEX2_id", "TEX3_id", "TEX4_id", "TEX5_id", "TEX6_id", "TEX7_id", "TEX8_id", "TEX9_id").iterator();
            while (iterator.hasNext() && (v = p.get(t = iterator.next())) != null) {
                sb.append(' ').append(v.trim());
                p.remove(t);
            }
            EdigeoPciReader.setName(p, sb.toString());
        }, (x, p) -> false, "TEX_id", new String[0]);
        EdigeoFileVEC.addObjectPostProcessor((o, p) -> {
            String[] words;
            p.put("highway", "road");
            String name = p.get("name");
            if (name != null && name.contains(" ") && !EdigeoPciReader.setCorrectHighway(p, words = name.split(" ")) && highways.values().stream().anyMatch(l -> l.contains(words[words.length - 1]))) {
                CharSequence[] newWords = new String[words.length];
                newWords[0] = words[words.length - 1];
                System.arraycopy(words, 0, newWords, 1, words.length - 1);
                p.put("name", String.join((CharSequence)" ", newWords));
                EdigeoPciReader.setCorrectHighway(p, (String[])newWords);
            }
        }, o -> o.hasScdIdentifier("ZONCOMMUNI_id"), symbo);
        EdigeoFileVEC.addObjectPostProcessor((o, p) -> {
            p.put("boundary", "administrative");
            p.put("admin_level", "8");
            p.put("ref:INSEE", "XX" + p.get("IDU_id"));
            p.put("name", WordUtils.capitalizeFully((String)p.get("TEX2_id")));
            p.remove("IDU_id");
            p.remove("TEX2_id");
        }, o -> o.hasScdIdentifier("COMMUNE_id"), commu);
        EdigeoFileVEC.addObjectPostProcessor((o, p) -> {
            p.put("boundary", "cadastral");
            p.put("ref", p.get("IDU_id"));
            p.remove("IDU_id");
            p.remove("ICL_id");
            p.remove("COAR_id");
            p.remove("COPL_id");
            p.remove("DEDI_id");
            p.remove("DIS_id");
            p.remove("DRED_id");
            p.remove("EOR_id");
            p.remove("INDP_id");
            p.remove("INP_id");
            p.remove("QUPL_id");
            p.remove("SUPF_id");
        }, o -> o.hasScdIdentifier("SECTION_id") || o.hasScdIdentifier("SUBDSECT_id") || o.hasScdIdentifier("PARCELLE_id") || o.hasScdIdentifier("SUBDFISC_id") || o.hasScdIdentifier("CHARGE_id"), parce);
        EdigeoFileVEC.addObjectPostProcessor((o, p) -> p.put("wall", "no"), build, "DUR_id", "02");
        EdigeoFileVEC.addObjectPostProcessor((o, p) -> {
            p.put("building", "yes");
            p.remove("DUR_id");
        }, o -> o.hasScdIdentifier("BATIMENT_id"), build);
        EdigeoFileVEC.addObjectPostProcessor((o, p) -> {
            p.put("addr:housenumber", p.get("name"));
            p.remove("name");
        }, o -> o.hasScdIdentifier("NUMVOIE_id"), addre);
        EdigeoFileVEC.addObjectPostProcessor((o, p) -> {
            p.put("place", "unknown");
            p.put("fixme", "place type");
        }, o -> o.hasScdIdentifier("LIEUDIT_id"), local);
        EdigeoFileVEC.addObjectPostProcessor((o, p) -> p.remove("ORI_id"), o -> o.hasScdIdentifier("TPOINT_id"), (x, p) -> false);
        EdigeoFileVEC.addObjectPostProcessor((o, p) -> {
            p.put("highway", "road");
            p.put("area", "yes");
        }, o -> o.hasScdIdentifier("TRONROUTE_id"), symbo);
        EdigeoFileVEC.addObjectPostProcessor((o, p) -> p.put("waterway", "riverbank"), o -> o.hasScdIdentifier("TRONFLUV_id"), water);
        for (String t : Arrays.asList("TEX2_id", "TEX3_id", "TEX4_id", "TEX5_id", "TEX6_id", "TEX7_id", "TEX8_id", "TEX9_id")) {
            EdigeoFileVEC.addObjectPostProcessor((o, p) -> {
                EdigeoPciReader.setName(p, p.get(t));
                p.remove(t);
            }, (x, p) -> false, t, new String[0]);
        }
        EdigeoFileVEC.addObjectPostProcessor((o, p) -> {}, o -> true, (x, p) -> {
            try {
                return !x.isDownloadParcelNumber() && p.getNumKeys() == 1 && p.hasKey("name") && Integer.parseInt(p.get("name")) > -1;
            }
            catch (NumberFormatException e) {
                Logging.trace((Throwable)e);
                return false;
            }
        });
        EdigeoFileVEC.addObjectPostProcessor((o, p) -> {}, o -> true, (x, p) -> {
            try {
                return !x.isDownloadSymbol() && p.getNumKeys() == 1 && p.hasKey("name") && Integer.parseInt(p.get("name")) <= -1;
            }
            catch (NumberFormatException e) {
                Logging.trace((Throwable)e);
                return true;
            }
        });
    }
}

