/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.keyring.fallback;

import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.keyring.spi.EncryptionProvider;
import org.netbeans.spi.keyring.KeyringProvider;

public class FallbackProvider
implements KeyringProvider {
    private static final Logger LOG = Logger.getLogger(FallbackProvider.class.getName());
    private static final String DESCRIPTION = ".description";
    private static final String SAMPLE_KEY = "__sample__";
    private EncryptionProvider encryption;
    private IPreferences prefs;

    public FallbackProvider(EncryptionProvider encryption, IPreferences prefs) {
        this.encryption = encryption;
        this.prefs = prefs;
    }

    @Override
    public boolean enabled() {
        if (this.encryption.enabled() && this.testSampleKey()) {
            LOG.log(Level.FINE, "Using provider: {0}", this.encryption);
            return true;
        }
        LOG.fine("No provider");
        return false;
    }

    private boolean testSampleKey() {
        this.encryption.freshKeyring(true);
        byte[] randomArray = new byte[36];
        new SecureRandom().nextBytes(randomArray);
        if (this._save(SAMPLE_KEY, (SAMPLE_KEY + new String(randomArray, StandardCharsets.UTF_8)).toCharArray(), "Sample value ensuring that decryption is working.")) {
            LOG.fine("saved sample key");
            return true;
        }
        LOG.fine("could not save sample key");
        return false;
    }

    @Override
    public char[] read(String key) {
        byte[] ciphertext = this.prefs.getByteArray(key, null);
        if (ciphertext == null) {
            return null;
        }
        try {
            return this.encryption.decrypt(ciphertext);
        }
        catch (Exception x) {
            LOG.log(Level.FINE, "failed to decrypt password for " + key, x);
            return null;
        }
    }

    @Override
    public void save(String key, char[] password, String description) {
        this._save(key, password, description);
    }

    private boolean _save(String key, char[] password, String description) {
        try {
            this.prefs.putByteArray(key, this.encryption.encrypt(password));
        }
        catch (Exception x) {
            LOG.log(Level.FINE, "failed to encrypt password for " + key, x);
            return false;
        }
        return true;
    }

    @Override
    public void delete(String key) {
        this.prefs.remove(key);
        this.prefs.remove(key + DESCRIPTION);
    }

    public static interface IPreferences {
        public byte[] getByteArray(String var1, byte[] var2);

        public void putByteArray(String var1, byte[] var2);

        public void remove(String var1);
    }
}

