/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapdust.service.value;

import java.io.Serializable;
import java.util.HashMap;
import org.openstreetmap.josm.plugins.mapdust.service.value.RelevanceRange;

public class MapdustRelevance
implements Serializable,
Comparable<MapdustRelevance> {
    private static final long serialVersionUID = 8910563589536711954L;
    public static final MapdustRelevance LOW = new MapdustRelevance("Low", RelevanceRange.LOW_RANGE);
    public static final MapdustRelevance MID_LOW = new MapdustRelevance("Mid-Low", RelevanceRange.MID_LOW_RANGE);
    public static final MapdustRelevance MEDIUM = new MapdustRelevance("Medium", RelevanceRange.MEDIUM_RANGE);
    public static final MapdustRelevance MID_HIGH = new MapdustRelevance("Mid-High", RelevanceRange.MID_HIGH_RANGE);
    public static final MapdustRelevance HIGH = new MapdustRelevance("High", RelevanceRange.HIGH_RANGE);
    private String name;
    private RelevanceRange range;
    private static HashMap<RelevanceRange, MapdustRelevance> map;

    public MapdustRelevance() {
    }

    public MapdustRelevance(String name, RelevanceRange range) {
        this.name = name;
        this.range = range;
        if (map == null) {
            map = new HashMap();
        }
        map.put(range, this);
    }

    public static MapdustRelevance getMapdustRelevance(int value) {
        RelevanceRange range = RelevanceRange.getRelevanceRange(value);
        if (range != null) {
            MapdustRelevance relevance = map.get(range);
            return relevance;
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public RelevanceRange getRange() {
        return this.range;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.range == null ? 0 : this.range.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        MapdustRelevance other = (MapdustRelevance)obj;
        if (other == null) {
            return false;
        }
        if (this.name == null || other.name == null) {
            return false;
        }
        if (!this.name.equals(other.name)) {
            return false;
        }
        if (this.range == null || other.getRange() == null) {
            return false;
        }
        return this.range.equals(other.range);
    }

    @Override
    public int compareTo(MapdustRelevance obj) {
        if (this.equals(obj)) {
            return 0;
        }
        if (obj == null) {
            return -1;
        }
        return this.getRange().compareTo(obj.getRange());
    }
}

