/*
 * Decompiled with CFR 0.152.
 */
package crosby.binary.test;

import crosby.binary.BinaryParser;
import crosby.binary.Osmformat;
import crosby.binary.file.BlockInputStream;
import java.io.InputStream;
import java.util.List;

public class ReadFileExample {
    public static void main(String[] args) throws Exception {
        InputStream input = ReadFileExample.class.getResourceAsStream("/sample.pbf");
        TestBinaryParser brad = new TestBinaryParser();
        new BlockInputStream(input, brad).process();
    }

    private static class TestBinaryParser
    extends BinaryParser {
        private TestBinaryParser() {
        }

        @Override
        protected void parseRelations(List<Osmformat.Relation> rels) {
            if (!rels.isEmpty()) {
                System.out.println("Got some relations to parse.");
            }
            Object r = null;
        }

        @Override
        protected void parseDense(Osmformat.DenseNodes nodes) {
            long lastId = 0L;
            long lastLat = 0L;
            long lastLon = 0L;
            for (int i = 0; i < nodes.getIdCount(); ++i) {
                System.out.printf("Dense node, ID %d @ %.6f,%.6f\n", lastId += nodes.getId(i), this.parseLat(lastLat += nodes.getLat(i)), this.parseLon(lastLon += nodes.getLon(i)));
            }
        }

        @Override
        protected void parseNodes(List<Osmformat.Node> nodes) {
            for (Osmformat.Node n : nodes) {
                System.out.printf("Regular node, ID %d @ %.6f,%.6f\n", n.getId(), this.parseLat(n.getLat()), this.parseLon(n.getLon()));
            }
        }

        @Override
        protected void parseWays(List<Osmformat.Way> ways) {
            for (Osmformat.Way w : ways) {
                System.out.println("Way ID " + w.getId());
                StringBuilder sb = new StringBuilder();
                sb.append("  Nodes: ");
                long lastRef = 0L;
                for (Long ref : w.getRefsList()) {
                    sb.append(lastRef += ref.longValue()).append(" ");
                }
                sb.append("\n  Key=value pairs: ");
                for (int i = 0; i < w.getKeysCount(); ++i) {
                    sb.append(this.getStringById(w.getKeys(i))).append("=").append(this.getStringById(w.getVals(i))).append(" ");
                }
                System.out.println(sb.toString());
            }
        }

        @Override
        protected void parse(Osmformat.HeaderBlock header) {
            System.out.println("Got header block.");
        }

        @Override
        public void complete() {
            System.out.println("Complete!");
        }
    }
}

