/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.utilsplugin2.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.UndoRedoHandler;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Tag;
import org.openstreetmap.josm.data.osm.TagCollection;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;
import org.openstreetmap.josm.tools.SubclassFilteredCollection;

public class TagBufferAction
extends JosmAction {
    private static final String TITLE = I18n.tr((String)"Copy tags from previous selection", (Object[])new Object[0]);
    private static final TagCollection EmptyTags = new TagCollection();
    private List<OsmPrimitive> selectionBuf = new ArrayList<OsmPrimitive>();
    private TagCollection tagsToPaste = EmptyTags;

    public TagBufferAction() {
        super(TITLE, "dumbutils/tagbuffer", I18n.tr((String)"Pastes tags of previously selected object(s)", (Object[])new Object[0]), Shortcut.registerShortcut((String)"tools:tagbuffer", (String)I18n.tr((String)"Tool: {0}", (Object[])new Object[]{I18n.tr((String)"Copy tags from previous selection", (Object[])new Object[0])}), (int)82, (int)5005), true, false);
        this.installAdapters();
    }

    public void actionPerformed(ActionEvent e) {
        Collection selection = this.getLayerManager().getEditDataSet().getSelected();
        if (selection.isEmpty() || this.tagsToPaste.isEmpty()) {
            return;
        }
        ArrayList<ChangePropertyCommand> commands = new ArrayList<ChangePropertyCommand>();
        for (Tag tag : this.tagsToPaste) {
            boolean foundNew = false;
            for (OsmPrimitive p : selection) {
                if (p.hasTag(tag.getKey(), tag.getValue())) continue;
                foundNew = true;
                break;
            }
            if (!foundNew) continue;
            commands.add(new ChangePropertyCommand(selection, tag.getKey(), tag.getValue()));
        }
        if (!commands.isEmpty()) {
            UndoRedoHandler.getInstance().add((Command)new SequenceCommand(TITLE, commands));
        }
    }

    protected void updateEnabledState() {
        if (this.getLayerManager().getEditDataSet() == null) {
            this.setEnabled(false);
            this.selectionBuf = new ArrayList<OsmPrimitive>();
            this.tagsToPaste = EmptyTags;
        } else {
            this.updateEnabledState(this.getLayerManager().getEditDataSet().getSelected());
        }
    }

    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        TagCollection oldTags = TagBufferAction.getCommonTags(this.selectionBuf);
        if (!oldTags.isEmpty()) {
            this.tagsToPaste = new TagCollection(oldTags);
        }
        this.selectionBuf = new ArrayList<OsmPrimitive>(selection);
        this.setEnabled(!selection.isEmpty() && !this.tagsToPaste.isEmpty());
    }

    private static TagCollection getCommonTags(List<OsmPrimitive> selection) {
        if (selection.isEmpty()) {
            return EmptyTags;
        }
        return TagCollection.commonToAllPrimitives((Collection)SubclassFilteredCollection.filter(selection, p -> p.isTagged()));
    }
}

