/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.util;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.poi.util.LittleEndianInput;

public class LittleEndianInputStream
extends FilterInputStream
implements LittleEndianInput {
    public LittleEndianInputStream(InputStream inputStream) {
        super(inputStream);
    }

    @Override
    public int available() {
        try {
            return super.available();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    @Override
    public byte readByte() {
        return (byte)this.readUByte();
    }

    @Override
    public int readUByte() {
        int n;
        try {
            n = this.in.read();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        LittleEndianInputStream.checkEOF(n);
        return n;
    }

    @Override
    public double readDouble() {
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    public int readInt() {
        int n;
        int n2;
        int n3;
        int n4;
        try {
            n4 = this.in.read();
            n3 = this.in.read();
            n2 = this.in.read();
            n = this.in.read();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        LittleEndianInputStream.checkEOF(n4 | n3 | n2 | n);
        return (n << 24) + (n2 << 16) + (n3 << 8) + (n4 << 0);
    }

    @Override
    public long readLong() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        try {
            n8 = this.in.read();
            n7 = this.in.read();
            n6 = this.in.read();
            n5 = this.in.read();
            n4 = this.in.read();
            n3 = this.in.read();
            n2 = this.in.read();
            n = this.in.read();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        LittleEndianInputStream.checkEOF(n8 | n7 | n6 | n5 | n4 | n3 | n2 | n);
        return ((long)n << 56) + ((long)n2 << 48) + ((long)n3 << 40) + ((long)n4 << 32) + ((long)n5 << 24) + (long)(n6 << 16) + (long)(n7 << 8) + (long)(n8 << 0);
    }

    @Override
    public short readShort() {
        return (short)this.readUShort();
    }

    @Override
    public int readUShort() {
        int n;
        int n2;
        try {
            n2 = this.in.read();
            n = this.in.read();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        LittleEndianInputStream.checkEOF(n2 | n);
        return (n << 8) + (n2 << 0);
    }

    private static void checkEOF(int n) {
        if (n < 0) {
            throw new RuntimeException("Unexpected end-of-file");
        }
    }

    @Override
    public void readFully(byte[] byArray) {
        this.readFully(byArray, 0, byArray.length);
    }

    @Override
    public void readFully(byte[] byArray, int n, int n2) {
        int n3 = n + n2;
        for (int i = n; i < n3; ++i) {
            int n4;
            try {
                n4 = this.in.read();
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
            LittleEndianInputStream.checkEOF(n4);
            byArray[i] = (byte)n4;
        }
    }
}

