/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.poifs.property;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.apache.poi.poifs.property.DirectoryProperty;
import org.apache.poi.poifs.property.Property;
import org.apache.poi.poifs.property.PropertyFactory;
import org.apache.poi.poifs.property.RootProperty;
import org.apache.poi.poifs.storage.BlockWritable;
import org.apache.poi.poifs.storage.RawDataBlockList;

public final class PropertyTable
implements BlockWritable {
    private List<Property> _properties;
    private BlockWritable[] _blocks;

    public PropertyTable() {
        this._properties = new ArrayList<Property>();
        this.addProperty(new RootProperty());
        this._blocks = null;
    }

    public PropertyTable(int n, RawDataBlockList rawDataBlockList) throws IOException {
        this._blocks = null;
        this._properties = PropertyFactory.convertToProperties(rawDataBlockList.fetchBlocks(n, -1));
        this.populatePropertyTree((DirectoryProperty)this._properties.get(0));
    }

    public void addProperty(Property property) {
        this._properties.add(property);
    }

    public void removeProperty(Property property) {
        this._properties.remove(property);
    }

    public RootProperty getRoot() {
        return (RootProperty)this._properties.get(0);
    }

    private void populatePropertyTree(DirectoryProperty directoryProperty) throws IOException {
        int n = directoryProperty.getChildIndex();
        if (!Property.isValidIndex(n)) {
            return;
        }
        Stack<Property> stack = new Stack<Property>();
        stack.push(this._properties.get(n));
        while (!stack.empty()) {
            Property property = (Property)stack.pop();
            directoryProperty.addChild(property);
            if (property.isDirectory()) {
                this.populatePropertyTree((DirectoryProperty)property);
            }
            if (Property.isValidIndex(n = property.getPreviousChildIndex())) {
                stack.push(this._properties.get(n));
            }
            if (!Property.isValidIndex(n = property.getNextChildIndex())) continue;
            stack.push(this._properties.get(n));
        }
    }

    @Override
    public void writeBlocks(OutputStream outputStream) throws IOException {
        if (this._blocks != null) {
            for (int i = 0; i < this._blocks.length; ++i) {
                this._blocks[i].writeBlocks(outputStream);
            }
        }
    }
}

