/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.geojson;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.event.SelectionEventManager;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.gui.layer.LayerManager;
import org.openstreetmap.josm.gui.layer.MainLayerManager;
import org.openstreetmap.josm.plugins.geojson.GeoJsonLayer;

public class GeoJsonDialog
extends ToggleDialog
implements LayerManager.LayerChangeListener,
MainLayerManager.ActiveLayerChangeListener {
    private static final long serialVersionUID = 2182365950017739421L;
    private static boolean stopProcessingCallbacks = false;
    private GeoJsonLayer layer;
    private final JPanel panel = new JPanel(new BorderLayout());
    private Map<Integer, PrimitiveId> indexToIdentifier;
    private Map<PrimitiveId, Integer> identifierToIndex;
    private DefaultListModel<PrintablePrimitive> listModel;

    public GeoJsonDialog() {
        super("GeoJson object list", "activate-geojson", "Opens the GeoJson object list pane", null, 150);
        this.panel.setName("GeoJson object list");
        this.add(this.panel, "Center");
        this.listModel = new DefaultListModel();
        JList<PrintablePrimitive> list = new JList<PrintablePrimitive>(this.listModel);
        this.panel.add((Component)new JScrollPane(list), "Center");
        this.indexToIdentifier = new HashMap<Integer, PrimitiveId>();
        this.identifierToIndex = new HashMap<PrimitiveId, Integer>();
        list.addListSelectionListener(new ListSelectionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (stopProcessingCallbacks) {
                    return;
                }
                try {
                    stopProcessingCallbacks = true;
                    JList selectionModel = (JList)listSelectionEvent.getSource();
                    int selectedIndex = selectionModel.getMinSelectionIndex();
                    PrimitiveId identifier = (PrimitiveId)GeoJsonDialog.this.indexToIdentifier.get(selectedIndex);
                    ((GeoJsonDialog)GeoJsonDialog.this).layer.data.setSelected(new PrimitiveId[]{identifier});
                    GeoJsonDialog.this.zoomTo(((GeoJsonDialog)GeoJsonDialog.this).layer.data.getPrimitiveById(identifier));
                }
                finally {
                    stopProcessingCallbacks = false;
                }
            }
        });
        SelectionEventManager.getInstance().addSelectionListener(event -> {
            if (stopProcessingCallbacks) {
                return;
            }
            try {
                stopProcessingCallbacks = true;
                for (OsmPrimitive feature : event.getSelection()) {
                    if (!this.identifierToIndex.containsKey(feature.getPrimitiveId())) continue;
                    int idx = this.identifierToIndex.get(feature.getPrimitiveId());
                    list.setSelectedIndices(new int[]{idx});
                    list.ensureIndexIsVisible(idx);
                    break;
                }
            }
            finally {
                stopProcessingCallbacks = false;
            }
        });
    }

    private void showDataFromLayer() {
        this.listModel.clear();
        this.indexToIdentifier.clear();
        this.identifierToIndex.clear();
        if (this.layer != null && this.layer.data != null && !this.layer.data.allPrimitives().isEmpty()) {
            int index = 0;
            for (OsmPrimitive osmPrimitive : this.layer.data.allPrimitives()) {
                if (osmPrimitive instanceof Node && osmPrimitive.getKeys().isEmpty()) continue;
                this.listModel.addElement(new PrintablePrimitive(index, osmPrimitive));
                this.indexToIdentifier.put(index, osmPrimitive.getPrimitiveId());
                this.identifierToIndex.put(osmPrimitive.getPrimitiveId(), index);
                ++index;
            }
        }
    }

    public void activeOrEditLayerChanged(MainLayerManager.ActiveLayerChangeEvent e) {
        if (MainApplication.getLayerManager().getActiveLayer() instanceof GeoJsonLayer) {
            this.layer = (GeoJsonLayer)MainApplication.getLayerManager().getActiveLayer();
            this.showDataFromLayer();
        }
    }

    public void layerAdded(LayerManager.LayerAddEvent e) {
        if (e.getAddedLayer() == this.layer) {
            MainApplication.getMap().mapView.moveLayer(e.getAddedLayer(), 0);
        }
    }

    public void layerRemoving(LayerManager.LayerRemoveEvent e) {
    }

    public void layerOrderChanged(LayerManager.LayerOrderChangeEvent e) {
    }

    private void zoomTo(OsmPrimitive primitive) {
        if (primitive == null) {
            return;
        }
        if (primitive instanceof Node) {
            MainApplication.getMap().mapView.zoomTo(((Node)primitive).getCoor());
            return;
        }
        BoundingXYVisitor v = new BoundingXYVisitor();
        v.visit((Way)primitive);
        MainApplication.getMap().mapView.zoomTo(v.getBounds());
    }

    public static class PrintablePrimitive {
        private final OsmPrimitive osmPrimitive;
        private final long index;

        public PrintablePrimitive(long index, OsmPrimitive osmPrimitive) {
            this.osmPrimitive = osmPrimitive;
            this.index = index;
        }

        public long getIndex() {
            return this.index;
        }

        public OsmPrimitive getOsmPrimitive() {
            return this.osmPrimitive;
        }

        public String toString() {
            StringBuilder result = new StringBuilder();
            result.append("Index: ");
            result.append(this.index);
            result.append(", Tags: ");
            result.append(this.osmPrimitive.getKeys());
            return result.toString();
        }
    }
}

