/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.tracer2.preferences;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.plugins.tracer2.preferences.ServerParam;
import org.openstreetmap.josm.plugins.tracer2.preferences.ServerParamDialog;
import org.openstreetmap.josm.plugins.tracer2.preferences.ServerParamList;
import org.openstreetmap.josm.plugins.tracer2.preferences.ServerParamSelectDialog;
import org.openstreetmap.josm.tools.I18n;

public class ServerParamPanel
extends JPanel {
    private static final long serialVersionUID = -6174275926314685531L;
    ServerParamList m_listParam;

    public ServerParamPanel(ServerParamList listParam) {
        super(new GridBagLayout());
        this.m_listParam = listParam;
    }

    public void refresh() {
        this.removeAll();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridy = 0;
        gbc.fill = 2;
        gbc.insets = new Insets(2, 5, 2, 5);
        for (final ServerParam param : this.m_listParam.getParamList()) {
            gbc.gridx = 0;
            gbc.weightx = 1.0;
            gbc.anchor = 17;
            final JCheckBox cbParam = new JCheckBox(param.getName());
            cbParam.setSelected(param.isEnabled());
            cbParam.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    param.setEnabled(cbParam.isSelected());
                }
            });
            this.add((Component)cbParam, gbc);
            gbc.gridx = 1;
            gbc.weightx = 0.0;
            gbc.anchor = 13;
            JButton bEdit = new JButton(I18n.tr((String)"Edit", (Object[])new Object[0]));
            bEdit.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    ServerParamDialog dlg = new ServerParamDialog(param);
                    ((Dialog)((Object)dlg)).setVisible(true);
                    ((Window)((Object)dlg)).dispose();
                    ServerParamPanel.this.refresh();
                }
            });
            this.add((Component)bEdit, gbc);
            gbc.gridx = 2;
            JButton bDel = new JButton(I18n.tr((String)"Delete", (Object[])new Object[0]));
            bDel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    if (JOptionPane.showConfirmDialog((Component)MainApplication.getMainFrame(), I18n.tr((String)"Delete parameter \"{0}\"?", (Object[])new Object[]{param.getName()}), I18n.tr((String)"Are you sure?", (Object[])new Object[0]), 0, 3) == 0) {
                        ServerParamPanel.this.m_listParam.removeParam(param);
                        ServerParamPanel.this.refresh();
                    }
                }
            });
            this.add((Component)bDel, gbc);
            ++gbc.gridy;
        }
        gbc.gridx = 0;
        gbc.fill = 0;
        gbc.anchor = 17;
        JPanel p = new JPanel(new GridBagLayout());
        JButton bNew = new JButton(I18n.tr((String)"Add new", (Object[])new Object[0]));
        bNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ServerParamDialog dlg = new ServerParamDialog(null);
                ((Dialog)((Object)dlg)).setVisible(true);
                ((Window)((Object)dlg)).dispose();
                ServerParam param = dlg.getServerParam();
                if (param != null && param.getName() != null && !"".equals(param.getName())) {
                    ServerParamPanel.this.m_listParam.addParam(param);
                    param.setEnabled(true);
                }
                ServerParamPanel.this.refresh();
            }
        });
        p.add(bNew);
        JButton bPredefined = new JButton(I18n.tr((String)"Add predefined", (Object[])new Object[0]));
        bPredefined.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ServerParamList myParamList = new ServerParamList(null);
                ServerParamSelectDialog dialog = new ServerParamSelectDialog(myParamList.getParamList(), null);
                if (dialog.getShow()) {
                    JOptionPane pane = new JOptionPane(dialog, -1, 2);
                    Object dlg = pane.createDialog((Component)MainApplication.getMainFrame(), I18n.tr((String)"Tracer2", (Object[])new Object[0]) + " - " + I18n.tr((String)"Select predefined parameter", (Object[])new Object[0]));
                    ((Dialog)dlg).setVisible(true);
                    Object obj = pane.getValue();
                    ((Window)dlg).dispose();
                    if (obj != null && (Integer)obj == 0) {
                        ServerParam param = dialog.getSelectedParam();
                        dlg = new ServerParamDialog(param);
                        ((Dialog)dlg).setVisible(true);
                        ((Window)dlg).dispose();
                        param = ((ServerParamDialog)((Object)dlg)).getServerParam();
                        if (param != null && param.getName() != null && !"".equals(param.getName())) {
                            ServerParamPanel.this.m_listParam.addParam(param);
                            param.setEnabled(true);
                        }
                    }
                }
                ServerParamPanel.this.refresh();
            }
        });
        p.add(bPredefined);
        this.add((Component)p, gbc);
        ++gbc.gridy;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        this.add((Component)new JPanel(), gbc);
        this.revalidate();
        this.repaint();
    }
}

