/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.surveyor;

import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.AbstractButton;
import livegps.LiveGpsLayer;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.plugins.surveyor.AutoSaveEditLayerTimerTask;
import org.openstreetmap.josm.plugins.surveyor.AutoSaveGpsLayerTimerTask;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class AutoSaveAction
extends JosmAction {
    private static final long serialVersionUID = -8608679323231116043L;
    private static final long AUTO_SAVE_PERIOD_SEC = 60L;
    public static final String GPS_FILE_NAME_PATTERN = "surveyor-{0,date,yyyyMMdd-HHmmss}.gpx";
    public static final String OSM_FILE_NAME_PATTERN = "surveyor-{0,date,yyyyMMdd-HHmmss}.osm";
    private boolean autoSave = false;
    private Timer gpsDataTimer;

    public AutoSaveAction() {
        super(I18n.tr((String)"AutoSave LiveData", (Object[])new Object[0]), "autosave.png", I18n.tr((String)"Save captured data to file every minute.", (Object[])new Object[0]), Shortcut.registerShortcut((String)"surveyor:autosave", (String)I18n.tr((String)"Tool: {0}", (Object[])new Object[]{I18n.tr((String)"AutoSave LiveData", (Object[])new Object[0])}), (int)83, (int)5010), true);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof AbstractButton) {
            this.autoSave = ((AbstractButton)e.getSource()).isSelected();
        }
        if (this.autoSave) {
            if (this.gpsDataTimer == null) {
                this.gpsDataTimer = new Timer();
            }
            String gpxFilename = MessageFormat.format(GPS_FILE_NAME_PATTERN, new Date());
            TimerTask task = new AutoSaveGpsLayerTimerTask(gpxFilename, LiveGpsLayer.LAYER_NAME);
            this.gpsDataTimer.schedule(task, 1000L, 60000L);
            String osmFilename = MessageFormat.format(OSM_FILE_NAME_PATTERN, new Date());
            task = new AutoSaveEditLayerTimerTask(osmFilename);
            this.gpsDataTimer.schedule(task, 5000L, 60000L);
        } else if (this.gpsDataTimer != null) {
            this.gpsDataTimer.cancel();
        }
    }
}

