/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input.buffer;

import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import org.apache.commons.io.input.buffer.CircularBufferInputStream;

public class PeekableInputStream
extends CircularBufferInputStream {
    public PeekableInputStream(InputStream pIn, int pBufferSize) {
        super(pIn, pBufferSize);
    }

    public PeekableInputStream(InputStream pIn) {
        super(pIn);
    }

    public boolean peek(byte[] pBuffer) throws IOException {
        Objects.requireNonNull(pBuffer, "Buffer");
        if (pBuffer.length > this.bufferSize) {
            throw new IllegalArgumentException("Peek request size of " + pBuffer.length + " bytes exceeds buffer size of " + this.bufferSize + " bytes");
        }
        if (this.buffer.getCurrentNumberOfBytes() < pBuffer.length) {
            this.fillBuffer();
        }
        return this.buffer.peek(pBuffer, 0, pBuffer.length);
    }

    public boolean peek(byte[] pBuffer, int pOffset, int pLength) throws IOException {
        Objects.requireNonNull(pBuffer, "Buffer");
        if (pBuffer.length > this.bufferSize) {
            throw new IllegalArgumentException("Peek request size of " + pBuffer.length + " bytes exceeds buffer size of " + this.bufferSize + " bytes");
        }
        if (this.buffer.getCurrentNumberOfBytes() < pBuffer.length) {
            this.fillBuffer();
        }
        return this.buffer.peek(pBuffer, pOffset, pLength);
    }
}

