/*
 * Decompiled with CFR 0.152.
 */
package nanolog;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JOptionPane;
import nanolog.NanoLogEntry;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.data.gpx.GpxTrack;
import org.openstreetmap.josm.data.gpx.GpxTrackSegment;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.data.projection.ProjectionRegistry;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.UncheckedParseException;
import org.openstreetmap.josm.tools.date.DateUtils;

public final class Correlator {
    private Correlator() {
    }

    public static long crudeMatch(List<NanoLogEntry> entries, GpxData data) {
        ArrayList<NanoLogEntry> sortedEntries = new ArrayList<NanoLogEntry>(entries);
        Collections.sort(sortedEntries);
        long firstExifDate = ((NanoLogEntry)sortedEntries.get(0)).getTime().getTime();
        long firstGPXDate = -1L;
        block2: for (GpxTrack trk : data.tracks) {
            for (GpxTrackSegment segment : trk.getSegments()) {
                for (WayPoint curWp : segment.getWayPoints()) {
                    String curDateWpStr = (String)curWp.attr.get("time");
                    if (curDateWpStr == null) continue;
                    try {
                        firstGPXDate = DateUtils.fromString((String)curDateWpStr).getTime();
                        break block2;
                    }
                    catch (Exception e) {
                        Logging.warn((Throwable)e);
                    }
                }
            }
        }
        if (firstGPXDate < 0L) {
            JOptionPane.showMessageDialog((Component)MainApplication.getMainFrame(), I18n.tr((String)"The selected GPX track does not contain timestamps. Please select another one.", (Object[])new Object[0]), I18n.tr((String)"GPX Track has no time information", (Object[])new Object[0]), 2);
            return 0L;
        }
        return firstExifDate - firstGPXDate;
    }

    public static void revertPos(List<NanoLogEntry> entries) {
        for (NanoLogEntry entry : entries) {
            entry.setPos(entry.getBasePos());
        }
    }

    public static void correlate(List<NanoLogEntry> entries, GpxData data, long offset) {
        ArrayList<NanoLogEntry> sortedEntries = new ArrayList<NanoLogEntry>(entries);
        Collections.sort(sortedEntries);
        for (GpxTrack track : data.tracks) {
            for (GpxTrackSegment segment : track.getSegments()) {
                long prevWpTime = 0L;
                WayPoint prevWp = null;
                for (WayPoint curWp : segment.getWayPoints()) {
                    String curWpTimeStr = (String)curWp.attr.get("time");
                    if (curWpTimeStr != null) {
                        try {
                            long curWpTime = DateUtils.fromString((String)curWpTimeStr).getTime() + offset;
                            Correlator.matchPoints(sortedEntries, prevWp, prevWpTime, curWp, curWpTime, offset);
                            prevWp = curWp;
                            prevWpTime = curWpTime;
                        }
                        catch (UncheckedParseException e) {
                            Logging.error((String)("Error while parsing date \"" + curWpTimeStr + '\"'));
                            Logging.error((Throwable)e);
                            prevWp = null;
                            prevWpTime = 0L;
                        }
                        continue;
                    }
                    prevWp = null;
                    prevWpTime = 0L;
                }
            }
        }
    }

    private static int matchPoints(List<NanoLogEntry> entries, WayPoint prevWp, long prevWpTime, WayPoint curWp, long curWpTime, long offset) {
        NanoLogEntry curImg;
        long imgTime;
        long interval = prevWpTime > 0L ? Math.abs(curWpTime - prevWpTime) : 5000L;
        int ret = 0;
        int i = Correlator.getLastIndexOfListBefore(entries, curWpTime);
        if (i < 0) {
            return 0;
        }
        Integer direction = null;
        if (prevWp != null) {
            direction = Long.valueOf(Math.round(57.29577951308232 * -prevWp.getCoor().bearing(curWp.getCoor()))).intValue();
        }
        if (prevWpTime == 0L || curWpTime <= prevWpTime) {
            NanoLogEntry curImg2;
            long time;
            while (i >= 0 && (time = (curImg2 = entries.get(i)).getTime().getTime()) <= curWpTime && time >= curWpTime - interval) {
                if (curImg2.getPos() == null) {
                    curImg2.setPos(curWp.getCoor());
                    curImg2.setDirection(direction);
                    ++ret;
                }
                --i;
            }
            return ret;
        }
        while (i >= 0 && (imgTime = (curImg = entries.get(i)).getTime().getTime()) >= prevWpTime) {
            if (curImg.getPos() == null && prevWp != null) {
                double timeDiff = (double)(imgTime - prevWpTime) / (double)interval;
                curImg.setPos(prevWp.getCoor().interpolate(curWp.getCoor(), timeDiff));
                curImg.setDirection(direction);
                ++ret;
            }
            --i;
        }
        return ret;
    }

    private static int getLastIndexOfListBefore(List<NanoLogEntry> entries, long searchedTime) {
        int lstSize = entries.size();
        if (lstSize == 0 || searchedTime < entries.get(0).getTime().getTime()) {
            return -1;
        }
        if (searchedTime > entries.get(lstSize - 1).getTime().getTime()) {
            return lstSize - 1;
        }
        int curIndex = 0;
        int startIndex = 0;
        int endIndex = lstSize - 1;
        while (endIndex - startIndex > 1) {
            curIndex = (endIndex + startIndex) / 2;
            if (searchedTime > entries.get(curIndex).getTime().getTime()) {
                startIndex = curIndex;
                continue;
            }
            endIndex = curIndex;
        }
        if (searchedTime < entries.get(endIndex).getTime().getTime()) {
            return startIndex;
        }
        while (endIndex < lstSize - 1 && entries.get(endIndex).getTime().getTime() == entries.get(endIndex + 1).getTime().getTime()) {
            ++endIndex;
        }
        return endIndex;
    }

    public static long getGpxDate(GpxData data, LatLon pos) {
        EastNorth en = ProjectionRegistry.getProjection().latlon2eastNorth(pos);
        for (GpxTrack track : data.tracks) {
            for (GpxTrackSegment segment : track.getSegments()) {
                long prevWpTime = 0L;
                WayPoint prevWp = null;
                for (WayPoint curWp : segment.getWayPoints()) {
                    String curWpTimeStr = (String)curWp.attr.get("time");
                    if (curWpTimeStr != null) {
                        try {
                            EastNorth middle;
                            EastNorth c2;
                            EastNorth c1;
                            long curWpTime = DateUtils.fromString((String)curWpTimeStr).getTime();
                            if (prevWp != null && !(c1 = ProjectionRegistry.getProjection().latlon2eastNorth(prevWp.getCoor())).equals((Object)(c2 = ProjectionRegistry.getProjection().latlon2eastNorth(curWp.getCoor()))) && (middle = Correlator.getSegmentAltitudeIntersection(c1, c2, en)) != null && en.distance(middle) < 1.0) {
                                double prop;
                                double d = prop = c1.east() == c2.east() ? (middle.north() - c1.north()) / (c2.north() - c1.north()) : (middle.east() - c1.east()) / (c2.east() - c1.east());
                                if (prop >= 0.0 && prop <= 1.0) {
                                    return Math.round((double)prevWpTime + prop * (double)(curWpTime - prevWpTime));
                                }
                            }
                            prevWp = curWp;
                            prevWpTime = curWpTime;
                        }
                        catch (UncheckedParseException e) {
                            Logging.error((String)("Error while parsing date \"" + curWpTimeStr + '\"'));
                            Logging.error((Throwable)e);
                            prevWp = null;
                            prevWpTime = 0L;
                        }
                        continue;
                    }
                    prevWp = null;
                    prevWpTime = 0L;
                }
            }
        }
        return 0L;
    }

    public static EastNorth getSegmentAltitudeIntersection(EastNorth p1, EastNorth p2, EastNorth point) {
        double pdy;
        double ldx = p2.getX() - p1.getX();
        double ldy = p2.getY() - p1.getY();
        if (ldx == 0.0 && ldy == 0.0) {
            return p1;
        }
        double pdx = point.getX() - p1.getX();
        double offset = (pdx * ldx + (pdy = point.getY() - p1.getY()) * ldy) / (ldx * ldx + ldy * ldy);
        if (offset < -1.0E-8 || offset > 1.00000001) {
            return null;
        }
        if (offset < 1.0E-8) {
            return p1;
        }
        if (offset > 0.99999999) {
            return p2;
        }
        return new EastNorth(p1.getX() + ldx * offset, p1.getY() + ldy * offset);
    }
}

