/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.utilsplugin2.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.command.SplitWayCommand;
import org.openstreetmap.josm.data.UndoRedoHandler;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class SplitOnIntersectionsAction
extends JosmAction {
    private static final String TITLE = I18n.tr((String)"Split adjacent ways", (Object[])new Object[0]);
    private static final String TOOL_DESC = I18n.tr((String)"Split adjacent ways on T-intersections", (Object[])new Object[0]);

    public SplitOnIntersectionsAction() {
        super(TITLE, "dumbutils/splitonintersections", TOOL_DESC, Shortcut.registerShortcut((String)"tools:splitonintersections", (String)I18n.tr((String)"Tool: {0}", (Object[])new Object[]{TITLE}), (int)80, (int)5010), true);
    }

    public void actionPerformed(ActionEvent e) {
        ArrayList<SplitWayCommand> list = new ArrayList<SplitWayCommand>();
        List selectedWays = OsmPrimitive.getFilteredList((Collection)this.getLayerManager().getEditDataSet().getSelected(), Way.class);
        HashMap splitWays = new HashMap();
        for (Way way : selectedWays) {
            if (way.getNodesCount() <= 1 || way.hasIncompleteNodes() || way.isClosed()) continue;
            for (Iterator<Object> iterator : new Node[]{way.getNode(0), way.getNode(way.getNodesCount() - 1)}) {
                Iterator it;
                List refs = OsmPrimitive.getFilteredList((Collection)iterator.getReferrers(), Way.class);
                refs.remove(way);
                if (selectedWays.size() > 1) {
                    it = refs.iterator();
                    while (it.hasNext()) {
                        if (selectedWays.contains(it.next())) continue;
                        it.remove();
                    }
                }
                it = refs.iterator();
                while (it.hasNext()) {
                    Way w = (Way)it.next();
                    if (!w.isDeleted() && !w.isIncomplete() && w.isInnerNode(iterator)) continue;
                    it.remove();
                }
                if (refs.size() == 1) {
                    if (splitWays.containsKey(refs.get(0))) {
                        ((List)splitWays.get(refs.get(0))).add(iterator);
                        continue;
                    }
                    ArrayList<Iterator<Object>> nodes = new ArrayList<Iterator<Object>>(1);
                    nodes.add(iterator);
                    splitWays.put((Way)refs.get(0), nodes);
                    continue;
                }
                if (refs.size() <= 1) continue;
                new Notification(I18n.tr((String)"There are several ways containing one of the splitting nodes. Select ways participating in this operation.", (Object[])new Object[0])).setIcon(2).show();
                return;
            }
        }
        if (splitWays.isEmpty()) {
            new Notification(I18n.tr((String)"The selection cannot be used for action ''{0}''", (Object[])new Object[]{TOOL_DESC})).setIcon(2).show();
            return;
        }
        boolean createSequenceCommand = true;
        HashSet<Relation> allWayRefs = new HashSet<Relation>();
        for (Way way : splitWays.keySet()) {
            for (Relation relation : OsmPrimitive.getFilteredList((Collection)way.getReferrers(), Relation.class)) {
                createSequenceCommand &= allWayRefs.add(relation);
            }
        }
        for (Map.Entry entry : splitWays.entrySet()) {
            SplitWayCommand cmd = SplitWayCommand.split((Way)((Way)entry.getKey()), (List)((List)entry.getValue()), (Collection)selectedWays);
            if (!createSequenceCommand) {
                UndoRedoHandler.getInstance().add((Command)cmd);
            }
            list.add(cmd);
        }
        if (!list.isEmpty()) {
            if (createSequenceCommand) {
                UndoRedoHandler.getInstance().add((Command)(list.size() == 1 ? (Command)list.get(0) : new SequenceCommand(TITLE, list)));
            } else {
                new Notification(I18n.tr((String)"Affected ways are members of the same relation. {0} actions were created for this split.", (Object[])new Object[]{list.size()})).setIcon(2).show();
            }
            this.getLayerManager().getEditDataSet().clearSelection();
        }
    }

    protected void updateEnabledState() {
        this.updateEnabledStateOnCurrentSelection();
    }

    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        boolean ok = false;
        if (selection != null) {
            for (OsmPrimitive osmPrimitive : selection) {
                if (osmPrimitive instanceof Way) {
                    ok = true;
                    continue;
                }
                ok = false;
                break;
            }
        }
        this.setEnabled(ok);
    }
}

