/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.seamapeditor.panels;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EnumMap;
import javax.swing.DefaultCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.openstreetmap.josm.plugins.seamapeditor.SmedAction;
import org.openstreetmap.josm.plugins.seamapeditor.messages.Messages;
import org.openstreetmap.josm.plugins.seamapeditor.seamarks.SeaMark;

public class PanelSectors
extends JFrame {
    private SmedAction dlg;
    private JPanel panel;
    private TableModel model;
    private JTable table;
    public JButton minusButton;
    private ActionListener alMinusButton = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (PanelSectors.this.getSectorCount() > 1 && PanelSectors.this.table.getSelectedRow() != 0) {
                PanelSectors.this.deleteSector(PanelSectors.this.table.getSelectedRow());
            }
        }
    };
    public JButton plusButton;
    private ActionListener alPlusButton = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (PanelSectors.this.table.getSelectedRow() < 0) {
                PanelSectors.this.addSector(PanelSectors.this.table.getRowCount());
            } else {
                PanelSectors.this.addSector(PanelSectors.this.table.getSelectedRow() + 1);
            }
        }
    };
    public JComboBox<ImageIcon> colourBox;
    public EnumMap<SeaMark.Col, ImageIcon> colours = new EnumMap(SeaMark.Col.class);
    public JComboBox<String> visibilityBox;
    public EnumMap<SeaMark.Vis, String> visibilities = new EnumMap(SeaMark.Vis.class);
    public JComboBox<String> exhibitionBox;
    public EnumMap<SeaMark.Exh, String> exhibitions = new EnumMap(SeaMark.Exh.class);

    public PanelSectors(SmedAction dia) {
        super(Messages.getString("SectorTable"));
        this.dlg = dia;
        this.setLayout(null);
        this.setSize(900, 100);
        this.setAlwaysOnTop(true);
        this.setLocation(450, 0);
        this.setDefaultCloseOperation(1);
        this.minusButton = new JButton(new ImageIcon(this.getClass().getResource("/images/MinusButton.png")));
        this.minusButton.setBounds(0, 0, 32, 34);
        this.minusButton.addActionListener(this.alMinusButton);
        this.add(this.minusButton);
        this.plusButton = new JButton(new ImageIcon(this.getClass().getResource("/images/PlusButton.png")));
        this.plusButton.setBounds(0, 34, 32, 34);
        this.plusButton.addActionListener(this.alPlusButton);
        this.add(this.plusButton);
        this.panel = new JPanel(new BorderLayout());
        this.panel.setBounds(40, 0, 860, 512);
        this.model = new SectorTable();
        this.table = new JTable(this.model);
        this.table.setBounds(0, 0, 860, 34);
        this.table.setAutoResizeMode(4);
        this.panel.add(new JScrollPane(this.table));
        this.getContentPane().add(this.panel);
        this.table.setSize(860, this.table.getRowCount() * 16 + 28);
        this.table.setDefaultRenderer(String.class, new CentreRenderer());
        this.table.getColumnModel().getColumn(1).setCellRenderer(new ColourCellRenderer());
        TableColumn colColumn = this.table.getColumnModel().getColumn(1);
        this.colourBox = new JComboBox();
        this.addColItem(new ImageIcon(this.getClass().getResource("/images/DelButton.png")), SeaMark.Col.UNKCOL);
        this.addColItem(new ImageIcon(this.getClass().getResource("/images/WhiteButton.png")), SeaMark.Col.WHITE);
        this.addColItem(new ImageIcon(this.getClass().getResource("/images/RedButton.png")), SeaMark.Col.RED);
        this.addColItem(new ImageIcon(this.getClass().getResource("/images/GreenButton.png")), SeaMark.Col.GREEN);
        this.addColItem(new ImageIcon(this.getClass().getResource("/images/YellowButton.png")), SeaMark.Col.YELLOW);
        this.addColItem(new ImageIcon(this.getClass().getResource("/images/OrangeButton.png")), SeaMark.Col.ORANGE);
        this.addColItem(new ImageIcon(this.getClass().getResource("/images/AmberButton.png")), SeaMark.Col.AMBER);
        this.addColItem(new ImageIcon(this.getClass().getResource("/images/BlueButton.png")), SeaMark.Col.BLUE);
        this.addColItem(new ImageIcon(this.getClass().getResource("/images/VioletButton.png")), SeaMark.Col.VIOLET);
        colColumn.setCellEditor(new DefaultCellEditor(this.colourBox));
        TableColumn visColumn = this.table.getColumnModel().getColumn(12);
        this.visibilityBox = new JComboBox();
        this.addVisibItem("", SeaMark.Vis.UNKVIS);
        this.addVisibItem(Messages.getString("Intensified"), SeaMark.Vis.INTEN);
        this.addVisibItem(Messages.getString("Unintensified"), SeaMark.Vis.UNINTEN);
        this.addVisibItem(Messages.getString("PartiallyObscured"), SeaMark.Vis.PARTOBS);
        visColumn.setCellEditor(new DefaultCellEditor(this.visibilityBox));
        TableColumn exhColumn = this.table.getColumnModel().getColumn(13);
        this.exhibitionBox = new JComboBox();
        this.addExhibItem("", SeaMark.Exh.UNKEXH);
        this.addExhibItem(Messages.getString("24h"), SeaMark.Exh.H24);
        this.addExhibItem(Messages.getString("Day"), SeaMark.Exh.DAY);
        this.addExhibItem(Messages.getString("Night"), SeaMark.Exh.NIGHT);
        this.addExhibItem(Messages.getString("Fog"), SeaMark.Exh.FOG);
        exhColumn.setCellEditor(new DefaultCellEditor(this.exhibitionBox));
    }

    public int getSectorCount() {
        return this.model.getRowCount();
    }

    public void addSector(int idx) {
        SmedAction.panelMain.mark.addLight(idx);
        this.table.setSize(860, this.table.getRowCount() * 16 + 28);
        if (this.table.getRowCount() > 3) {
            this.setSize(900, this.table.getRowCount() * 16 + 48);
        } else {
            this.setSize(900, 100);
        }
    }

    public void deleteSector(int idx) {
        if (idx > 0) {
            SmedAction.panelMain.mark.delLight(idx);
            this.table.setSize(860, this.table.getRowCount() * 16 + 28);
            if (this.table.getRowCount() > 3) {
                this.setSize(900, this.table.getRowCount() * 16 + 48);
            } else {
                this.setSize(900, 100);
            }
        }
    }

    public void syncPanel() {
        this.table.updateUI();
        this.table.setSize(860, this.table.getRowCount() * 16 + 28);
        if (this.table.getRowCount() > 3) {
            this.setSize(900, this.table.getRowCount() * 16 + 48);
        } else {
            this.setSize(900, 100);
        }
    }

    private void addColItem(ImageIcon img, SeaMark.Col col) {
        this.colours.put(col, img);
        this.colourBox.addItem(img);
    }

    private void addVisibItem(String str, SeaMark.Vis vis) {
        this.visibilities.put(vis, str);
        this.visibilityBox.addItem(str);
    }

    private void addExhibItem(String str, SeaMark.Exh exh) {
        this.exhibitions.put(exh, str);
        this.exhibitionBox.addItem(str);
    }

    public static class ColourCellRenderer
    extends JPanel
    implements TableCellRenderer {
        private JLabel col1Label;
        private JLabel col2Label;

        public ColourCellRenderer() {
            this.setLayout(new GridLayout(1, 2, 0, 0));
            this.col1Label = new JLabel();
            this.col1Label.setOpaque(true);
            this.add(this.col1Label);
            this.col2Label = new JLabel();
            this.col2Label.setOpaque(true);
            this.add(this.col2Label);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int rowIndex, int vColIndex) {
            if (!((String)SmedAction.panelMain.mark.getLightAtt(SeaMark.Att.CHR, rowIndex)).contains("Al")) {
                this.col2Label.setBackground(SeaMark.ColMAP.get(SmedAction.panelMain.mark.getLightAtt(SeaMark.Att.COL, rowIndex)));
            } else {
                this.col2Label.setBackground(SeaMark.ColMAP.get(SmedAction.panelMain.mark.getLightAtt(SeaMark.Att.ALT, rowIndex)));
            }
            this.col1Label.setBackground(SeaMark.ColMAP.get(SmedAction.panelMain.mark.getLightAtt(SeaMark.Att.COL, rowIndex)));
            return this;
        }
    }

    static class CentreRenderer
    extends DefaultTableCellRenderer {
        CentreRenderer() {
            this.setHorizontalAlignment(0);
        }
    }

    private class SectorTable
    extends AbstractTableModel {
        private String[] headings = new String[]{Messages.getString("Sector"), Messages.getString("Colour"), Messages.getString("Character"), Messages.getString("Group"), Messages.getString("Sequence"), Messages.getString("Period"), Messages.getString("Directional"), Messages.getString("Start"), Messages.getString("End"), Messages.getString("Radius"), Messages.getString("Height"), Messages.getString("Range"), Messages.getString("Visibility"), Messages.getString("Exhibition")};

        SectorTable() {
        }

        @Override
        public String getColumnName(int col) {
            return this.headings[col];
        }

        @Override
        public int getColumnCount() {
            return this.headings.length;
        }

        @Override
        public int getRowCount() {
            if (SmedAction.panelMain == null) {
                return 1;
            }
            return SmedAction.panelMain.mark.getSectorCount();
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col > 0 && row > 0;
        }

        public Class getColumnClass(int col) {
            switch (col) {
                case 1: {
                    return SeaMark.Col.class;
                }
                case 6: {
                    return Boolean.class;
                }
            }
            return String.class;
        }

        @Override
        public Object getValueAt(int row, int col) {
            switch (col) {
                case 0: {
                    if (row == 0) {
                        return Messages.getString("Default");
                    }
                    return row;
                }
                case 1: {
                    if (((String)SmedAction.panelMain.mark.getLightAtt(SeaMark.Att.CHR, row)).contains("Al")) {
                        if (SmedAction.panelMain.mark.getLightAtt(SeaMark.Att.COL, row) == SeaMark.Col.UNKCOL) {
                            return SeaMark.Col.UNKCOL;
                        }
                        return SmedAction.panelMain.mark.getLightAtt(SeaMark.Att.ALT, row);
                    }
                    return SmedAction.panelMain.mark.getLightAtt(SeaMark.Att.COL, row);
                }
                case 6: {
                    return SmedAction.panelMain.mark.getLightAtt(SeaMark.Att.LIT, row) == SeaMark.Lit.DIR;
                }
                case 7: 
                case 8: {
                    if (SmedAction.panelMain.mark.getLightAtt(SeaMark.Att.LIT, row) == SeaMark.Lit.DIR) {
                        return SmedAction.panelMain.mark.getLightAtt(SeaMark.Att.ORT, row);
                    }
                    return SmedAction.panelMain.mark.getLightAtt(col - 1, row);
                }
                case 12: {
                    return PanelSectors.this.visibilities.get(SmedAction.panelMain.mark.getLightAtt(SeaMark.Att.VIS, row));
                }
                case 13: {
                    return PanelSectors.this.exhibitions.get(SmedAction.panelMain.mark.getLightAtt(SeaMark.Att.EXH, row));
                }
            }
            return SmedAction.panelMain.mark.getLightAtt(col - 1, row);
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            switch (col) {
                case 1: {
                    for (SeaMark.Col colour : PanelSectors.this.colours.keySet()) {
                        ImageIcon img = PanelSectors.this.colours.get((Object)colour);
                        if (img != value) continue;
                        if (((String)SmedAction.panelMain.mark.getLightAtt(SeaMark.Att.CHR, row)).contains("Al")) {
                            if (colour == SeaMark.Col.UNKCOL && SmedAction.panelMain.mark.getLightAtt(SeaMark.Att.ALT, row) == SeaMark.Col.UNKCOL || SmedAction.panelMain.mark.getLightAtt(SeaMark.Att.COL, row) == SeaMark.Col.UNKCOL) {
                                SmedAction.panelMain.mark.setLightAtt(SeaMark.Att.COL, row, (Object)colour);
                                continue;
                            }
                            SmedAction.panelMain.mark.setLightAtt(SeaMark.Att.ALT, row, (Object)colour);
                            continue;
                        }
                        SmedAction.panelMain.mark.setLightAtt(SeaMark.Att.COL, row, (Object)colour);
                    }
                    break;
                }
                case 5: 
                case 9: 
                case 10: 
                case 11: {
                    SmedAction.panelMain.mark.setLightAtt(col - 1, row, value);
                    break;
                }
                case 6: {
                    if (((Boolean)value).booleanValue()) {
                        SmedAction.panelMain.mark.setLightAtt(SeaMark.Att.LIT, row, (Object)SeaMark.Lit.DIR);
                        SmedAction.panelMain.mark.setLightAtt(SeaMark.Att.BEG, row, (Object)"");
                        SmedAction.panelMain.mark.setLightAtt(SeaMark.Att.END, row, (Object)"");
                        break;
                    }
                    SmedAction.panelMain.mark.setLightAtt(SeaMark.Att.LIT, row, (Object)SeaMark.Lit.UNKLIT);
                    SmedAction.panelMain.mark.setLightAtt(SeaMark.Att.ORT, row, (Object)"");
                    break;
                }
                case 7: 
                case 8: {
                    if (SmedAction.panelMain.mark.getLightAtt(SeaMark.Att.LIT, row) == SeaMark.Lit.DIR) {
                        SmedAction.panelMain.mark.setLightAtt(SeaMark.Att.ORT, row, value);
                        break;
                    }
                    SmedAction.panelMain.mark.setLightAtt(col - 1, row, value);
                    break;
                }
                case 12: {
                    for (SeaMark.Vis vis : PanelSectors.this.visibilities.keySet()) {
                        String str = PanelSectors.this.visibilities.get((Object)vis);
                        if (!str.equals(value)) continue;
                        SmedAction.panelMain.mark.setLightAtt(SeaMark.Att.VIS, row, (Object)vis);
                    }
                    break;
                }
                case 13: {
                    for (SeaMark.Exh exh : PanelSectors.this.exhibitions.keySet()) {
                        String str = PanelSectors.this.exhibitions.get((Object)exh);
                        if (!str.equals(value)) continue;
                        SmedAction.panelMain.mark.setLightAtt(SeaMark.Att.EXH, row, (Object)exh);
                    }
                    break;
                }
                default: {
                    SmedAction.panelMain.mark.setLightAtt(col - 1, row, value);
                }
            }
        }
    }
}

