/*
 * Decompiled with CFR 0.152.
 */
package pdfimport;

import java.awt.Color;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.tools.I18n;
import pdfimport.FilePlacement;
import pdfimport.LayerContents;
import pdfimport.PdfMultiPath;
import pdfimport.PdfPath;

public class OsmBuilder {
    private final FilePlacement placement;
    private String layerName;
    private String fillName;
    private String lineName;
    private Mode mode;
    private ProgressMonitor monitor;
    private int monitorPos;
    private int monitorTotal;

    public OsmBuilder(FilePlacement placement) {
        this.placement = placement;
    }

    public DataSet build(List<LayerContents> data, Mode mode, ProgressMonitor monitor) {
        this.monitor = monitor;
        this.monitorPos = 0;
        this.mode = mode;
        DataSet result = new DataSet();
        this.monitorTotal = 0;
        for (LayerContents layer : data) {
            this.monitorTotal += layer.paths.size();
            for (PdfMultiPath mp : layer.multiPaths) {
                this.monitorTotal += mp.paths.size();
            }
        }
        monitor.beginTask(I18n.tr((String)"Building JOSM layer", (Object[])new Object[0]), this.monitorTotal);
        for (LayerContents layer : data) {
            this.addLayer(result, layer);
        }
        monitor.finishTask();
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private void addLayer(DataSet target, LayerContents layer) {
        HashMap<Point2D, Node> point2Node = new HashMap<Point2D, Node>();
        this.fillName = this.printColor(layer.info.fill);
        this.lineName = this.printColor(layer.info.stroke);
        this.layerName = "" + layer.info.nr;
        for (Point2D point2D : layer.points) {
            Node node = new Node();
            node.setCoor(this.placement.tranformCoords(point2D));
            target.addPrimitive((OsmPrimitive)node);
            point2Node.put(point2D, node);
        }
        HashMap<PdfPath, Way> path2Way = new HashMap<PdfPath, Way>();
        for (PdfPath path : layer.paths) {
            Way w = this.insertWay(path, point2Node, -1, false);
            target.addPrimitive((OsmPrimitive)w);
            path2Way.put(path, w);
        }
        boolean bl = false;
        for (PdfMultiPath mpath : layer.multiPaths) {
            void var5_8;
            for (PdfPath path : mpath.paths) {
                Way w = this.insertWay(path, point2Node, (int)var5_8, true);
                target.addPrimitive((OsmPrimitive)w);
                path2Way.put(path, w);
            }
            ++var5_8;
        }
        if (this.mode != Mode.Draft) {
            for (PdfMultiPath mpath : layer.multiPaths) {
                Relation rel = new Relation();
                HashMap<String, String> keys = new HashMap<String, String>();
                keys.put("type", "multipolygon");
                keys.put("area", "yes");
                rel.setKeys(keys);
                for (PdfPath path : mpath.paths) {
                    Way w = (Way)path2Way.get(path);
                    rel.addMember(new RelationMember("", (OsmPrimitive)w));
                }
                target.addPrimitive((OsmPrimitive)rel);
            }
        }
    }

    private Way insertWay(PdfPath path, Map<Point2D, Node> point2Node, int multipathId, boolean multipolygon) {
        if (this.monitorPos % 100 == 0) {
            this.monitor.setExtraText(I18n.tr((String)(" " + this.monitorPos + "/" + this.monitorTotal), (Object[])new Object[0]));
            this.monitor.setTicks(this.monitorPos);
        }
        ++this.monitorPos;
        ArrayList<Node> nodes = new ArrayList<Node>(path.points.size());
        for (Point2D point : path.points) {
            Node node = point2Node.get(point);
            if (node == null) {
                throw new RuntimeException();
            }
            nodes.add(node);
        }
        HashMap<String, String> keys = new HashMap<String, String>();
        if (this.mode != Mode.Draft) {
            keys.put("PDF_nr", "" + path.nr);
            keys.put("PDF_layer", this.layerName);
            if (path.isClosed()) {
                keys.put("PDF_closed", "yes");
            }
            if (this.fillName != null) {
                keys.put("PDF_fillColor", this.fillName);
            }
            if (this.lineName != null) {
                keys.put("PDF_lineColor", this.lineName);
            }
            if (multipathId != -1) {
                keys.put("PDF_multipath", "" + multipathId);
            } else if (path.layer.info.fill != null && !multipolygon) {
                keys.put("area", "yes");
            }
        }
        if (this.mode == Mode.Debug) {
            keys.put("PDF_pathLayer", "" + path.layer.info.nr);
            keys.put("PDF_lineWidth", "" + path.layer.info.width);
            keys.put("PDF_lineDash", "" + path.layer.info.dash);
            keys.put("PDF_layerHash", "" + path.layer.info.hashCode());
            keys.put("PDF_layerDivider", "" + path.layer.info.divider);
        }
        Way newWay = new Way();
        newWay.setNodes(nodes);
        newWay.setKeys(keys);
        return newWay;
    }

    private String printColor(Color col) {
        if (col == null) {
            return null;
        }
        String s = Integer.toHexString(col.getRGB() & 0xFFFFFF);
        while (s.length() < 6) {
            s = "0" + s;
        }
        return "#" + s;
    }

    static enum Mode {
        Draft,
        Final,
        Debug;

    }
}

