/*
 * Decompiled with CFR 0.152.
 */
package relcontext.actions;

import java.awt.event.ActionEvent;
import java.util.Collections;
import javax.swing.AbstractAction;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.DeleteCommand;
import org.openstreetmap.josm.data.UndoRedoHandler;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import relcontext.ChosenRelation;
import relcontext.ChosenRelationListener;

public class DeleteChosenRelationAction
extends AbstractAction
implements ChosenRelationListener {
    private ChosenRelation rel;

    public DeleteChosenRelationAction(ChosenRelation rel) {
        super(I18n.tr((String)"Delete relation", (Object[])new Object[0]));
        this.putValue("SmallIcon", ImageProvider.get((String)"dialogs", (String)"delete"));
        this.rel = rel;
        rel.addChosenRelationListener(this);
        this.setEnabled(rel.get() != null);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Relation r = this.rel.get();
        this.rel.clear();
        Command c = DeleteCommand.delete(Collections.singleton(r), (boolean)true, (boolean)true);
        if (c != null) {
            UndoRedoHandler.getInstance().add(c);
        }
    }

    @Override
    public void chosenRelationChanged(Relation oldRelation, Relation newRelation) {
        this.setEnabled(newRelation != null);
    }
}

