/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input.buffer;

import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import org.apache.commons.io.input.buffer.CircularByteBuffer;

public class CircularBufferInputStream
extends InputStream {
    protected final InputStream in;
    protected final CircularByteBuffer buffer;
    protected final int bufferSize;
    private boolean eofSeen;

    public CircularBufferInputStream(InputStream pIn, int pBufferSize) {
        Objects.requireNonNull(pIn, "InputStream");
        if (pBufferSize <= 0) {
            throw new IllegalArgumentException("Invalid buffer size: " + pBufferSize);
        }
        this.in = pIn;
        this.buffer = new CircularByteBuffer(pBufferSize);
        this.bufferSize = pBufferSize;
        this.eofSeen = false;
    }

    public CircularBufferInputStream(InputStream pIn) {
        this(pIn, 8192);
    }

    protected void fillBuffer() throws IOException {
        if (this.eofSeen) {
            return;
        }
        int space = this.buffer.getSpace();
        byte[] buf = new byte[space];
        while (space > 0) {
            int res = this.in.read(buf, 0, space);
            if (res == -1) {
                this.eofSeen = true;
                return;
            }
            if (res <= 0) continue;
            this.buffer.add(buf, 0, res);
            space -= res;
        }
    }

    protected boolean haveBytes(int pNumber) throws IOException {
        if (this.buffer.getCurrentNumberOfBytes() < pNumber) {
            this.fillBuffer();
        }
        return this.buffer.hasBytes();
    }

    @Override
    public int read() throws IOException {
        if (!this.haveBytes(1)) {
            return -1;
        }
        return this.buffer.read();
    }

    @Override
    public int read(byte[] pBuffer) throws IOException {
        return this.read(pBuffer, 0, pBuffer.length);
    }

    @Override
    public int read(byte[] pBuffer, int pOffset, int pLength) throws IOException {
        Objects.requireNonNull(pBuffer, "Buffer");
        if (pOffset < 0) {
            throw new IllegalArgumentException("Offset must not be negative");
        }
        if (pLength < 0) {
            throw new IllegalArgumentException("Length must not be negative");
        }
        if (!this.haveBytes(pLength)) {
            return -1;
        }
        int result = Math.min(pLength, this.buffer.getCurrentNumberOfBytes());
        for (int i = 0; i < result; ++i) {
            pBuffer[pOffset + i] = this.buffer.read();
        }
        return result;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
        this.eofSeen = true;
        this.buffer.clear();
    }
}

