/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.osmrec.extractor;

import com.cybozu.labs.langdetect.Detector;
import com.cybozu.labs.langdetect.DetectorFactory;
import com.cybozu.labs.langdetect.LangDetectException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;

public final class LanguageDetector {
    private static LanguageDetector languageDetector = null;

    private LanguageDetector() {
    }

    public static LanguageDetector getInstance(String languageProfilesPath) {
        if (languageDetector == null) {
            languageDetector = new LanguageDetector();
            LanguageDetector.loadProfilesFromStream(languageProfilesPath);
        }
        return languageDetector;
    }

    public static void loadProfilesFromStream(String languageProfilesPath) {
        InputStream languageProfilesInputStreamEl = LanguageDetector.class.getResourceAsStream("/profiles/el");
        InputStream languageProfilesInputStreamEn = LanguageDetector.class.getResourceAsStream("/profiles/en");
        InputStream languageProfilesInputStreamDe = LanguageDetector.class.getResourceAsStream("/profiles/de");
        InputStream languageProfilesInputStreamFr = LanguageDetector.class.getResourceAsStream("/profiles/fr");
        InputStream languageProfilesInputStreamEs = LanguageDetector.class.getResourceAsStream("/profiles/es");
        InputStream languageProfilesInputStreamRu = LanguageDetector.class.getResourceAsStream("/profiles/ru");
        InputStream languageProfilesInputStreamTr = LanguageDetector.class.getResourceAsStream("/profiles/tr");
        InputStream languageProfilesInputStreamZh = LanguageDetector.class.getResourceAsStream("/profiles/zh-cn");
        InputStream languageProfilesInputStreamHi = LanguageDetector.class.getResourceAsStream("/profiles/hi");
        if (!new File(languageProfilesPath).exists()) {
            Utils.mkDirs((File)new File(languageProfilesPath));
        }
        File languageProfilesOutputFileEl = new File(languageProfilesPath + "/el");
        File languageProfilesOutputFileEn = new File(languageProfilesPath + "/en");
        File languageProfilesOutputFileDe = new File(languageProfilesPath + "/de");
        File languageProfilesOutputFileFr = new File(languageProfilesPath + "/fr");
        File languageProfilesOutputFileEs = new File(languageProfilesPath + "/es");
        File languageProfilesOutputFileRu = new File(languageProfilesPath + "/ru");
        File languageProfilesOutputFileTr = new File(languageProfilesPath + "/tr");
        File languageProfilesOutputFileZh = new File(languageProfilesPath + "/zh-cn");
        File languageProfilesOutputFileHi = new File(languageProfilesPath + "/hi");
        try {
            languageProfilesOutputFileEl.createNewFile();
            languageProfilesOutputFileEn.createNewFile();
            languageProfilesOutputFileDe.createNewFile();
            languageProfilesOutputFileFr.createNewFile();
            languageProfilesOutputFileEs.createNewFile();
            languageProfilesOutputFileRu.createNewFile();
            languageProfilesOutputFileTr.createNewFile();
            languageProfilesOutputFileZh.createNewFile();
            languageProfilesOutputFileHi.createNewFile();
        }
        catch (IOException ex) {
            Logger.getLogger(LanguageDetector.class.getName()).log(Level.SEVERE, null, ex);
            Logging.error((Throwable)ex);
        }
        try {
            Files.copy(languageProfilesInputStreamEl, languageProfilesOutputFileEl.toPath(), new CopyOption[0]);
            Files.copy(languageProfilesInputStreamEn, languageProfilesOutputFileEn.toPath(), new CopyOption[0]);
            Files.copy(languageProfilesInputStreamDe, languageProfilesOutputFileDe.toPath(), new CopyOption[0]);
            Files.copy(languageProfilesInputStreamFr, languageProfilesOutputFileFr.toPath(), new CopyOption[0]);
            Files.copy(languageProfilesInputStreamEs, languageProfilesOutputFileEs.toPath(), new CopyOption[0]);
            Files.copy(languageProfilesInputStreamRu, languageProfilesOutputFileRu.toPath(), new CopyOption[0]);
            Files.copy(languageProfilesInputStreamTr, languageProfilesOutputFileTr.toPath(), new CopyOption[0]);
            Files.copy(languageProfilesInputStreamZh, languageProfilesOutputFileZh.toPath(), new CopyOption[0]);
            Files.copy(languageProfilesInputStreamHi, languageProfilesOutputFileHi.toPath(), new CopyOption[0]);
        }
        catch (IOException ex) {
            Logger.getLogger(LanguageDetector.class.getName()).log(Level.SEVERE, null, ex);
            Logging.error((Throwable)ex);
        }
        try {
            DetectorFactory.loadProfile(languageProfilesPath);
        }
        catch (LangDetectException ex) {
            Logger.getLogger(LanguageDetector.class.getName()).log(Level.SEVERE, null, ex);
            Logging.error((Throwable)ex);
        }
    }

    public String detect(String text) {
        try {
            Detector detector = DetectorFactory.create();
            detector.append(text);
            return detector.detect();
        }
        catch (LangDetectException ex) {
            Logger.getLogger(LanguageDetector.class.getName()).log(Level.SEVERE, null, ex);
            Logging.error((Throwable)ex);
            return "en";
        }
    }
}

