/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.commandline;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.AbstractPrimitive;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.plugins.commandline.CommandLine;
import org.openstreetmap.josm.plugins.commandline.Parameter;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Logging;

public class PointAction
extends MapMode
implements AWTEventListener {
    private final CommandLine parentPlugin;
    private final Cursor cursorCrosshair;
    private final Cursor cursorJoinNode;
    private Cursor currentCursor;
    private Point mousePos;
    private Node nearestNode;
    private final ArrayList<String> pointList;
    private boolean isCtrlDown;

    public PointAction(CommandLine parentPlugin) {
        super(null, "addsegment.png", null, ImageProvider.getCursor((String)"crosshair", null));
        this.parentPlugin = parentPlugin;
        this.cursorCrosshair = ImageProvider.getCursor((String)"crosshair", null);
        this.cursorJoinNode = ImageProvider.getCursor((String)"crosshair", (String)"joinnode");
        this.currentCursor = this.cursorCrosshair;
        this.nearestNode = null;
        this.pointList = new ArrayList();
    }

    public void enterMode() {
        super.enterMode();
        if (this.getLayerManager().getEditDataSet() == null) {
            MainApplication.getMap().selectSelectTool(false);
            return;
        }
        this.currentCursor = this.cursorCrosshair;
        MainApplication.getMap().mapView.addMouseListener((MouseListener)((Object)this));
        MainApplication.getMap().mapView.addMouseMotionListener((MouseMotionListener)((Object)this));
        try {
            Toolkit.getDefaultToolkit().addAWTEventListener(this, 8L);
        }
        catch (SecurityException ex) {
            Logging.warn((Throwable)ex);
        }
    }

    public void exitMode() {
        super.exitMode();
        MainApplication.getMap().mapView.removeMouseListener((MouseListener)((Object)this));
        MainApplication.getMap().mapView.removeMouseMotionListener((MouseMotionListener)((Object)this));
        try {
            Toolkit.getDefaultToolkit().removeAWTEventListener(this);
        }
        catch (SecurityException ex) {
            Logging.warn((Throwable)ex);
        }
    }

    public void mousePressed(MouseEvent e) {
        if (e.getButton() == 1) {
            if (this.isCtrlDown) {
                if (this.pointList.size() > 0) {
                    this.pointList.remove(this.pointList.size() - 1);
                    this.updateTextEdit();
                }
            } else {
                LatLon coor = this.nearestNode == null ? MainApplication.getMap().mapView.getLatLon(e.getX(), e.getY()) : this.nearestNode.getCoor();
                if (coor.isOutSideWorld()) {
                    JOptionPane.showMessageDialog((Component)MainApplication.getMainFrame(), I18n.tr((String)"Can not draw outside of the world.", (Object[])new Object[0]));
                    return;
                }
                String point = String.valueOf(coor.getX()) + "," + String.valueOf(coor.getY());
                int maxInstances = this.parentPlugin.currentCommand.parameters.get((int)this.parentPlugin.currentCommand.currentParameterNum).maxInstances;
                if (maxInstances == 1) {
                    this.parentPlugin.loadParameter(point, true);
                } else if (this.pointList.size() < maxInstances || maxInstances == 0) {
                    this.pointList.add(point);
                    this.updateTextEdit();
                } else {
                    Logging.info((String)"Maximum instances!");
                }
            }
        }
    }

    public void mouseMoved(MouseEvent e) {
        if (!MainApplication.getMap().mapView.isActiveLayerDrawable()) {
            return;
        }
        this.processMouseEvent(e);
        this.updCursor();
        MainApplication.getMap().mapView.repaint();
    }

    @Override
    public void eventDispatched(AWTEvent arg0) {
        if (!(arg0 instanceof KeyEvent)) {
            return;
        }
        KeyEvent ev = (KeyEvent)arg0;
        boolean bl = this.isCtrlDown = (ev.getModifiersEx() & 0x80) != 0;
        if (ev.getKeyCode() == 27 && ev.getID() == 401) {
            ev.consume();
            this.cancelDrawing();
        }
    }

    private void updCursor() {
        if (this.mousePos != null) {
            if (!MainApplication.isDisplayingMapView()) {
                return;
            }
            this.nearestNode = MainApplication.getMap().mapView.getNearestNode(this.mousePos, AbstractPrimitive::isUsable);
            if (this.nearestNode != null) {
                this.setCursor(this.cursorJoinNode);
            } else {
                this.setCursor(this.cursorCrosshair);
            }
        }
    }

    private void processMouseEvent(MouseEvent e) {
        if (e != null) {
            this.mousePos = e.getPoint();
        }
    }

    private void setCursor(Cursor c) {
        if (this.currentCursor.equals(c)) {
            return;
        }
        try {
            EventQueue.invokeLater(() -> {
                if (!(MainApplication.getMap().mapMode instanceof PointAction)) {
                    return;
                }
                MainApplication.getMap().mapView.setCursor(c);
            });
            this.currentCursor = c;
        }
        catch (Exception e) {
            Logging.warn((Throwable)e);
        }
    }

    public void cancelDrawing() {
        if (!MainApplication.isDisplayingMapView()) {
            return;
        }
        MapFrame map = MainApplication.getMap();
        map.statusLine.setHeading(-1.0);
        map.statusLine.setAngle(-1.0);
        map.mapView.repaint();
        this.updateStatusLine();
        this.parentPlugin.abortInput();
    }

    public String currentValue() {
        String out = "";
        boolean first = true;
        for (String point : this.pointList) {
            if (!first) {
                out = out + ";";
            }
            out = out + point;
            first = false;
        }
        return out;
    }

    private void updateTextEdit() {
        Parameter currentParameter = this.parentPlugin.currentCommand.parameters.get(this.parentPlugin.currentCommand.currentParameterNum);
        String prefix = I18n.tr((String)currentParameter.description, (Object[])new Object[0]);
        prefix = prefix + this.parentPlugin.commandSymbol;
        String value = this.currentValue();
        this.parentPlugin.textField.setText(prefix + value);
    }
}

