/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.osmrec;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import de.bwaldvogel.liblinear.Feature;
import de.bwaldvogel.liblinear.FeatureNode;
import de.bwaldvogel.liblinear.Linear;
import de.bwaldvogel.liblinear.Model;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.concurrent.CancellationException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.text.JTextComponent;
import org.geotools.geometry.jts.JTS;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeocentricCRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.UndoRedoHandler;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmDataManager;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Tag;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.preferences.BooleanProperty;
import org.openstreetmap.josm.data.preferences.IntegerProperty;
import org.openstreetmap.josm.data.tagging.ac.AutoCompletionItem;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.mappaint.MapPaintStyles;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletingComboBox;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionManager;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.util.WindowGeometry;
import org.openstreetmap.josm.gui.widgets.PopupMenuLauncher;
import org.openstreetmap.josm.io.XmlWriter;
import org.openstreetmap.josm.plugins.osmrec.container.OSMWay;
import org.openstreetmap.josm.plugins.osmrec.core.TrainWorker;
import org.openstreetmap.josm.plugins.osmrec.extractor.LanguageDetector;
import org.openstreetmap.josm.plugins.osmrec.extractor.SampleModelsExtractor;
import org.openstreetmap.josm.plugins.osmrec.features.ClassFeatures;
import org.openstreetmap.josm.plugins.osmrec.features.GeometryFeatures;
import org.openstreetmap.josm.plugins.osmrec.features.OSMClassification;
import org.openstreetmap.josm.plugins.osmrec.features.TextualFeatures;
import org.openstreetmap.josm.plugins.osmrec.parsers.Mapper;
import org.openstreetmap.josm.plugins.osmrec.parsers.OSMParser;
import org.openstreetmap.josm.plugins.osmrec.parsers.Ontology;
import org.openstreetmap.josm.plugins.osmrec.parsers.TextualStatistics;
import org.openstreetmap.josm.plugins.osmrec.personalization.UserDataExtractAndTrainWorker;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Shortcut;
import org.openstreetmap.josm.tools.Utils;

class OSMRecPluginHelper {
    private final DefaultTableModel tagData;
    private static Collection<String> fileHistory;
    private Map<File, Double> filesAndWeights = new HashMap<File, Double>();
    private boolean useCombinedModel;
    private static String MAIN_PATH;
    private static String MODEL_PATH;
    private static String TEXTUAL_LIST_PATH;
    private static Map<String, List<String>> indirectClasses;
    private static Map<String, Integer> indirectClassesWithIDs;
    private static LanguageDetector languageDetector;
    private static String bestModelPath;
    private boolean modelWithClasses;
    private final String modelWithClassesPath;
    private boolean useCustomSVMModel = false;
    private String customSVMModelPath;
    private final String combinedModelClasses;
    Collection<OsmPrimitive> sel;
    private String changedKey;
    Comparator<AutoCompletionItem> defaultACItemComparator = new Comparator<AutoCompletionItem>(){

        @Override
        public int compare(AutoCompletionItem o1, AutoCompletionItem o2) {
            return String.CASE_INSENSITIVE_ORDER.compare(o1.getValue(), o2.getValue());
        }
    };
    private String lastAddKey = null;
    private String lastAddValue = null;
    public static final int DEFAULT_LRU_TAGS_NUMBER = 5;
    public static final int MAX_LRU_TAGS_NUMBER = 30;
    private final Map<Tag, Void> recentTags = new LinkedHashMap<Tag, Void>(31, 1.1f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<Tag, Void> eldest) {
            return this.size() > 30;
        }
    };
    public static final BooleanProperty PROPERTY_FIX_TAG_LOCALE;
    public static final BooleanProperty PROPERTY_REMEMBER_TAGS;
    public static final IntegerProperty PROPERTY_RECENT_TAGS_NUMBER;

    OSMRecPluginHelper(DefaultTableModel propertyData, Map<String, Map<String, Integer>> valueCount) {
        this.tagData = propertyData;
        fileHistory = Config.getPref().getList("file-open.history");
        MAIN_PATH = !fileHistory.isEmpty() ? (String)fileHistory.toArray()[0] : System.getProperty("user.home");
        MODEL_PATH = new File(MAIN_PATH).getParentFile() + "/OSMRec_models";
        TEXTUAL_LIST_PATH = MODEL_PATH + "/textualList.txt";
        this.combinedModelClasses = MODEL_PATH + "/combinedModel.1";
        this.customSVMModelPath = bestModelPath = MODEL_PATH + "/best_model";
        this.modelWithClassesPath = MODEL_PATH + "/model_with_classes";
        languageDetector = LanguageDetector.getInstance(MODEL_PATH + "/profiles");
        SampleModelsExtractor sampleModelsExtractor = new SampleModelsExtractor();
        sampleModelsExtractor.extractSampleSVMmodel("best_model", bestModelPath);
        sampleModelsExtractor.extractSampleSVMmodel("model_with_classes", this.modelWithClassesPath);
    }

    public void addTag() {
        this.changedKey = null;
        this.sel = OsmDataManager.getInstance().getInProgressSelection();
        if (this.sel == null || this.sel.isEmpty()) {
            return;
        }
        AddTagsDialog addDialog = new AddTagsDialog();
        addDialog.showDialog();
        addDialog.destroyActions();
        if (addDialog.getValue() == 1) {
            addDialog.performTagAdding();
        } else {
            addDialog.undoAllTagsAdding();
        }
    }

    public void editTag(int row, boolean focusOnKey) {
        this.changedKey = null;
        this.sel = OsmDataManager.getInstance().getInProgressSelection();
        String key = "";
        HashMap<String, Integer> dumPar = new HashMap<String, Integer>();
        dumPar.put(" ", -1);
        TrainingDialog editDialog = new TrainingDialog(key, row, dumPar, focusOnKey);
        editDialog.showDialog();
    }

    public String getChangedKey() {
        return this.changedKey;
    }

    private static List<String> getAutocompletionKeys(String key) {
        if ("name".equals(key) || "addr:street".equals(key)) {
            return Arrays.asList("addr:street", "name");
        }
        return Arrays.asList(key);
    }

    public void loadTagsIfNeeded() {
        if (PROPERTY_REMEMBER_TAGS.get().booleanValue() && this.recentTags.isEmpty()) {
            this.recentTags.clear();
            List c = Config.getPref().getList("properties.recent-tags");
            Iterator it = c.iterator();
            while (it.hasNext()) {
                String key = (String)it.next();
                String value = (String)it.next();
                this.recentTags.put(new Tag(key, value), null);
            }
        }
    }

    public void saveTagsIfNeeded() {
        if (PROPERTY_REMEMBER_TAGS.get().booleanValue() && !this.recentTags.isEmpty()) {
            ArrayList<String> c = new ArrayList<String>(this.recentTags.size() * 2);
            for (Tag t : this.recentTags.keySet()) {
                c.add(t.getKey());
                c.add(t.getValue());
            }
            Config.getPref().putList("properties.recent-tags", c);
        }
    }

    private boolean warnOverwriteKey(String action, String togglePref) {
        ExtendedDialog ed = new ExtendedDialog((Component)MainApplication.getMainFrame(), I18n.tr((String)"Overwrite key", (Object[])new Object[0]), new String[]{I18n.tr((String)"Replace", (Object[])new Object[0]), I18n.tr((String)"Cancel", (Object[])new Object[0])});
        ed.setButtonIcons(new String[]{"purge", "cancel"});
        ed.setContent(action + "\n" + I18n.tr((String)"The new key is already used, overwrite values?", (Object[])new Object[0]));
        ed.setCancelButton(new Integer[]{2});
        ed.toggleEnable(togglePref);
        ed.showDialog();
        return ed.getValue() == 1;
    }

    static {
        PROPERTY_FIX_TAG_LOCALE = new BooleanProperty("properties.fix-tag-combobox-locale", false);
        PROPERTY_REMEMBER_TAGS = new BooleanProperty("properties.remember-recently-added-tags", true);
        PROPERTY_RECENT_TAGS_NUMBER = new IntegerProperty("properties.recently-added-tags", 5);
    }

    class AddTagsDialog
    extends AbstractTagsDialog {
        List<JosmAction> recentTagsActions;
        private int commandCount;
        private final JLabel recommendedClassesLabel;
        private final JButton modelSettingsButton;
        private final JButton addAndContinueButton;
        private final DefaultListModel<String> model;
        private final JList<String> categoryList;
        private Model modelSVM;
        private int modelSVMLabelSize;
        private int[] modelSVMLabels;
        private Map<String, String> mappings;
        private Map<String, Integer> mapperWithIDs;
        private Map<Integer, String> idsWithMappings;
        private List<String> textualList;
        private final JCheckBox useTagsCheckBox;
        private ModelSettingsDialog modelSettingsDialog;
        private static final int RECOMMENDATIONS_SIZE = 10;

        AddTagsDialog() {
            super((Component)MainApplication.getMainFrame(), I18n.tr((String)"Add value?", (Object[])new Object[0]), new String[]{I18n.tr((String)"OK", (Object[])new Object[0]), I18n.tr((String)"Cancel", (Object[])new Object[0])});
            this.recentTagsActions = new ArrayList<JosmAction>();
            this.textualList = new ArrayList<String>();
            this.setButtonIcons(new String[]{"ok", "cancel"});
            this.setCancelButton(new Integer[]{2});
            this.configureContextsensitiveHelp("/Dialog/AddValue", true);
            final AddTagsDialog addTagsDialog = this;
            this.loadOntology();
            System.out.println("path for textual: " + TEXTUAL_LIST_PATH);
            File textualListFile = new File(TEXTUAL_LIST_PATH);
            if (textualListFile.exists()) {
                this.loadTextualList(textualListFile);
            } else {
                this.loadDefaultTextualList();
            }
            JPanel splitPanel = new JPanel(new BorderLayout(10, 10));
            JPanel mainPanel = new JPanel(new GridBagLayout());
            JPanel recommendPanel = new JPanel(new BorderLayout(10, 10));
            JPanel listPanel = new JPanel(new BorderLayout(10, 10));
            JPanel actionsPanel = new JPanel(new FlowLayout(0));
            this.addAndContinueButton = new JButton("Add and continue");
            this.modelSettingsButton = new JButton("Model Settings");
            this.useTagsCheckBox = new JCheckBox("Predict using tags");
            this.recommendedClassesLabel = new JLabel("Recommended Classes:");
            this.addAndContinueButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    String selectedClass = (String)AddTagsDialog.this.categoryList.getSelectedValue();
                    AddTagsDialog.this.addAndContinueButtonActionPerformed(evt, selectedClass);
                    ArrayList<OsmPrimitive> osmPrimitiveSelection = new ArrayList<OsmPrimitive>(OSMRecPluginHelper.this.sel);
                    if (!osmPrimitiveSelection.isEmpty()) {
                        OsmPrimitive s = (OsmPrimitive)osmPrimitiveSelection.get(0);
                        if (s.getInterestingTags().isEmpty()) {
                            OSMRecPluginHelper.this.modelWithClasses = false;
                            AddTagsDialog.this.loadSVMmodel();
                            AddTagsDialog.this.createOSMObject(OSMRecPluginHelper.this.sel);
                        } else {
                            AddTagsDialog.this.useTagsCheckBox.setSelected(true);
                            if (AddTagsDialog.this.useTagsCheckBox.isSelected()) {
                                OSMRecPluginHelper.this.modelWithClasses = true;
                                AddTagsDialog.this.loadSVMmodel();
                                AddTagsDialog.this.createOSMObject(OSMRecPluginHelper.this.sel);
                            } else {
                                OSMRecPluginHelper.this.modelWithClasses = false;
                                AddTagsDialog.this.loadSVMmodel();
                                AddTagsDialog.this.createOSMObject(OSMRecPluginHelper.this.sel);
                            }
                        }
                    }
                }
            });
            this.modelSettingsButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    if (AddTagsDialog.this.modelSettingsDialog == null) {
                        System.out.println("new modelSettingsDialog");
                        AddTagsDialog.this.modelSettingsDialog = new ModelSettingsDialog(OSMRecPluginHelper.this.sel, addTagsDialog);
                    } else {
                        System.out.println("set modelSettingsDialog visible");
                        AddTagsDialog.this.modelSettingsDialog.makeVisible(true);
                    }
                }
            });
            this.useTagsCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    ArrayList<OsmPrimitive> osmPrimitiveSelection = new ArrayList<OsmPrimitive>(OSMRecPluginHelper.this.sel);
                    if (!osmPrimitiveSelection.isEmpty()) {
                        OsmPrimitive s = (OsmPrimitive)osmPrimitiveSelection.get(0);
                        if (s.getInterestingTags().isEmpty()) {
                            OSMRecPluginHelper.this.modelWithClasses = false;
                            AddTagsDialog.this.loadSVMmodel();
                            AddTagsDialog.this.createOSMObject(OSMRecPluginHelper.this.sel);
                        } else if (AddTagsDialog.this.useTagsCheckBox.isSelected()) {
                            OSMRecPluginHelper.this.modelWithClasses = true;
                            AddTagsDialog.this.loadSVMmodel();
                            AddTagsDialog.this.createOSMObject(OSMRecPluginHelper.this.sel);
                        } else {
                            OSMRecPluginHelper.this.modelWithClasses = false;
                            AddTagsDialog.this.loadSVMmodel();
                            AddTagsDialog.this.createOSMObject(OSMRecPluginHelper.this.sel);
                        }
                    }
                }
            });
            this.keys = new AutoCompletingComboBox();
            this.values = new AutoCompletingComboBox();
            mainPanel.add((Component)new JLabel("<html>" + I18n.trn((String)"This will change up to {0} object.", (String)"This will change up to {0} objects.", (long)OSMRecPluginHelper.this.sel.size(), (Object[])new Object[]{OSMRecPluginHelper.this.sel.size()}) + "<br><br>" + I18n.tr((String)"Please select a key", (Object[])new Object[0])), GBC.eol().fill(2));
            AutoCompletionManager autocomplete = AutoCompletionManager.of((DataSet)MainApplication.getLayerManager().getEditLayer().data);
            ArrayList keyList = new ArrayList(autocomplete.getTagKeys());
            AutoCompletionItem itemToSelect = null;
            Iterator iter = keyList.iterator();
            block0: while (iter.hasNext()) {
                AutoCompletionItem item = (AutoCompletionItem)iter.next();
                if (item.getValue().equals(OSMRecPluginHelper.this.lastAddKey)) {
                    itemToSelect = item;
                }
                for (int i = 0; i < OSMRecPluginHelper.this.tagData.getRowCount(); ++i) {
                    if (!item.getValue().equals(OSMRecPluginHelper.this.tagData.getValueAt(i, 0))) continue;
                    if (itemToSelect == item) {
                        itemToSelect = null;
                    }
                    iter.remove();
                    continue block0;
                }
            }
            Collections.sort(keyList, OSMRecPluginHelper.this.defaultACItemComparator);
            this.keys.setPossibleAcItems(keyList);
            this.keys.setEditable(true);
            mainPanel.add((Component)this.keys, GBC.eop().fill());
            mainPanel.add((Component)new JLabel(I18n.tr((String)"Please select a value", (Object[])new Object[0])), GBC.eol());
            this.model = new DefaultListModel();
            this.parseTagsMappedToClasses();
            ArrayList<OsmPrimitive> osmPrimitiveSelection = new ArrayList<OsmPrimitive>(OSMRecPluginHelper.this.sel);
            if (!osmPrimitiveSelection.isEmpty()) {
                OsmPrimitive s = (OsmPrimitive)osmPrimitiveSelection.get(0);
                File modelDirectory = new File(MODEL_PATH);
                String modelWithClassesPath = modelDirectory.getAbsolutePath() + "/model_with_classes";
                File modelWithClassesFile = new File(modelWithClassesPath);
                if (s.getInterestingTags().isEmpty() || !modelWithClassesFile.exists()) {
                    OSMRecPluginHelper.this.modelWithClasses = false;
                    this.loadSVMmodel();
                    this.createOSMObject(OSMRecPluginHelper.this.sel);
                } else {
                    this.useTagsCheckBox.setSelected(true);
                    OSMRecPluginHelper.this.modelWithClasses = true;
                    this.loadSVMmodel();
                    this.createOSMObject(OSMRecPluginHelper.this.sel);
                }
            }
            this.categoryList = new JList<String>(this.model);
            ListSelectionListener listSelectionListener = new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    String selectedClass;
                    if (!listSelectionEvent.getValueIsAdjusting() && (selectedClass = (String)AddTagsDialog.this.categoryList.getSelectedValue()) != null) {
                        if (selectedClass.indexOf(" ") + 1 > 0) {
                            String keyTag = selectedClass.substring(0, selectedClass.indexOf(" "));
                            String valueTag = selectedClass.substring(selectedClass.indexOf(" ") + 1, selectedClass.length());
                            AddTagsDialog.this.keys.setSelectedItem((Object)keyTag);
                            AddTagsDialog.this.values.setSelectedItem((Object)valueTag);
                        } else {
                            String keyTag = selectedClass;
                            AddTagsDialog.this.keys.setSelectedItem((Object)keyTag);
                            AddTagsDialog.this.values.setSelectedItem((Object)"");
                        }
                    }
                }
            };
            this.categoryList.addListSelectionListener(listSelectionListener);
            this.categoryList.setBorder(BorderFactory.createEtchedBorder(1, Color.GRAY, Color.WHITE));
            this.categoryList.setModel(this.model);
            this.values.setEditable(true);
            mainPanel.add((Component)this.values, GBC.eop().fill());
            if (itemToSelect != null) {
                this.keys.setSelectedItem((Object)itemToSelect);
                if (OSMRecPluginHelper.this.lastAddValue != null) {
                    this.values.setSelectedItem((Object)OSMRecPluginHelper.this.lastAddValue);
                }
            }
            FocusAdapter focus = this.addFocusAdapter(autocomplete, OSMRecPluginHelper.this.defaultACItemComparator);
            focus.focusGained(null);
            int recentTagsToShow = PROPERTY_RECENT_TAGS_NUMBER.get();
            if (recentTagsToShow > 30) {
                recentTagsToShow = 30;
            }
            this.suggestRecentlyAddedTags(mainPanel, recentTagsToShow, focus);
            mainPanel.setBorder(BorderFactory.createEtchedBorder(1, Color.GRAY, Color.WHITE));
            listPanel.setBorder(BorderFactory.createEtchedBorder(1, Color.GRAY, Color.WHITE));
            splitPanel.setBorder(BorderFactory.createEtchedBorder(1, Color.GRAY, Color.WHITE));
            listPanel.add((Component)this.recommendedClassesLabel, "North");
            listPanel.add(this.categoryList, "South");
            actionsPanel.add(this.addAndContinueButton);
            actionsPanel.add(this.modelSettingsButton);
            actionsPanel.add(this.useTagsCheckBox);
            recommendPanel.add((Component)actionsPanel, "West");
            recommendPanel.add((Component)listPanel, "North");
            splitPanel.add((Component)mainPanel, "West");
            splitPanel.add((Component)recommendPanel, "East");
            this.setContent(splitPanel, false);
            this.popupMenu.add(new AbstractAction(I18n.tr((String)"Set number of recently added tags", (Object[])new Object[0])){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AddTagsDialog.this.selectNumberOfTags();
                }
            });
            JCheckBoxMenuItem rememberLastTags = new JCheckBoxMenuItem(new AbstractAction(I18n.tr((String)"Remember last used tags after a restart", (Object[])new Object[0])){

                @Override
                public void actionPerformed(ActionEvent e) {
                    boolean sel = ((JCheckBoxMenuItem)e.getSource()).getState();
                    PROPERTY_REMEMBER_TAGS.put(Boolean.valueOf(sel));
                    if (sel) {
                        OSMRecPluginHelper.this.saveTagsIfNeeded();
                    }
                }
            });
            rememberLastTags.setState(PROPERTY_REMEMBER_TAGS.get());
            this.popupMenu.add(rememberLastTags);
        }

        private void addAndContinueButtonActionPerformed(ActionEvent evt, String selectedClass) {
            this.performTagAdding();
        }

        private void selectNumberOfTags() {
            String s = JOptionPane.showInputDialog((Component)((Object)this), (Object)I18n.tr((String)"Please enter the number of recently added tags to display", (Object[])new Object[0]));
            if (s != null) {
                try {
                    int v = Integer.parseInt(s);
                    if (v >= 0 && v <= 30) {
                        PROPERTY_RECENT_TAGS_NUMBER.put(Integer.valueOf(v));
                        return;
                    }
                }
                catch (NumberFormatException ex) {
                    Logging.warn((Throwable)ex);
                }
            }
            JOptionPane.showMessageDialog((Component)((Object)this), I18n.tr((String)"Please enter integer number between 0 and {0}", (Object[])new Object[]{30}));
        }

        private void suggestRecentlyAddedTags(JPanel mainPanel, int tagsToShow, final FocusAdapter focus) {
            if (tagsToShow <= 0 || OSMRecPluginHelper.this.recentTags.isEmpty()) {
                return;
            }
            mainPanel.add((Component)new JLabel(I18n.tr((String)"Recently added tags", (Object[])new Object[0])), GBC.eol());
            int count = 1;
            LinkedList tags = new LinkedList(OSMRecPluginHelper.this.recentTags.keySet());
            for (int i = tags.size() - 1; i >= 0 && count <= tagsToShow; --i, ++count) {
                final Tag t = (Tag)tags.get(i);
                String scKey = "properties:recent:" + count;
                String scsKey = "properties:recent:shift:" + count;
                Shortcut sc = Shortcut.registerShortcut((String)scKey, (String)I18n.tr((String)"Choose recent tag {0}", (Object[])new Object[]{count}), (int)(48 + count), (int)5006);
                final JosmAction action = new JosmAction(scKey, null, I18n.tr((String)"Use this tag again", (Object[])new Object[0]), sc, false){

                    public void actionPerformed(ActionEvent e) {
                        AddTagsDialog.this.keys.setSelectedItem((Object)t.getKey());
                        focus.focusGained(null);
                        AddTagsDialog.this.values.setSelectedItem((Object)t.getValue());
                    }
                };
                Shortcut scs = Shortcut.registerShortcut((String)scsKey, (String)I18n.tr((String)"Apply recent tag {0}", (Object[])new Object[]{count}), (int)(48 + count), (int)5009);
                JosmAction actionShift = new JosmAction(scsKey, null, I18n.tr((String)"Use this tag again", (Object[])new Object[0]), scs, false){

                    public void actionPerformed(ActionEvent e) {
                        action.actionPerformed(null);
                        AddTagsDialog.this.performTagAdding();
                    }
                };
                this.recentTagsActions.add(action);
                this.recentTagsActions.add(actionShift);
                this.disableTagIfNeeded(t, action);
                ImageIcon icon = MapPaintStyles.getNodeIcon((Tag)t, (boolean)false);
                if (icon == null) {
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put(t.getKey(), t.getValue());
                    if (icon == null) {
                        icon = new ImageIcon(new BufferedImage(16, 16, 2));
                    }
                }
                GridBagConstraints gbc = new GridBagConstraints();
                gbc.ipadx = 5;
                mainPanel.add((Component)new JLabel(action.isEnabled() ? icon : GuiHelper.getDisabledIcon((ImageIcon)icon)), gbc);
                String color = action.isEnabled() ? "" : "; color:gray";
                JLabel tagLabel = new JLabel("<html><style>td{border:1px solid gray; font-weight:normal" + color + "}</style><table><tr><td>" + XmlWriter.encode((String)t.toString(), (boolean)true) + "</td></tr></table></html>");
                if (action.isEnabled()) {
                    mainPanel.getInputMap(2).put(sc.getKeyStroke(), scKey);
                    mainPanel.getActionMap().put(scKey, (Action)action);
                    mainPanel.getInputMap(2).put(scs.getKeyStroke(), scsKey);
                    mainPanel.getActionMap().put(scsKey, (Action)actionShift);
                    tagLabel.setToolTipText((String)action.getValue("ShortDescription"));
                    tagLabel.setCursor(Cursor.getPredefinedCursor(12));
                    tagLabel.addMouseListener(new MouseAdapter(){

                        @Override
                        public void mouseClicked(MouseEvent e) {
                            action.actionPerformed(null);
                            if (e.getClickCount() > 1) {
                                AddTagsDialog.this.buttonAction(0, null);
                            }
                            if (e.isShiftDown()) {
                                AddTagsDialog.this.performTagAdding();
                            }
                        }
                    });
                } else {
                    tagLabel.setEnabled(false);
                    tagLabel.setToolTipText(I18n.tr((String)"The key ''{0}'' is already used", (Object[])new Object[]{t.getKey()}));
                }
                JPanel tagPanel = new JPanel(new FlowLayout(0, 0, 0));
                tagPanel.add(tagLabel);
                mainPanel.add((Component)tagPanel, GBC.eol().fill(2));
            }
        }

        public void destroyActions() {
            for (JosmAction action : this.recentTagsActions) {
                action.destroy();
            }
        }

        public final void performTagAdding() {
            String key = Utils.removeWhiteSpaces((String)this.keys.getEditor().getItem().toString());
            String value = Utils.removeWhiteSpaces((String)this.values.getEditor().getItem().toString());
            if (key.isEmpty() || value.isEmpty()) {
                return;
            }
            for (OsmPrimitive osm : OSMRecPluginHelper.this.sel) {
                String val = osm.get(key);
                if (val == null || val.equals(value)) continue;
                if (OSMRecPluginHelper.this.warnOverwriteKey(I18n.tr((String)"You changed the value of ''{0}'' from ''{1}'' to ''{2}''.", (Object[])new Object[]{key, val, value}), "overwriteAddKey")) break;
                return;
            }
            OSMRecPluginHelper.this.lastAddKey = key;
            OSMRecPluginHelper.this.lastAddValue = value;
            OSMRecPluginHelper.this.recentTags.put(new Tag(key, value), null);
            AutoCompletionManager.rememberUserInput((String)key, (String)value, (boolean)false);
            ++this.commandCount;
            UndoRedoHandler.getInstance().add((Command)new ChangePropertyCommand(OSMRecPluginHelper.this.sel, key, value));
            OSMRecPluginHelper.this.changedKey = key;
        }

        public void undoAllTagsAdding() {
            UndoRedoHandler.getInstance().undo(this.commandCount);
        }

        private void disableTagIfNeeded(Tag t, JosmAction action) {
            for (int j = 0; j < OSMRecPluginHelper.this.tagData.getRowCount(); ++j) {
                if (!t.getKey().equals(OSMRecPluginHelper.this.tagData.getValueAt(j, 0))) continue;
                action.setEnabled(false);
                break;
            }
        }

        private void loadSVMmodel() {
            File modelDirectory = new File(MODEL_PATH);
            if (OSMRecPluginHelper.this.useCombinedModel) {
                if (OSMRecPluginHelper.this.filesAndWeights.isEmpty()) {
                    System.out.println("No models selected! Loading defaults..");
                    if (OSMRecPluginHelper.this.modelWithClasses) {
                        System.out.println("Using default/last model with classes: " + modelDirectory.getAbsolutePath() + "/model_with_classes");
                        File modelFile = new File(modelDirectory.getAbsolutePath() + "/model_with_classes");
                        try {
                            System.out.println("try to load model: " + modelFile.getAbsolutePath());
                            this.modelSVM = Model.load(modelFile);
                            System.out.println("model loaded!");
                        }
                        catch (IOException ex) {
                            Logger.getLogger(TrainWorker.class.getName()).log(Level.SEVERE, null, ex);
                        }
                        this.modelSVMLabelSize = this.modelSVM.getLabels().length;
                        this.modelSVMLabels = this.modelSVM.getLabels();
                    } else {
                        System.out.println("Using default/last model without classes: " + modelDirectory.getAbsolutePath() + "/best_model");
                        File modelFile = new File(modelDirectory.getAbsolutePath() + "/best_model");
                        try {
                            System.out.println("try to load model: " + modelFile.getAbsolutePath());
                            this.modelSVM = Model.load(modelFile);
                            System.out.println("model loaded!");
                        }
                        catch (IOException ex) {
                            Logger.getLogger(TrainWorker.class.getName()).log(Level.SEVERE, null, ex);
                        }
                        this.modelSVMLabelSize = this.modelSVM.getLabels().length;
                        this.modelSVMLabels = this.modelSVM.getLabels();
                    }
                }
                if (OSMRecPluginHelper.this.modelWithClasses) {
                    System.out.println("Using combined model with classes");
                    this.useCombinedSVMmodels(OSMRecPluginHelper.this.sel, true);
                } else {
                    System.out.println("Using combined model without classes");
                    this.useCombinedSVMmodels(OSMRecPluginHelper.this.sel, false);
                }
            } else if (OSMRecPluginHelper.this.useCustomSVMModel) {
                System.out.println("custom path: " + OSMRecPluginHelper.this.customSVMModelPath);
                File checkExistance = new File(OSMRecPluginHelper.this.customSVMModelPath);
                if (checkExistance.exists() && checkExistance.isFile()) {
                    File modelFile;
                    if (OSMRecPluginHelper.this.modelWithClasses) {
                        System.out.println("Using custom model with classes: ");
                        if (OSMRecPluginHelper.this.customSVMModelPath.endsWith(".0")) {
                            String customSVMModelPathWithClasses = OSMRecPluginHelper.this.customSVMModelPath.substring(0, OSMRecPluginHelper.this.customSVMModelPath.length() - 2) + ".1";
                            modelFile = new File(customSVMModelPathWithClasses);
                            System.out.println(customSVMModelPathWithClasses);
                        } else {
                            modelFile = new File(OSMRecPluginHelper.this.customSVMModelPath);
                        }
                    } else {
                        System.out.println("Using custom model without classes");
                        if (OSMRecPluginHelper.this.customSVMModelPath.endsWith(".1")) {
                            String customSVMModelPathWithoutClasses = OSMRecPluginHelper.this.customSVMModelPath.substring(0, OSMRecPluginHelper.this.customSVMModelPath.length() - 2) + ".0";
                            modelFile = new File(customSVMModelPathWithoutClasses);
                            System.out.println(customSVMModelPathWithoutClasses);
                        } else {
                            modelFile = new File(OSMRecPluginHelper.this.customSVMModelPath);
                        }
                    }
                    try {
                        System.out.println("try to load model: " + modelFile.getAbsolutePath());
                        this.modelSVM = Model.load(modelFile);
                        System.out.println("model loaded!");
                    }
                    catch (IOException ex) {
                        Logger.getLogger(TrainWorker.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    this.modelSVMLabelSize = this.modelSVM.getLabels().length;
                    this.modelSVMLabels = this.modelSVM.getLabels();
                } else {
                    File modelFile;
                    if (OSMRecPluginHelper.this.modelWithClasses) {
                        System.out.println("Using default/last model with classes");
                        modelFile = new File(modelDirectory.getAbsolutePath() + "/model_with_classes");
                    } else {
                        System.out.println("Using default/last model without classes");
                        modelFile = new File(modelDirectory.getAbsolutePath() + "/best_model");
                    }
                    try {
                        System.out.println("try to load model: " + modelFile.getAbsolutePath());
                        this.modelSVM = Model.load(modelFile);
                        System.out.println("model loaded!");
                    }
                    catch (IOException ex) {
                        Logger.getLogger(TrainWorker.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    this.modelSVMLabelSize = this.modelSVM.getLabels().length;
                    this.modelSVMLabels = this.modelSVM.getLabels();
                }
            } else {
                File modelFile;
                if (OSMRecPluginHelper.this.modelWithClasses) {
                    System.out.println("Using default/last model with classes");
                    modelFile = new File(modelDirectory.getAbsolutePath() + "/model_with_classes");
                } else {
                    System.out.println("Using default/last model without classes");
                    modelFile = new File(modelDirectory.getAbsolutePath() + "/best_model");
                }
                try {
                    System.out.println("try to load model: " + modelFile.getAbsolutePath());
                    this.modelSVM = Model.load(modelFile);
                    System.out.println("model loaded!");
                }
                catch (IOException ex) {
                    Logger.getLogger(TrainWorker.class.getName()).log(Level.SEVERE, null, ex);
                }
                this.modelSVMLabelSize = this.modelSVM.getLabels().length;
                this.modelSVMLabels = this.modelSVM.getLabels();
            }
        }

        private void useCombinedSVMmodels(Collection<OsmPrimitive> sel, boolean useClassFeatures) {
            Object sourceCoordinate;
            System.out.println("The system will combine " + OSMRecPluginHelper.this.filesAndWeights.size() + " SVM models.");
            MathTransform transform = null;
            GeometryFactory geometryFactory = new GeometryFactory();
            DefaultGeographicCRS sourceCRS = DefaultGeographicCRS.WGS84;
            DefaultGeocentricCRS targetCRS = DefaultGeocentricCRS.CARTESIAN;
            try {
                transform = CRS.findMathTransform((CoordinateReferenceSystem)sourceCRS, (CoordinateReferenceSystem)targetCRS, (boolean)true);
            }
            catch (FactoryException ex) {
                Logger.getLogger(OSMRecPluginHelper.class.getName()).log(Level.SEVERE, null, ex);
            }
            ArrayList<OsmPrimitive> osmPrimitiveSelection = new ArrayList<OsmPrimitive>(sel);
            if (osmPrimitiveSelection.isEmpty()) {
                return;
            }
            OsmPrimitive s = (OsmPrimitive)osmPrimitiveSelection.get(0);
            OSMWay selectedInstance = new OSMWay();
            for (Way selectedWay : s.getDataSet().getSelectedWays()) {
                List selectedWayNodes = selectedWay.getNodes();
                for (Node node : selectedWayNodes) {
                    node.getCoor();
                    if (!node.isLatLonKnown()) continue;
                    double lat = node.getCoor().lat();
                    double lon = node.getCoor().lon();
                    sourceCoordinate = new Coordinate(lon, lat);
                    Coordinate targetGeometry = null;
                    try {
                        targetGeometry = JTS.transform((Coordinate)sourceCoordinate, null, (MathTransform)transform);
                    }
                    catch (MismatchedDimensionException | TransformException ex) {
                        Logger.getLogger(OSMParser.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    Point geom = geometryFactory.createPoint(new Coordinate(targetGeometry));
                    selectedInstance.addNodeGeometry((Geometry)geom);
                }
            }
            Geometry fullGeom = geometryFactory.buildGeometry(selectedInstance.getNodeGeometries());
            if (selectedInstance.getNodeGeometries().size() > 3 && selectedInstance.getNodeGeometries().get(0).equals(selectedInstance.getNodeGeometries().get(selectedInstance.getNodeGeometries().size() - 1))) {
                LinearRing linear = geometryFactory.createLinearRing(fullGeom.getCoordinates());
                Polygon poly = new Polygon(linear, null, geometryFactory);
                selectedInstance.setGeometry((Geometry)poly);
                System.out.println("\n\npolygon");
            } else if (selectedInstance.getNodeGeometries().size() > 1) {
                System.out.println("\n\nlinestring");
                LineString lineString = geometryFactory.createLineString(fullGeom.getCoordinates());
                selectedInstance.setGeometry((Geometry)lineString);
            } else {
                System.out.println("\n\npoint");
                Point point = geometryFactory.createPoint(fullGeom.getCoordinate());
                selectedInstance.setGeometry((Geometry)point);
            }
            Map selectedTags = s.getInterestingTags();
            selectedInstance.setAllTags(selectedTags);
            if (selectedInstance != null) {
                int id;
                OSMClassification classifier = new OSMClassification();
                classifier.calculateClasses(selectedInstance, this.mappings, this.mapperWithIDs, indirectClasses, indirectClassesWithIDs);
                if (useClassFeatures) {
                    ClassFeatures classFeatures = new ClassFeatures();
                    classFeatures.createClassFeatures(selectedInstance, this.mappings, this.mapperWithIDs, indirectClasses, indirectClassesWithIDs);
                    id = 1422;
                } else {
                    id = 1;
                }
                GeometryFeatures geometryFeatures = new GeometryFeatures(id);
                geometryFeatures.createGeometryFeatures(selectedInstance);
                id = geometryFeatures.getLastID();
                TextualFeatures textualFeatures = new TextualFeatures(id, this.textualList, languageDetector);
                textualFeatures.createTextualFeatures(selectedInstance);
                List<FeatureNode> featureNodeList = selectedInstance.getFeatureNodeList();
                Feature[] featureNodeArray = new FeatureNode[featureNodeList.size()];
                int i = 0;
                sourceCoordinate = featureNodeList.iterator();
                while (sourceCoordinate.hasNext()) {
                    FeatureNode featureNode;
                    featureNodeArray[i] = featureNode = (FeatureNode)sourceCoordinate.next();
                    ++i;
                }
                Feature[] testInstance2 = featureNodeArray;
                int[] ranks = new int[10];
                for (int l = 0; l < 10; ++l) {
                    ranks[l] = 10 - l;
                }
                HashMap<Object, Double> scoreMap = new HashMap<Object, Double>();
                Map<File, Double> alignedFilesAndWeights = this.getAlignedModels(OSMRecPluginHelper.this.filesAndWeights);
                for (File modelFile : alignedFilesAndWeights.keySet()) {
                    try {
                        this.modelSVM = Model.load(modelFile);
                    }
                    catch (IOException ex) {
                        Logger.getLogger(TrainWorker.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    this.modelSVMLabelSize = this.modelSVM.getLabels().length;
                    this.modelSVMLabels = this.modelSVM.getLabels();
                    HashMap<Integer, Integer> mapLabelsToIDs = new HashMap<Integer, Integer>();
                    for (int h = 0; h < this.modelSVMLabelSize; ++h) {
                        mapLabelsToIDs.put(this.modelSVMLabels[h], h);
                    }
                    double[] scores = new double[this.modelSVMLabelSize];
                    Linear.predictValues(this.modelSVM, testInstance2, scores);
                    HashMap<Double, Integer> scoresValues = new HashMap<Double, Integer>();
                    for (int h = 0; h < scores.length; ++h) {
                        scoresValues.put(scores[h], h);
                    }
                    Arrays.sort(scores);
                    int predicted1 = this.modelSVMLabels[(Integer)scoresValues.get(scores[scores.length - 1])];
                    int predicted2 = this.modelSVMLabels[(Integer)scoresValues.get(scores[scores.length - 2])];
                    int predicted3 = this.modelSVMLabels[(Integer)scoresValues.get(scores[scores.length - 3])];
                    int predicted4 = this.modelSVMLabels[(Integer)scoresValues.get(scores[scores.length - 4])];
                    int predicted5 = this.modelSVMLabels[(Integer)scoresValues.get(scores[scores.length - 5])];
                    int predicted6 = this.modelSVMLabels[(Integer)scoresValues.get(scores[scores.length - 6])];
                    int predicted7 = this.modelSVMLabels[(Integer)scoresValues.get(scores[scores.length - 7])];
                    int predicted8 = this.modelSVMLabels[(Integer)scoresValues.get(scores[scores.length - 8])];
                    int predicted9 = this.modelSVMLabels[(Integer)scoresValues.get(scores[scores.length - 9])];
                    int predicted10 = this.modelSVMLabels[(Integer)scoresValues.get(scores[scores.length - 10])];
                    Object[] predictedTags = new String[10];
                    for (Map.Entry<String, Integer> entry : this.mapperWithIDs.entrySet()) {
                        if (entry.getValue().equals(predicted1)) {
                            predictedTags[0] = entry.getKey();
                            continue;
                        }
                        if (entry.getValue().equals(predicted2)) {
                            predictedTags[1] = entry.getKey();
                            continue;
                        }
                        if (entry.getValue().equals(predicted3)) {
                            predictedTags[2] = entry.getKey();
                            continue;
                        }
                        if (entry.getValue().equals(predicted4)) {
                            predictedTags[3] = entry.getKey();
                            continue;
                        }
                        if (entry.getValue().equals(predicted5)) {
                            predictedTags[4] = entry.getKey();
                            continue;
                        }
                        if (entry.getValue().equals(predicted6)) {
                            predictedTags[5] = entry.getKey();
                            continue;
                        }
                        if (entry.getValue().equals(predicted7)) {
                            predictedTags[6] = entry.getKey();
                            continue;
                        }
                        if (entry.getValue().equals(predicted8)) {
                            predictedTags[7] = entry.getKey();
                            continue;
                        }
                        if (entry.getValue().equals(predicted9)) {
                            predictedTags[8] = entry.getKey();
                            continue;
                        }
                        if (!entry.getValue().equals(predicted10)) continue;
                        predictedTags[9] = entry.getKey();
                    }
                    this.model.clear();
                    for (Map.Entry<String, Object> entry : this.mappings.entrySet()) {
                        for (int k = 0; k < 10; ++k) {
                            if (!((String)entry.getValue()).equals(predictedTags[k])) continue;
                            predictedTags[k] = entry.getKey();
                            this.model.addElement(entry.getKey());
                        }
                    }
                    System.out.println("combined, predicted classes: " + Arrays.toString(predictedTags));
                    for (int r = 0; r < ranks.length; ++r) {
                        Object object = predictedTags[r];
                        Double currentWeight = alignedFilesAndWeights.get(modelFile);
                        double finalRank = (double)ranks[r] * currentWeight;
                        if (scoreMap.containsKey(object)) {
                            Double scoreToAdd = (Double)scoreMap.get(object);
                            scoreMap.put(object, finalRank + scoreToAdd);
                            continue;
                        }
                        scoreMap.put(object, finalRank);
                    }
                }
                this.model.clear();
                ArrayList scoresList = new ArrayList(scoreMap.values());
                Collections.sort(scoresList, Collections.reverseOrder());
                for (Double sco : scoresList) {
                    if (this.model.size() > 9) break;
                    for (Map.Entry scoreEntry : scoreMap.entrySet()) {
                        if (!((Double)scoreEntry.getValue()).equals(sco)) continue;
                        this.model.addElement((String)scoreEntry.getKey());
                    }
                }
            }
        }

        private void createOSMObject(Collection<OsmPrimitive> sel) {
            Object sourceCoordinate;
            MathTransform transform = null;
            GeometryFactory geometryFactory = new GeometryFactory();
            DefaultGeographicCRS sourceCRS = DefaultGeographicCRS.WGS84;
            DefaultGeocentricCRS targetCRS = DefaultGeocentricCRS.CARTESIAN;
            try {
                transform = CRS.findMathTransform((CoordinateReferenceSystem)sourceCRS, (CoordinateReferenceSystem)targetCRS, (boolean)true);
            }
            catch (FactoryException ex) {
                Logger.getLogger(OSMRecPluginHelper.class.getName()).log(Level.SEVERE, null, ex);
            }
            ArrayList<OsmPrimitive> osmPrimitiveSelection = new ArrayList<OsmPrimitive>(sel);
            if (osmPrimitiveSelection.isEmpty()) {
                return;
            }
            OsmPrimitive s = (OsmPrimitive)osmPrimitiveSelection.get(0);
            OSMWay selectedInstance = new OSMWay();
            for (Way selectedWay : s.getDataSet().getSelectedWays()) {
                List selectedWayNodes = selectedWay.getNodes();
                for (Node node : selectedWayNodes) {
                    node.getCoor();
                    if (!node.isLatLonKnown()) continue;
                    double lat = node.getCoor().lat();
                    double lon = node.getCoor().lon();
                    sourceCoordinate = new Coordinate(lon, lat);
                    Coordinate targetGeometry = null;
                    try {
                        targetGeometry = JTS.transform((Coordinate)sourceCoordinate, null, (MathTransform)transform);
                    }
                    catch (MismatchedDimensionException | TransformException ex) {
                        Logger.getLogger(OSMParser.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    Point geom = geometryFactory.createPoint(new Coordinate(targetGeometry));
                    selectedInstance.addNodeGeometry((Geometry)geom);
                }
            }
            Geometry fullGeom = geometryFactory.buildGeometry(selectedInstance.getNodeGeometries());
            System.out.println("number of nodes: " + selectedInstance.getNodeGeometries().size());
            if (selectedInstance.getNodeGeometries().size() > 3 && selectedInstance.getNodeGeometries().get(0).equals(selectedInstance.getNodeGeometries().get(selectedInstance.getNodeGeometries().size() - 1))) {
                LinearRing linear = geometryFactory.createLinearRing(fullGeom.getCoordinates());
                Polygon poly = new Polygon(linear, null, geometryFactory);
                selectedInstance.setGeometry((Geometry)poly);
                System.out.println("\n\npolygon");
            } else if (selectedInstance.getNodeGeometries().size() > 1) {
                System.out.println("\n\nlinestring");
                LineString lineString = geometryFactory.createLineString(fullGeom.getCoordinates());
                selectedInstance.setGeometry((Geometry)lineString);
            } else {
                System.out.println("\n\npoint");
                Point point = geometryFactory.createPoint(fullGeom.getCoordinate());
                selectedInstance.setGeometry((Geometry)point);
            }
            Map selectedTags = s.getInterestingTags();
            selectedInstance.setAllTags(selectedTags);
            if (selectedInstance != null) {
                int id;
                if (this.mappings == null) {
                    System.out.println("null mappings ERROR");
                }
                OSMClassification classifier = new OSMClassification();
                classifier.calculateClasses(selectedInstance, this.mappings, this.mapperWithIDs, indirectClasses, indirectClassesWithIDs);
                if (OSMRecPluginHelper.this.modelWithClasses) {
                    ClassFeatures classFeatures = new ClassFeatures();
                    classFeatures.createClassFeatures(selectedInstance, this.mappings, this.mapperWithIDs, indirectClasses, indirectClassesWithIDs);
                    id = 1422;
                } else {
                    id = 1;
                }
                GeometryFeatures geometryFeatures = new GeometryFeatures(id);
                geometryFeatures.createGeometryFeatures(selectedInstance);
                id = geometryFeatures.getLastID();
                TextualFeatures textualFeatures = new TextualFeatures(id, this.textualList, languageDetector);
                textualFeatures.createTextualFeatures(selectedInstance);
                List<FeatureNode> featureNodeList = selectedInstance.getFeatureNodeList();
                System.out.println(featureNodeList);
                Feature[] featureNodeArray = new FeatureNode[featureNodeList.size()];
                int i = 0;
                sourceCoordinate = featureNodeList.iterator();
                while (sourceCoordinate.hasNext()) {
                    FeatureNode featureNode;
                    featureNodeArray[i] = featureNode = (FeatureNode)sourceCoordinate.next();
                    ++i;
                }
                Feature[] testInstance2 = featureNodeArray;
                HashMap<Integer, Integer> mapLabelsToIDs = new HashMap<Integer, Integer>();
                for (int h = 0; h < this.modelSVMLabelSize; ++h) {
                    mapLabelsToIDs.put(this.modelSVMLabels[h], h);
                }
                double[] scores = new double[this.modelSVMLabelSize];
                Linear.predictValues(this.modelSVM, testInstance2, scores);
                HashMap<Double, Integer> scoresValues = new HashMap<Double, Integer>();
                for (int h = 0; h < scores.length; ++h) {
                    scoresValues.put(scores[h], h);
                }
                Arrays.sort(scores);
                int[] preds = new int[10];
                for (int p = 0; p < 10; ++p) {
                    preds[p] = this.modelSVMLabels[(Integer)scoresValues.get(scores[scores.length - (p + 1)])];
                }
                Object[] predictedTags2 = new String[10];
                for (int p = 0; p < 10; ++p) {
                    if (!this.idsWithMappings.containsKey(preds[p])) continue;
                    predictedTags2[p] = this.idsWithMappings.get(preds[p]);
                }
                this.model.clear();
                for (Map.Entry<String, String> tag : this.mappings.entrySet()) {
                    for (int k = 0; k < 10; ++k) {
                        if (!tag.getValue().equals(predictedTags2[k])) continue;
                        predictedTags2[k] = tag.getKey();
                        this.model.addElement(tag.getKey());
                    }
                }
                System.out.println("Optimized - create OSMObject, predicted classes: " + Arrays.toString(predictedTags2));
            }
        }

        private void parseTagsMappedToClasses() {
            InputStream tagsToClassesMapping = TrainWorker.class.getResourceAsStream("/resources/files/Map");
            Mapper mapper = new Mapper();
            try {
                mapper.parseFile(tagsToClassesMapping);
            }
            catch (FileNotFoundException ex) {
                Logger.getLogger(Mapper.class.getName()).log(Level.SEVERE, null, ex);
            }
            this.mappings = mapper.getMappings();
            this.mapperWithIDs = mapper.getMappingsWithIDs();
            this.idsWithMappings = mapper.getIDsWithMappings();
        }

        private void loadTextualList(File textualListFile) {
            Scanner input = null;
            try {
                input = new Scanner(textualListFile, "UTF-8");
            }
            catch (FileNotFoundException ex) {
                Logging.warn((Throwable)ex);
            }
            while (input.hasNext()) {
                String nextLine = input.nextLine();
                this.textualList.add(nextLine);
            }
            System.out.println("Textual List parsed from file successfully." + this.textualList);
        }

        private void loadDefaultTextualList() {
            InputStream textualListStream = TrainWorker.class.getResourceAsStream("/resources/files/textualList.txt");
            TextualStatistics textualStatistics = new TextualStatistics();
            textualStatistics.parseTextualList(textualListStream);
            this.textualList = textualStatistics.getTextualList();
            System.out.println("Default Textual List parsed from file successfully." + this.textualList);
        }

        private void loadOntology() {
            InputStream ontologyStream = TrainWorker.class.getResourceAsStream("/resources/files/owl.xml");
            Ontology ontology = new Ontology(ontologyStream);
            indirectClasses = ontology.getIndirectClasses();
            indirectClassesWithIDs = ontology.getIndirectClassesIDs();
        }

        private Map<File, Double> getAlignedModels(Map<File, Double> filesAndWeights) {
            HashMap<File, Double> alignedFilesAndWeights = new HashMap<File, Double>();
            if (OSMRecPluginHelper.this.modelWithClasses) {
                for (Map.Entry<File, Double> entry : filesAndWeights.entrySet()) {
                    String absolutePath = entry.getKey().getAbsolutePath();
                    if (absolutePath.endsWith(".0")) {
                        String newPath = absolutePath.substring(0, absolutePath.length() - 2) + ".1";
                        File alignedFile = new File(newPath);
                        if (!alignedFile.exists()) continue;
                        alignedFilesAndWeights.put(alignedFile, entry.getValue());
                        continue;
                    }
                    alignedFilesAndWeights.put(entry.getKey(), entry.getValue());
                }
            } else {
                for (Map.Entry<File, Double> entry : filesAndWeights.entrySet()) {
                    String absolutePath = entry.getKey().getAbsolutePath();
                    if (absolutePath.endsWith(".1")) {
                        String newPath = absolutePath.substring(0, absolutePath.length() - 2) + ".0";
                        File alignedFile = new File(newPath);
                        if (!alignedFile.exists()) continue;
                        alignedFilesAndWeights.put(alignedFile, entry.getValue());
                        continue;
                    }
                    alignedFilesAndWeights.put(entry.getKey(), entry.getValue());
                }
            }
            return alignedFilesAndWeights;
        }
    }

    class ModelSettingsDialog
    extends JPanel {
        private final JLabel chooseModelLabel;
        private final JButton chooseModelButton;
        private final JTextField chooseModelTextField;
        private final DefaultListModel<String> combinationDefaultListModel = new DefaultListModel();
        private final JList<String> modelCombinationList = new JList<String>(this.combinationDefaultListModel);
        private final JPanel modelCombinationPanel;
        private final JPanel weightsPanel;
        private final JCheckBox useModelCombinationCheckbox;
        private final JButton acceptWeightsButton;
        private final JButton resetWeightsButton;
        private final JButton removeSelectedModelButton;
        private Map<JTextField, String> weightFieldsAndPaths = new HashMap<JTextField, String>();
        private final Map<String, Double> normalizedPathsAndWeights = new HashMap<String, Double>();
        private final JOptionPane pane;
        private final JDialog dlg;
        private final JPanel mainPanel;
        private final JPanel singleSelectionPanel;
        private final JPanel setResetWeightsPanel;
        private final JScrollPane combinationScrollPane;
        private final JScrollPane singleSelectionScrollPane;
        private final TitledBorder modelTitle;
        private final TitledBorder weightTitle;
        private final TitledBorder combineTitle;
        private final Dimension singleSelectionDimension;
        private final Dimension modelCombinationDimension;
        private final Dimension mainPanelDimension;

        ModelSettingsDialog(Collection<OsmPrimitive> sel1, final AddTagsDialog addDialog) {
            this.loadPreviousCombinedSVMModel();
            this.singleSelectionDimension = new Dimension(470, 70);
            this.modelCombinationDimension = new Dimension(450, 250);
            this.mainPanelDimension = new Dimension(600, 350);
            this.mainPanel = new JPanel(new BorderLayout(10, 10));
            this.singleSelectionPanel = new JPanel(new BorderLayout(10, 10));
            this.setResetWeightsPanel = new JPanel();
            this.chooseModelLabel = new JLabel("Choose a Model:");
            this.chooseModelTextField = new JTextField();
            this.chooseModelButton = new JButton("...");
            this.chooseModelTextField.setText(MODEL_PATH);
            this.singleSelectionPanel.add((Component)this.chooseModelLabel, "North");
            this.singleSelectionPanel.add((Component)this.chooseModelTextField, "West");
            this.singleSelectionPanel.add((Component)this.chooseModelButton, "East");
            this.singleSelectionScrollPane = new JScrollPane(this.singleSelectionPanel);
            this.singleSelectionScrollPane.setVerticalScrollBarPolicy(20);
            this.singleSelectionScrollPane.setPreferredSize(this.singleSelectionDimension);
            this.modelCombinationList.setFixedCellHeight(20);
            this.modelCombinationList.setEnabled(false);
            this.modelCombinationPanel = new JPanel(new BorderLayout(10, 10));
            this.weightsPanel = new JPanel();
            this.weightsPanel.setLayout(new BoxLayout(this.weightsPanel, 1));
            this.weightsPanel.setEnabled(false);
            this.acceptWeightsButton = new JButton("Set Weights/Normalize");
            this.resetWeightsButton = new JButton("Reset Weights");
            this.removeSelectedModelButton = new JButton("Remove Selected");
            this.setResetWeightsPanel.add(this.acceptWeightsButton);
            this.setResetWeightsPanel.add(this.resetWeightsButton);
            this.setResetWeightsPanel.add(this.removeSelectedModelButton);
            this.removeSelectedModelButton.setEnabled(false);
            this.acceptWeightsButton.setEnabled(false);
            this.resetWeightsButton.setEnabled(false);
            this.modelCombinationPanel.add(this.modelCombinationList, "Center");
            this.modelCombinationPanel.add((Component)this.weightsPanel, "East");
            this.modelCombinationPanel.add((Component)this.setResetWeightsPanel, "South");
            this.combinationScrollPane = new JScrollPane(this.modelCombinationPanel);
            this.combinationScrollPane.setVerticalScrollBarPolicy(20);
            this.combinationScrollPane.setPreferredSize(this.modelCombinationDimension);
            this.useModelCombinationCheckbox = new JCheckBox("Combine different models?");
            this.modelTitle = BorderFactory.createTitledBorder("Models");
            this.weightTitle = BorderFactory.createTitledBorder("W");
            this.combineTitle = BorderFactory.createTitledBorder("Combine Models");
            this.modelCombinationList.setBorder(this.modelTitle);
            this.weightsPanel.setBorder(this.weightTitle);
            for (Map.Entry<JTextField, String> entry : this.weightFieldsAndPaths.entrySet()) {
                this.combinationDefaultListModel.addElement(entry.getValue());
                JTextField weightTextField = new JTextField("0.00");
                weightTextField.setMaximumSize(new Dimension(80, 20));
                this.weightsPanel.add(entry.getKey());
            }
            this.modelCombinationPanel.setBorder(this.combineTitle);
            this.singleSelectionPanel.setBorder(BorderFactory.createEtchedBorder(1, Color.GRAY, Color.WHITE));
            this.chooseModelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    ModelSettingsDialog.this.modelChooserButtonActionPerformed(evt);
                }
            });
            this.useModelCombinationCheckbox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    ModelSettingsDialog.this.userCombinationCheckboxActionPerformed(evt);
                }
            });
            this.acceptWeightsButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    ModelSettingsDialog.this.acceptWeightsButtonActionPerformed(evt);
                }
            });
            this.resetWeightsButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    ModelSettingsDialog.this.resetWeightsButtonActionPerformed(evt);
                }
            });
            this.removeSelectedModelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    ModelSettingsDialog.this.removeSelectedModelButtonActionPerformed(evt);
                }
            });
            this.mainPanel.add((Component)this.singleSelectionScrollPane, "North");
            this.mainPanel.add((Component)this.combinationScrollPane, "Center");
            this.mainPanel.add((Component)this.useModelCombinationCheckbox, "South");
            this.mainPanel.setPreferredSize(this.mainPanelDimension);
            this.add(this.mainPanel);
            this.pane = new JOptionPane(this, -1, 2){

                @Override
                public void setValue(Object newValue) {
                    super.setValue(newValue);
                    if (newValue instanceof Integer && (Integer)newValue == 0 && ModelSettingsDialog.this.useModelCombinationCheckbox.isSelected()) {
                        System.out.println("model settings button value: " + newValue);
                        System.out.println("\nUSE COMBINED MODEL\n");
                        OSMRecPluginHelper.this.useCombinedModel = true;
                        OSMRecPluginHelper.this.useCustomSVMModel = false;
                        addDialog.loadSVMmodel();
                        addDialog.createOSMObject(OSMRecPluginHelper.this.sel);
                        ModelSettingsDialog.this.saveCombinedModel();
                        ModelSettingsDialog.this.dlg.setVisible(false);
                    } else if (newValue instanceof Integer && (Integer)newValue == -1 && ModelSettingsDialog.this.useModelCombinationCheckbox.isSelected()) {
                        System.out.println("model settings button value: " + newValue);
                        OSMRecPluginHelper.this.useCombinedModel = false;
                        OSMRecPluginHelper.this.useCustomSVMModel = false;
                        System.out.println("Use combined model");
                        addDialog.loadSVMmodel();
                        addDialog.createOSMObject(OSMRecPluginHelper.this.sel);
                        ModelSettingsDialog.this.dlg.setVisible(false);
                    } else if (newValue instanceof Integer && (Integer)newValue == 0 && !ModelSettingsDialog.this.useModelCombinationCheckbox.isSelected()) {
                        System.out.println("model settings button value: " + newValue);
                        System.out.println("Don t use combined model, use custom model");
                        OSMRecPluginHelper.this.useCombinedModel = false;
                        OSMRecPluginHelper.this.useCustomSVMModel = true;
                        addDialog.loadSVMmodel();
                        addDialog.createOSMObject(OSMRecPluginHelper.this.sel);
                        ModelSettingsDialog.this.dlg.setVisible(false);
                    } else if (newValue instanceof Integer && (Integer)newValue == -1 && !ModelSettingsDialog.this.useModelCombinationCheckbox.isSelected()) {
                        System.out.println("model settings button value: " + newValue);
                        System.out.println("Don t use combined model, use custom model");
                        OSMRecPluginHelper.this.useCombinedModel = false;
                        OSMRecPluginHelper.this.useCustomSVMModel = false;
                        addDialog.loadSVMmodel();
                        addDialog.createOSMObject(OSMRecPluginHelper.this.sel);
                        ModelSettingsDialog.this.dlg.setVisible(false);
                    } else if (newValue == null || newValue.equals("uninitializedValue")) {
                        System.out.println("uninitializedValue, do nothing");
                    }
                }
            };
            this.dlg = this.pane.createDialog((Component)MainApplication.getMainFrame(), I18n.tr((String)"Model Settings", (Object[])new Object[0]));
            this.dlg.setVisible(true);
        }

        public void makeVisible(boolean visible) {
            this.dlg.setVisible(true);
        }

        private void modelChooserButtonActionPerformed(ActionEvent evt) {
            try {
                File file = new File(this.chooseModelTextField.getText());
                JFileChooser fileChooser = new JFileChooser(file);
                int returnVal = fileChooser.showOpenDialog(this);
                if (returnVal == 0) {
                    this.chooseModelTextField.setText(fileChooser.getSelectedFile().getAbsolutePath());
                    OSMRecPluginHelper.this.useCustomSVMModel = true;
                    OSMRecPluginHelper.this.customSVMModelPath = fileChooser.getSelectedFile().getAbsolutePath();
                }
                if (this.useModelCombinationCheckbox.isSelected()) {
                    String svmModelPath = fileChooser.getSelectedFile().getAbsolutePath();
                    String svmModelText = System.getProperty("os.name").contains("ux") ? (svmModelPath.contains("/") ? svmModelPath.substring(svmModelPath.lastIndexOf("/")) : svmModelPath) : (svmModelPath.contains("\\") ? svmModelPath.substring(svmModelPath.lastIndexOf("\\")) : svmModelPath);
                    this.combinationDefaultListModel.addElement(svmModelText);
                    JTextField weightTextField = new JTextField("0.00");
                    this.weightFieldsAndPaths.put(weightTextField, svmModelPath);
                    System.out.println("weights size: " + this.weightFieldsAndPaths.size());
                    weightTextField.setMaximumSize(new Dimension(80, 20));
                    this.weightsPanel.add(weightTextField);
                }
            }
            catch (RuntimeException ex) {
                Logging.warn((Throwable)ex);
            }
        }

        private void userCombinationCheckboxActionPerformed(ActionEvent evt) {
            if (this.useModelCombinationCheckbox.isSelected()) {
                Component[] weightPanelComponents;
                OSMRecPluginHelper.this.useCombinedModel = true;
                OSMRecPluginHelper.this.useCustomSVMModel = false;
                this.removeSelectedModelButton.setEnabled(true);
                this.acceptWeightsButton.setEnabled(true);
                this.resetWeightsButton.setEnabled(true);
                this.chooseModelTextField.setEnabled(false);
                this.modelCombinationList.setEnabled(true);
                this.weightsPanel.setEnabled(true);
                for (Component weightPanelComponent : weightPanelComponents = this.weightsPanel.getComponents()) {
                    weightPanelComponent.setEnabled(true);
                }
            } else {
                Component[] weightPanelComponents;
                OSMRecPluginHelper.this.useCombinedModel = false;
                OSMRecPluginHelper.this.useCustomSVMModel = true;
                this.removeSelectedModelButton.setEnabled(false);
                this.acceptWeightsButton.setEnabled(false);
                this.resetWeightsButton.setEnabled(false);
                this.chooseModelTextField.setEnabled(true);
                this.modelCombinationList.setEnabled(false);
                this.weightsPanel.setEnabled(false);
                for (Component weightPanelComponent : weightPanelComponents = this.weightsPanel.getComponents()) {
                    weightPanelComponent.setEnabled(false);
                }
            }
        }

        private void acceptWeightsButtonActionPerformed(ActionEvent evt) {
            Double weightValue;
            int weightsCount = 0;
            this.removeSelectedModelButton.setEnabled(false);
            double weightSum = 0.0;
            for (JTextField weightField : this.weightFieldsAndPaths.keySet()) {
                if (weightField.getText().equals("")) {
                    weightField.setText("0.00");
                }
                try {
                    weightValue = Double.parseDouble(weightField.getText());
                    weightValue = Math.abs(weightValue);
                    weightSum += weightValue.doubleValue();
                }
                catch (NumberFormatException ex) {
                    Logging.warn((Throwable)ex);
                }
                ++weightsCount;
            }
            if (!OSMRecPluginHelper.this.filesAndWeights.isEmpty()) {
                OSMRecPluginHelper.this.filesAndWeights.clear();
            }
            for (JTextField weightField : this.weightFieldsAndPaths.keySet()) {
                try {
                    weightValue = Double.parseDouble(weightField.getText());
                    weightValue = Math.abs(weightValue) / weightSum;
                    if (weightSum == 0.0) {
                        weightValue = 1.0 / (double)weightsCount;
                    }
                    weightField.setText(new DecimalFormat("#.##").format(weightValue));
                    this.normalizedPathsAndWeights.put(this.weightFieldsAndPaths.get(weightField), weightValue);
                    OSMRecPluginHelper.this.filesAndWeights.put(new File(this.weightFieldsAndPaths.get(weightField)), weightValue);
                    System.out.println("normalized: " + this.weightFieldsAndPaths.get(weightField) + "->" + weightValue);
                    weightField.setEnabled(false);
                }
                catch (NumberFormatException ex) {
                    Logging.warn((Throwable)ex);
                }
            }
            OSMRecPluginHelper.this.useCombinedModel = true;
            OSMRecPluginHelper.this.useCustomSVMModel = false;
        }

        private void resetWeightsButtonActionPerformed(ActionEvent evt) {
            this.removeSelectedModelButton.setEnabled(true);
            for (JTextField weightField : this.weightFieldsAndPaths.keySet()) {
                weightField.setEnabled(true);
            }
        }

        private void removeSelectedModelButtonActionPerformed(ActionEvent evt) {
            int index = this.modelCombinationList.getSelectedIndex();
            String modelToBeRemoved = this.combinationDefaultListModel.get(index);
            this.combinationDefaultListModel.remove(index);
            System.out.println("model to be removed: " + modelToBeRemoved);
            Iterator<Map.Entry<JTextField, String>> it = this.weightFieldsAndPaths.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<JTextField, String> en = it.next();
                if (!en.getValue().equals(modelToBeRemoved)) continue;
                it.remove();
            }
            System.out.println("model to be removed: " + modelToBeRemoved);
            this.weightsPanel.remove(index);
            this.weightsPanel.revalidate();
            this.weightsPanel.repaint();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void loadPreviousCombinedSVMModel() {
            File combinedModelClassesFile = new File(OSMRecPluginHelper.this.combinedModelClasses);
            if (combinedModelClassesFile.exists()) {
                FileInputStream fileIn = null;
                ObjectInputStream in = null;
                try {
                    fileIn = new FileInputStream(combinedModelClassesFile);
                    in = new ObjectInputStream(fileIn);
                    this.weightFieldsAndPaths = (Map)in.readObject();
                }
                catch (FileNotFoundException ex) {
                    Logger.getLogger(OSMRecPluginHelper.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (IOException | ClassNotFoundException ex) {
                    Logger.getLogger(OSMRecPluginHelper.class.getName()).log(Level.SEVERE, null, ex);
                }
                finally {
                    try {
                        if (in != null) {
                            in.close();
                        }
                        if (fileIn != null) {
                            fileIn.close();
                        }
                    }
                    catch (IOException ex) {
                        Logger.getLogger(OSMRecPluginHelper.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            } else {
                try {
                    combinedModelClassesFile.createNewFile();
                }
                catch (IOException ex) {
                    Logger.getLogger(OSMRecPluginHelper.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }

        private void saveCombinedModel() {
            try (FileOutputStream fileOut = new FileOutputStream(OSMRecPluginHelper.this.combinedModelClasses);
                 ObjectOutputStream out = new ObjectOutputStream(fileOut);){
                out.writeObject(this.weightFieldsAndPaths);
            }
            catch (IOException e) {
                System.out.println("serialize error" + e);
            }
        }
    }

    static abstract class AbstractTagsDialog
    extends ExtendedDialog {
        AutoCompletingComboBox keys;
        AutoCompletingComboBox values;
        protected JPopupMenu popupMenu = new JPopupMenu(){
            JCheckBoxMenuItem fixTagLanguageCb = new JCheckBoxMenuItem(new AbstractAction(I18n.tr((String)"Use English language for tag by default", (Object[])new Object[0])){

                @Override
                public void actionPerformed(ActionEvent e) {
                    boolean sel = ((JCheckBoxMenuItem)e.getSource()).getState();
                    PROPERTY_FIX_TAG_LOCALE.put(Boolean.valueOf(sel));
                }
            });
            {
                this.add(this.fixTagLanguageCb);
                this.fixTagLanguageCb.setState(PROPERTY_FIX_TAG_LOCALE.get());
            }
        };

        AbstractTagsDialog(Component parent, String title, String[] buttonTexts) {
            super(parent, title, buttonTexts);
            this.addMouseListener((MouseListener)new PopupMenuLauncher(this.popupMenu));
        }

        public void setupDialog() {
            super.setupDialog();
            Dimension size = this.getSize();
            this.setMinimumSize(size);
            this.setPreferredSize(size);
            this.setRememberWindowGeometry(((Object)((Object)this)).getClass().getName() + ".geometry", WindowGeometry.centerInWindow((Component)MainApplication.getMainFrame(), (Dimension)size));
        }

        public void setVisible(boolean visible) {
            if (visible) {
                Dimension size;
                WindowGeometry geometry = this.initWindowGeometry();
                Dimension storedSize = geometry.getSize();
                if (!storedSize.equals(size = this.getSize())) {
                    if (storedSize.width < size.width) {
                        storedSize.width = size.width;
                    }
                    if (storedSize.height != size.height) {
                        storedSize.height = size.height;
                    }
                    this.rememberWindowGeometry(geometry);
                }
                if (this.keys != null) {
                    this.keys.setFixedLocale(PROPERTY_FIX_TAG_LOCALE.get().booleanValue());
                }
            }
            super.setVisible(visible);
        }

        protected FocusAdapter addFocusAdapter(final AutoCompletionManager autocomplete, final Comparator<AutoCompletionItem> comparator) {
            JTextComponent editor = (JTextComponent)this.values.getEditor().getEditorComponent();
            FocusAdapter focus = new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent e) {
                    String key = keys.getEditor().getItem().toString();
                    ArrayList valueList = new ArrayList(autocomplete.getTagValues(OSMRecPluginHelper.getAutocompletionKeys(key)));
                    Collections.sort(valueList, comparator);
                    values.setPossibleAcItems(valueList);
                    values.getEditor().selectAll();
                }
            };
            editor.addFocusListener(focus);
            return focus;
        }
    }

    public final class TrainingDialog
    extends AbstractTagsDialog {
        private static final int FIELD_COLUMNS = 4;
        private final JTextField inputFileField;
        private final JLabel inputFileLabel;
        private final JTextField topKField;
        private final JTextField cParameterField;
        private final JTextField frequencyField;
        private final JButton fileBrowseButton;
        private final JButton acceptConfigButton;
        private JRadioButton frequencyButton;
        private JRadioButton topKButton;
        private JCheckBox cParameterCheckBox;
        private final JButton resetConfigButton;
        private String inputFileValue;
        private Double cParameterValue;
        private Integer topKvalue;
        private Integer frequencyValue;
        private boolean crossValidateFlag;
        private final JButton startTrainingButton;
        private final JLabel cErrorMessageLabel;
        private final JLabel topKErrorMessageLabel;
        private final JLabel inputFileErrorMessageLabel;
        private final JLabel frequencyErrorMessageLabel;
        private final JProgressBar trainingProgressBar;
        private final JRadioButton byAreaRadioButton;
        private final JRadioButton byTimeRadioButton;
        private final JLabel userNameLabel;
        private final JTextField userNameField;
        private final JTextField daysField;
        private final JLabel daysLabel;
        private final JCheckBox trainFromUserCheckBox;
        private final JPanel userHistoryPanel;
        private Integer daysValue;
        private String usernameValue;
        private TrainWorker trainWorker;
        private UserDataExtractAndTrainWorker userDataExtractAndTrainWorker;

        private TrainingDialog(String key, int row, Map<String, Integer> map, boolean initialFocusOnKey) {
            super((Component)MainApplication.getMainFrame(), I18n.tr((String)"Training process configuration", (Object[])new Object[0]), new String[]{I18n.tr((String)"Cancel", (Object[])new Object[0])});
            this.cParameterValue = 0.0;
            this.topKvalue = 0;
            this.frequencyValue = 0;
            this.setButtonIcons(new String[]{"ok", "cancel"});
            this.setCancelButton(new Integer[]{2});
            JPanel mainPanel = new JPanel(new BorderLayout(10, 10));
            JPanel configPanel = new JPanel(new BorderLayout(10, 10));
            JPanel inputPanel = new JPanel(new FlowLayout(0));
            JPanel paramPanel = new JPanel(new FlowLayout(0));
            JPanel southPanel = new JPanel(new FlowLayout(0));
            this.userHistoryPanel = new JPanel();
            this.trainingProgressBar = new JProgressBar(0, 100);
            ButtonGroup paramGroup = new ButtonGroup();
            ButtonGroup userGroup = new ButtonGroup();
            this.inputFileLabel = new JLabel();
            this.inputFileField = new JTextField();
            this.cParameterField = new JTextField();
            this.topKField = new JTextField();
            this.frequencyField = new JTextField();
            this.cParameterCheckBox = new JCheckBox("Define C parameter");
            this.topKButton = new JRadioButton("Top-K terms");
            this.frequencyButton = new JRadioButton("Max-Frequency");
            this.fileBrowseButton = new JButton();
            this.acceptConfigButton = new JButton("Accept Configuration");
            this.resetConfigButton = new JButton("Reset Configuration/Cancel training");
            this.startTrainingButton = new JButton("Train Model");
            this.inputFileErrorMessageLabel = new JLabel("");
            this.cErrorMessageLabel = new JLabel("");
            this.topKErrorMessageLabel = new JLabel("");
            this.frequencyErrorMessageLabel = new JLabel("");
            this.trainFromUserCheckBox = new JCheckBox("Train Model From User");
            this.byAreaRadioButton = new JRadioButton("By Area");
            this.byTimeRadioButton = new JRadioButton("By Time");
            this.userNameLabel = new JLabel("Username:");
            this.userNameField = new JTextField();
            this.daysLabel = new JLabel("Days: ");
            this.daysField = new JTextField();
            this.cParameterCheckBox.setSelected(true);
            this.userHistoryPanel.setEnabled(false);
            this.byAreaRadioButton.setEnabled(false);
            this.byAreaRadioButton.setSelected(true);
            this.byTimeRadioButton.setEnabled(false);
            this.userNameLabel.setEnabled(false);
            this.userNameField.setEnabled(false);
            this.daysLabel.setEnabled(false);
            this.daysField.setEnabled(false);
            this.userNameField.setColumns(4);
            this.daysField.setColumns(4);
            List fileHistory = Config.getPref().getList("file-open.history");
            if (!fileHistory.isEmpty()) {
                this.inputFileField.setText(MAIN_PATH);
            }
            this.fileBrowseButton.setText("...");
            this.inputFileLabel.setText("OSM filepath: ");
            this.inputFileErrorMessageLabel.setForeground(Color.RED);
            this.inputFileErrorMessageLabel.setText("");
            this.topKField.setText("50");
            this.frequencyField.setText("200");
            this.cParameterField.setText("0.01");
            this.cParameterField.setColumns(4);
            this.cParameterField.setEditable(false);
            this.cParameterField.setHorizontalAlignment(4);
            this.cErrorMessageLabel.setForeground(Color.RED);
            this.cErrorMessageLabel.setMinimumSize(new Dimension(150, 10));
            this.topKButton.setSelected(true);
            this.topKField.setColumns(4);
            this.topKField.setHorizontalAlignment(4);
            this.topKErrorMessageLabel.setForeground(Color.RED);
            this.frequencyField.setEditable(false);
            this.frequencyField.setColumns(4);
            this.frequencyField.setHorizontalAlignment(4);
            this.frequencyErrorMessageLabel.setForeground(Color.RED);
            this.fileBrowseButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    TrainingDialog.this.inputFileChooserButtonActionPerformed(evt);
                }
            });
            this.topKButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    if (TrainingDialog.this.topKButton.isSelected()) {
                        TrainingDialog.this.frequencyField.setEditable(false);
                        TrainingDialog.this.topKField.setEditable(true);
                    } else {
                        TrainingDialog.this.frequencyField.setEditable(true);
                        TrainingDialog.this.topKField.setEditable(false);
                    }
                }
            });
            this.frequencyButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    if (TrainingDialog.this.frequencyButton.isSelected()) {
                        TrainingDialog.this.topKField.setEditable(false);
                        TrainingDialog.this.frequencyField.setEditable(true);
                    } else {
                        TrainingDialog.this.topKField.setEditable(true);
                        TrainingDialog.this.frequencyField.setEditable(false);
                    }
                }
            });
            this.cParameterCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    if (TrainingDialog.this.cParameterCheckBox.isSelected()) {
                        TrainingDialog.this.cParameterField.setEditable(true);
                    } else {
                        TrainingDialog.this.cParameterField.setEditable(false);
                    }
                }
            });
            this.acceptConfigButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    TrainingDialog.this.acceptConfigButtonActionPerformed(evt);
                }
            });
            this.resetConfigButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    TrainingDialog.this.resetConfigButtonActionPerformed();
                }
            });
            this.startTrainingButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    if (!TrainingDialog.this.acceptConfigButton.isEnabled()) {
                        TrainingDialog.this.startTraining();
                    } else {
                        System.out.println("Set values first!");
                    }
                }
            });
            this.trainFromUserCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    if (TrainingDialog.this.trainFromUserCheckBox.isSelected()) {
                        TrainingDialog.this.userHistoryPanel.setEnabled(true);
                        TrainingDialog.this.byAreaRadioButton.setEnabled(true);
                        TrainingDialog.this.byTimeRadioButton.setEnabled(true);
                        TrainingDialog.this.userNameLabel.setEnabled(true);
                        TrainingDialog.this.userNameField.setEnabled(true);
                        TrainingDialog.this.daysLabel.setEnabled(true);
                        TrainingDialog.this.daysField.setEnabled(true);
                    } else {
                        TrainingDialog.this.userHistoryPanel.setEnabled(false);
                        TrainingDialog.this.byAreaRadioButton.setEnabled(false);
                        TrainingDialog.this.byTimeRadioButton.setEnabled(false);
                        TrainingDialog.this.userNameLabel.setEnabled(false);
                        TrainingDialog.this.userNameField.setEnabled(false);
                        TrainingDialog.this.daysLabel.setEnabled(false);
                        TrainingDialog.this.daysField.setEnabled(false);
                    }
                }
            });
            this.byAreaRadioButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    if (TrainingDialog.this.byAreaRadioButton.isSelected()) {
                        TrainingDialog.this.daysField.setEditable(false);
                    } else {
                        TrainingDialog.this.daysField.setEditable(true);
                    }
                }
            });
            this.byTimeRadioButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    if (TrainingDialog.this.byTimeRadioButton.isSelected()) {
                        TrainingDialog.this.daysField.setEditable(true);
                    } else {
                        TrainingDialog.this.daysField.setEditable(false);
                    }
                }
            });
            this.buildInputPanelGroupLayout(inputPanel);
            this.buildParamPanelGroupLayout(paramPanel);
            inputPanel.add(this.inputFileLabel);
            inputPanel.add(this.inputFileField);
            inputPanel.add(this.fileBrowseButton);
            inputPanel.add(this.inputFileErrorMessageLabel);
            paramGroup.add(this.topKButton);
            paramGroup.add(this.frequencyButton);
            paramPanel.add(this.cParameterCheckBox);
            paramPanel.add(this.cParameterField);
            paramPanel.add(this.cErrorMessageLabel);
            paramPanel.add(this.topKButton);
            paramPanel.add(this.topKField);
            paramPanel.add(this.topKErrorMessageLabel);
            paramPanel.add(this.frequencyButton);
            paramPanel.add(this.frequencyField);
            paramPanel.add(this.frequencyErrorMessageLabel);
            southPanel.add(this.acceptConfigButton);
            southPanel.add(this.resetConfigButton);
            southPanel.add(this.trainFromUserCheckBox);
            userGroup.add(this.byAreaRadioButton);
            userGroup.add(this.byTimeRadioButton);
            this.userHistoryPanel.add(this.byAreaRadioButton);
            this.userHistoryPanel.add(this.byTimeRadioButton);
            this.userHistoryPanel.add(this.daysLabel);
            this.userHistoryPanel.add(this.daysField);
            this.userHistoryPanel.add(this.userNameLabel);
            this.userHistoryPanel.add(this.userNameField);
            this.buildUserHistoryPanelGroupLayout();
            configPanel.add((Component)inputPanel, "North");
            configPanel.add((Component)this.userHistoryPanel, "East");
            configPanel.add((Component)paramPanel, "West");
            configPanel.add((Component)southPanel, "South");
            this.userHistoryPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1, Color.GRAY, Color.WHITE), "Train by user History"));
            paramPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1, Color.GRAY, Color.WHITE), "SVM Configuration"));
            inputPanel.setBorder(BorderFactory.createEtchedBorder(1, Color.GRAY, Color.WHITE));
            configPanel.setBorder(BorderFactory.createEtchedBorder(1, Color.GRAY, Color.WHITE));
            mainPanel.add((Component)configPanel, "North");
            mainPanel.add((Component)this.startTrainingButton, "Center");
            mainPanel.add((Component)this.trainingProgressBar, "South");
            AutoCompletionManager autocomplete = AutoCompletionManager.of((DataSet)MainApplication.getLayerManager().getEditLayer().data);
            ArrayList keyList = new ArrayList(autocomplete.getTagKeys());
            Collections.sort(keyList, OSMRecPluginHelper.this.defaultACItemComparator);
            this.setContent(mainPanel, false);
        }

        private void buildInputPanelGroupLayout(JPanel inputPanel) {
            GroupLayout inputGroupLayout = new GroupLayout(inputPanel);
            inputPanel.setLayout(inputGroupLayout);
            inputGroupLayout.setAutoCreateGaps(true);
            inputGroupLayout.setAutoCreateContainerGaps(true);
            GroupLayout.SequentialGroup inputHorGroup = inputGroupLayout.createSequentialGroup();
            inputHorGroup.addGroup(inputGroupLayout.createParallelGroup().addComponent(this.inputFileLabel).addComponent(this.inputFileErrorMessageLabel));
            inputHorGroup.addGroup(inputGroupLayout.createParallelGroup().addComponent(this.inputFileField));
            inputHorGroup.addGroup(inputGroupLayout.createParallelGroup().addComponent(this.fileBrowseButton));
            inputGroupLayout.setHorizontalGroup(inputHorGroup);
            GroupLayout.SequentialGroup inputVerGroup = inputGroupLayout.createSequentialGroup();
            inputVerGroup.addGroup(inputGroupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.inputFileLabel).addComponent(this.inputFileField).addComponent(this.fileBrowseButton));
            inputVerGroup.addGroup(inputGroupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.inputFileErrorMessageLabel));
            inputGroupLayout.setVerticalGroup(inputVerGroup);
        }

        private void buildParamPanelGroupLayout(JPanel paramPanel) {
            GroupLayout paramGroupLayout = new GroupLayout(paramPanel);
            paramPanel.setLayout(paramGroupLayout);
            paramGroupLayout.setAutoCreateGaps(true);
            paramGroupLayout.setAutoCreateContainerGaps(true);
            GroupLayout.SequentialGroup paramHorGroup = paramGroupLayout.createSequentialGroup();
            paramHorGroup.addGroup(paramGroupLayout.createParallelGroup().addComponent(this.topKButton).addComponent(this.frequencyButton).addComponent(this.cParameterCheckBox));
            paramHorGroup.addGroup(paramGroupLayout.createParallelGroup().addComponent(this.cParameterField).addComponent(this.topKField).addComponent(this.frequencyField));
            paramHorGroup.addGroup(paramGroupLayout.createParallelGroup().addComponent(this.cErrorMessageLabel).addComponent(this.topKErrorMessageLabel).addComponent(this.frequencyErrorMessageLabel));
            paramGroupLayout.setHorizontalGroup(paramHorGroup);
            GroupLayout.SequentialGroup paramVerGroup = paramGroupLayout.createSequentialGroup();
            paramVerGroup.addGroup(paramGroupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cParameterCheckBox).addComponent(this.cParameterField).addComponent(this.cErrorMessageLabel));
            paramVerGroup.addGroup(paramGroupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.topKButton).addComponent(this.topKField).addComponent(this.topKErrorMessageLabel));
            paramVerGroup.addGroup(paramGroupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.frequencyButton).addComponent(this.frequencyField).addComponent(this.frequencyErrorMessageLabel));
            paramGroupLayout.setVerticalGroup(paramVerGroup);
        }

        private void buildUserHistoryPanelGroupLayout() {
            GroupLayout userHistoryGroupLayout = new GroupLayout(this.userHistoryPanel);
            this.userHistoryPanel.setLayout(userHistoryGroupLayout);
            userHistoryGroupLayout.setAutoCreateGaps(true);
            userHistoryGroupLayout.setAutoCreateContainerGaps(true);
            userHistoryGroupLayout.linkSize(0, this.userNameField, this.daysLabel, this.daysField);
            GroupLayout.SequentialGroup userHistoryHorGroup = userHistoryGroupLayout.createSequentialGroup();
            userHistoryHorGroup.addGroup(userHistoryGroupLayout.createParallelGroup().addComponent(this.userNameLabel).addComponent(this.byAreaRadioButton).addComponent(this.byTimeRadioButton));
            userHistoryHorGroup.addGroup(userHistoryGroupLayout.createParallelGroup().addComponent(this.userNameField).addComponent(this.daysLabel));
            userHistoryHorGroup.addGroup(userHistoryGroupLayout.createParallelGroup().addComponent(this.daysField));
            userHistoryGroupLayout.setHorizontalGroup(userHistoryHorGroup);
            GroupLayout.SequentialGroup userHistoryVerGroup = userHistoryGroupLayout.createSequentialGroup();
            userHistoryVerGroup.addGroup(userHistoryGroupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.userNameLabel).addComponent(this.userNameField));
            userHistoryVerGroup.addGroup(userHistoryGroupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.byAreaRadioButton));
            userHistoryVerGroup.addGroup(userHistoryGroupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.byTimeRadioButton).addComponent(this.daysLabel).addComponent(this.daysField));
            userHistoryGroupLayout.setVerticalGroup(userHistoryVerGroup);
        }

        private void inputFileChooserButtonActionPerformed(ActionEvent evt) {
            try {
                File file = new File(this.inputFileField.getText());
                JFileChooser fileChooser = new JFileChooser(file);
                int returnVal = fileChooser.showOpenDialog((Component)((Object)this));
                if (returnVal == 0) {
                    this.inputFileField.setText(fileChooser.getSelectedFile().getAbsolutePath());
                }
            }
            catch (RuntimeException ex) {
                Logging.warn((Throwable)ex);
            }
        }

        private void acceptConfigButtonActionPerformed(ActionEvent evt) {
            this.inputFileValue = this.inputFileField.getText();
            if (!new File(this.inputFileValue).exists()) {
                this.inputFileErrorMessageLabel.setText("OSM file does not exist");
                this.resetConfigButtonActionPerformed();
                return;
            }
            if (this.cParameterCheckBox.isSelected()) {
                String c = this.cParameterField.getText();
                try {
                    this.cParameterValue = Double.parseDouble(c.replace(",", "."));
                    this.cErrorMessageLabel.setText("");
                }
                catch (NumberFormatException ex) {
                    this.cErrorMessageLabel.setText("Must be a number!");
                    System.out.println("c must be a number!" + ex);
                    this.resetConfigButtonActionPerformed();
                    return;
                }
                this.crossValidateFlag = false;
            } else {
                this.crossValidateFlag = true;
            }
            if (this.topKButton.isSelected()) {
                String k = this.topKField.getText();
                try {
                    this.topKvalue = Integer.parseInt(k);
                    this.topKErrorMessageLabel.setText("");
                }
                catch (NumberFormatException ex) {
                    this.topKErrorMessageLabel.setText("Must be an Integer!");
                    this.resetConfigButtonActionPerformed();
                    return;
                }
            }
            String f = this.frequencyField.getText();
            try {
                this.frequencyValue = Integer.parseInt(f);
                this.frequencyErrorMessageLabel.setText("");
            }
            catch (NumberFormatException ex) {
                this.frequencyErrorMessageLabel.setText("Must be an Integer!");
                this.resetConfigButtonActionPerformed();
                return;
            }
            if (this.trainFromUserCheckBox.isSelected()) {
                this.usernameValue = this.userNameField.getText();
                if (this.byTimeRadioButton.isSelected()) {
                    try {
                        this.daysValue = Integer.parseInt(this.daysField.getText());
                    }
                    catch (NumberFormatException ex) {
                        this.daysField.setText("Integer!");
                        Logging.warn((Throwable)ex);
                    }
                }
                this.userHistoryPanel.setEnabled(false);
                this.byAreaRadioButton.setEnabled(false);
                this.byTimeRadioButton.setEnabled(false);
                this.userNameLabel.setEnabled(false);
                this.userNameField.setEnabled(false);
                this.daysLabel.setEnabled(false);
                this.daysField.setEnabled(false);
            }
            System.out.println("Running configuration:\nC parameter: " + this.cParameterValue + " \ntopK: " + this.topKvalue + "\nMax Frequency: " + this.frequencyValue + "\nCross Validate?: " + this.crossValidateFlag);
            this.trainFromUserCheckBox.setEnabled(false);
            this.inputFileField.setEditable(false);
            this.cParameterField.setEditable(false);
            this.topKField.setEditable(false);
            this.frequencyField.setEditable(false);
            this.cParameterCheckBox.setEnabled(false);
            this.topKButton.setEnabled(false);
            this.frequencyButton.setEnabled(false);
            this.acceptConfigButton.setEnabled(false);
            this.fileBrowseButton.setEnabled(false);
        }

        private void resetConfigButtonActionPerformed() {
            if (this.trainWorker != null) {
                try {
                    this.trainWorker.cancel(true);
                }
                catch (CancellationException ex) {
                    this.startTrainingButton.setEnabled(true);
                    System.out.println(ex);
                }
            }
            if (this.userDataExtractAndTrainWorker != null) {
                try {
                    this.userDataExtractAndTrainWorker.cancel(true);
                }
                catch (CancellationException ex) {
                    this.startTrainingButton.setEnabled(true);
                    System.out.println(ex);
                }
            }
            this.inputFileField.setEditable(true);
            this.cParameterField.setEditable(true);
            this.topKField.setEditable(true);
            this.frequencyField.setEditable(true);
            this.cParameterCheckBox.setEnabled(true);
            this.topKButton.setEnabled(true);
            this.frequencyButton.setEnabled(true);
            this.acceptConfigButton.setEnabled(true);
            this.fileBrowseButton.setEnabled(true);
            this.trainFromUserCheckBox.setEnabled(true);
            if (this.trainFromUserCheckBox.isSelected()) {
                this.userHistoryPanel.setEnabled(true);
                this.byAreaRadioButton.setEnabled(true);
                this.byTimeRadioButton.setEnabled(true);
                this.userNameLabel.setEnabled(true);
                this.userNameField.setEnabled(true);
                this.daysLabel.setEnabled(true);
                this.daysField.setEnabled(true);
            }
        }

        private void startTraining() {
            this.startTrainingButton.setEnabled(false);
            if (this.trainFromUserCheckBox.isSelected()) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        TrainingDialog.this.userDataExtractAndTrainWorker = new UserDataExtractAndTrainWorker(TrainingDialog.this.inputFileValue, TrainingDialog.this.usernameValue, TrainingDialog.this.daysValue, TrainingDialog.this.byAreaRadioButton.isSelected(), TrainingDialog.this.crossValidateFlag, TrainingDialog.this.cParameterValue, TrainingDialog.this.topKvalue, TrainingDialog.this.frequencyValue, TrainingDialog.this.topKButton.isSelected(), languageDetector);
                        TrainingDialog.this.userDataExtractAndTrainWorker.addPropertyChangeListener(new PropertyChangeListener(){

                            @Override
                            public void propertyChange(PropertyChangeEvent evt) {
                                if ("progress".equals(evt.getPropertyName())) {
                                    int progress = (Integer)evt.getNewValue();
                                    TrainingDialog.this.trainingProgressBar.setValue(progress);
                                    if (progress == 100) {
                                        TrainingDialog.this.startTrainingButton.setEnabled(true);
                                    }
                                }
                            }
                        });
                        try {
                            System.out.println("executing userDataExtractAndTrainWorker Thread..");
                            TrainingDialog.this.userDataExtractAndTrainWorker.execute();
                        }
                        catch (Exception ex) {
                            Logger.getLogger(OSMRecPluginHelper.class.getName()).log(Level.SEVERE, null, ex);
                        }
                    }
                });
            } else {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        TrainingDialog.this.trainWorker = new TrainWorker(TrainingDialog.this.inputFileValue, TrainingDialog.this.crossValidateFlag, TrainingDialog.this.cParameterValue, TrainingDialog.this.topKvalue, TrainingDialog.this.frequencyValue, TrainingDialog.this.topKButton.isSelected(), languageDetector);
                        TrainingDialog.this.trainWorker.addPropertyChangeListener(new PropertyChangeListener(){

                            @Override
                            public void propertyChange(PropertyChangeEvent evt) {
                                if ("progress".equals(evt.getPropertyName())) {
                                    int progress = (Integer)evt.getNewValue();
                                    TrainingDialog.this.trainingProgressBar.setValue(progress);
                                    if (progress == 100) {
                                        TrainingDialog.this.startTrainingButton.setEnabled(true);
                                    }
                                }
                            }
                        });
                        try {
                            TrainingDialog.this.trainWorker.execute();
                        }
                        catch (Exception ex) {
                            Logger.getLogger(OSMRecPluginHelper.class.getName()).log(Level.SEVERE, null, ex);
                        }
                    }
                });
            }
        }
    }
}

