/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.experimental;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jgrapht.Graph;
import org.jgrapht.Graphs;
import org.jgrapht.ListenableGraph;
import org.jgrapht.event.GraphEdgeChangeEvent;
import org.jgrapht.event.GraphListener;
import org.jgrapht.event.GraphVertexChangeEvent;
import org.jgrapht.graph.AbstractBaseGraph;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphSquare<V, E>
extends AbstractBaseGraph<V, E> {
    private static final long serialVersionUID = -2642034600395594304L;
    private static final String UNMODIFIABLE = "this graph is unmodifiable";

    public GraphSquare(final Graph<V, E> graph, final boolean bl) {
        super(graph.getEdgeFactory(), false, bl);
        Graphs.addAllVertices(this, graph.vertexSet());
        this.addSquareEdges(graph, bl);
        if (graph instanceof ListenableGraph) {
            ((ListenableGraph)graph).addGraphListener(new GraphListener<V, E>(){

                @Override
                public void edgeAdded(GraphEdgeChangeEvent<V, E> graphEdgeChangeEvent) {
                    Object e = graphEdgeChangeEvent.getEdge();
                    GraphSquare.this.addEdgesStartingAt(graph, graph.getEdgeSource(e), graph.getEdgeTarget(e), bl);
                    GraphSquare.this.addEdgesStartingAt(graph, graph.getEdgeTarget(e), graph.getEdgeSource(e), bl);
                }

                @Override
                public void edgeRemoved(GraphEdgeChangeEvent<V, E> graphEdgeChangeEvent) {
                    GraphSquare.super.removeAllEdges(GraphSquare.this.edgeSet());
                    GraphSquare.this.addSquareEdges(graph, bl);
                }

                @Override
                public void vertexAdded(GraphVertexChangeEvent<V> graphVertexChangeEvent) {
                }

                @Override
                public void vertexRemoved(GraphVertexChangeEvent<V> graphVertexChangeEvent) {
                }
            });
        }
    }

    @Override
    public E addEdge(V v, V v2) {
        throw new UnsupportedOperationException(UNMODIFIABLE);
    }

    @Override
    public boolean addEdge(V v, V v2, E e) {
        throw new UnsupportedOperationException(UNMODIFIABLE);
    }

    @Override
    public boolean addVertex(V v) {
        throw new UnsupportedOperationException(UNMODIFIABLE);
    }

    @Override
    public boolean removeAllEdges(Collection<? extends E> collection) {
        throw new UnsupportedOperationException(UNMODIFIABLE);
    }

    @Override
    public Set<E> removeAllEdges(V v, V v2) {
        throw new UnsupportedOperationException(UNMODIFIABLE);
    }

    @Override
    public boolean removeAllVertices(Collection<? extends V> collection) {
        throw new UnsupportedOperationException(UNMODIFIABLE);
    }

    @Override
    public boolean removeEdge(E e) {
        throw new UnsupportedOperationException(UNMODIFIABLE);
    }

    @Override
    public E removeEdge(V v, V v2) {
        throw new UnsupportedOperationException(UNMODIFIABLE);
    }

    @Override
    public boolean removeVertex(V v) {
        throw new UnsupportedOperationException(UNMODIFIABLE);
    }

    private void addEdgesStartingAt(Graph<V, E> graph, V v, V v2, boolean bl) {
        if (!graph.containsEdge(v, v2)) {
            return;
        }
        List<V> list = Graphs.neighborListOf(graph, v2);
        for (int i = 0; i < list.size(); ++i) {
            V v3 = list.get(i);
            if (!graph.containsEdge(v2, v3) || v == v3 && !bl) continue;
            super.addEdge(v, v3);
        }
    }

    private void addSquareEdges(Graph<V, E> graph, boolean bl) {
        for (V v : graph.vertexSet()) {
            List<V> list = Graphs.neighborListOf(graph, v);
            for (int i = 0; i < list.size(); ++i) {
                this.addEdgesStartingAt(graph, v, list.get(i), bl);
            }
        }
    }
}

