/*
 * Decompiled with CFR 0.152.
 */
package org.jaitools.media.jai.contour;

import com.vividsolutions.jts.geom.LineString;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;
import org.jaitools.media.jai.contour.Segment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Segments {
    static final int MAX_SIZE = 16348;
    boolean simplify;
    Segment temp = new Segment();
    TreeSet<Segment> startList = new TreeSet<Segment>(Segment.START_COMPARATOR);
    TreeSet<Segment> endList = new TreeSet<Segment>(Segment.END_COMPARATOR);
    List<LineString> result = new ArrayList<LineString>();

    public Segments(boolean simplify) {
        this.simplify = simplify;
    }

    public void add(double x1, double y1, double x2, double y2) {
        if (Segment.samePoint(x1, y1, x2, y2)) {
            return;
        }
        if (y2 < y1) {
            double tmp = y1;
            y1 = y2;
            y2 = tmp;
            tmp = x1;
            x1 = x2;
            x2 = tmp;
        }
        if (this.appendSegment(x1, y1, x2, y2)) {
            return;
        }
        Segment segment = new Segment(x1, y1, x2, y2, this.simplify);
        this.startList.add(segment);
        this.endList.add(segment);
    }

    private boolean appendSegment(double x1, double y1, double x2, double y2) {
        this.temp.setXY(x1, y1, x1, y1);
        Segment segment = this.search(this.startList, this.temp);
        if (segment != null) {
            this.addToStartList(x2, y2, segment);
            return true;
        }
        segment = this.search(this.endList, this.temp);
        if (segment != null) {
            this.addToEndList(x2, y2, segment);
            return true;
        }
        this.temp.setXY(x2, y2, x2, y2);
        segment = this.search(this.startList, this.temp);
        if (segment != null) {
            this.addToStartList(x1, y1, segment);
            return true;
        }
        segment = this.search(this.endList, this.temp);
        if (segment != null) {
            this.addToEndList(x1, y1, segment);
            return true;
        }
        return false;
    }

    private void addToEndList(double x, double y, Segment segment) {
        this.endList.remove(segment);
        segment.addAfterEnd(x, y);
        this.temp.setXY(x, y, x, y);
        Segment mergeTarget = this.search(this.endList, segment);
        if (mergeTarget == null) {
            this.endList.add(segment);
        } else {
            while (mergeTarget != null) {
                this.startList.remove(segment);
                this.endList.remove(mergeTarget);
                mergeTarget.merge(segment, Segment.MergePoint.END_END);
                mergeTarget.touched = true;
                Segment next = this.search(this.endList, mergeTarget);
                if (next != null) {
                    segment = mergeTarget;
                    mergeTarget = next;
                    continue;
                }
                this.endList.add(mergeTarget);
                mergeTarget = null;
            }
        }
        assert (this.listConsistent()) : "Start: " + this.startList + "\nEnd: " + this.endList;
    }

    private void addToStartList(double x, double y, Segment segment) {
        assert (this.listConsistent()) : "Start: " + this.startList + "\nEnd: " + this.endList;
        this.startList.remove(segment);
        segment.addBeforeStart(x, y);
        this.temp.setXY(x, y, x, y);
        Segment mergeTarget = this.search(this.startList, segment);
        if (mergeTarget == null) {
            this.startList.add(segment);
        } else {
            while (mergeTarget != null) {
                this.endList.remove(segment);
                this.startList.remove(mergeTarget);
                mergeTarget.merge(segment, Segment.MergePoint.START_START);
                mergeTarget.touched = true;
                Segment next = this.search(this.startList, mergeTarget);
                if (next != null) {
                    segment = mergeTarget;
                    mergeTarget = next;
                    continue;
                }
                this.startList.add(mergeTarget);
                mergeTarget = null;
            }
        }
        assert (this.listConsistent()) : "Start: " + this.startList + "\nEnd: " + this.endList;
    }

    boolean sorted(List<Segment> list, Comparator<Segment> comparator) {
        Segment prev = null;
        for (Segment elem : list) {
            if (prev != null && comparator.compare(prev, elem) > 0) {
                return false;
            }
            prev = elem;
        }
        return true;
    }

    public void lineComplete(int line) {
        for (Segment segment : new ArrayList<Segment>(this.startList)) {
            if (segment.touched) {
                segment.touched = false;
                continue;
            }
            this.startList.remove(segment);
            this.endList.remove(segment);
            this.temp.setXY(segment.xStart, segment.yStart, segment.xStart, segment.yStart);
            Segment mergeTarget = null;
            Segment.MergePoint mergePoint = null;
            mergeTarget = this.search(this.endList, this.temp);
            if (mergeTarget != null) {
                mergePoint = Segment.MergePoint.END_START;
            } else {
                mergeTarget = this.search(this.startList, this.temp);
                if (mergeTarget != null) {
                    mergePoint = Segment.MergePoint.START_START;
                } else {
                    this.temp.setXY(segment.xEnd, segment.yEnd, segment.xEnd, segment.yEnd);
                    mergeTarget = this.search(this.startList, this.temp);
                    if (mergeTarget != null) {
                        mergePoint = Segment.MergePoint.START_END;
                    } else {
                        mergeTarget = this.search(this.endList, this.temp);
                        if (mergeTarget != null) {
                            mergePoint = Segment.MergePoint.END_END;
                        }
                    }
                }
            }
            if (mergeTarget != null) {
                this.startList.remove(mergeTarget);
                this.endList.remove(mergeTarget);
                mergeTarget.merge(segment, mergePoint);
                this.startList.add(mergeTarget);
                this.endList.add(mergeTarget);
            } else {
                LineString ls = segment.toLineString();
                this.result.add(ls);
            }
            assert (this.listConsistent()) : "Start: " + this.startList + "\nEnd: " + this.endList;
        }
    }

    private boolean listConsistent() {
        HashSet<Segment> start = new HashSet<Segment>(this.startList);
        HashSet<Segment> end = new HashSet<Segment>(this.endList);
        return start.containsAll(end) && end.containsAll(start);
    }

    Segment search(TreeSet<Segment> list, Segment reference) {
        Segment segment = list.ceiling(reference);
        if (segment == null) {
            return null;
        }
        if (list == this.startList ? Segment.samePoint(segment.xStart, segment.yStart, reference.xStart, reference.yStart) : Segment.samePoint(segment.xEnd, segment.yEnd, reference.xEnd, reference.yEnd)) {
            return segment;
        }
        return null;
    }

    public List<LineString> getMergedSegments() {
        return this.result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Segments(").append(this.startList.size()).append(",").append(this.result.size()).append(") ");
        sb.append("active=");
        for (Segment segment : this.startList) {
            sb.append(segment).append("\n");
        }
        sb.append("complete=");
        for (LineString ls : this.result) {
            sb.append(ls).append("\n");
        }
        return sb.toString();
    }
}

