/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.opendata.core.datasets;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.stream.Collectors;
import org.openstreetmap.josm.actions.SimplifyWayAction;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.command.SplitWayCommand;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.io.Capabilities;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.plugins.opendata.core.datasets.AbstractDataSetHandler;
import org.openstreetmap.josm.spi.preferences.Config;

public abstract class DataSetUpdater {
    public static final void updateDataSet(DataSet dataSet, AbstractDataSetHandler handler, File associatedFile) {
        if (dataSet != null) {
            if (handler != null) {
                if (associatedFile != null) {
                    handler.setAssociatedFile(associatedFile);
                    long lastmodified = associatedFile.lastModified();
                    if (lastmodified > 0L) {
                        handler.setSourceDate(new SimpleDateFormat("yyyy-MM-dd").format(new Date(lastmodified)));
                    }
                }
                if (!Config.getPref().getBoolean("opendata.rawdata")) {
                    handler.updateDataSet(dataSet);
                }
                handler.checkDataSetSource(dataSet);
                handler.checkNames(dataSet);
            }
            for (Way w2 : dataSet.getWays()) {
                SequenceCommand command = SimplifyWayAction.simplifyWay((Way)w2, (double)0.25);
                if (command == null) continue;
                command.executeCommand();
            }
            Capabilities capabilities = OsmApi.getOsmApi().getCapabilities();
            long maxwaynodes = capabilities != null ? capabilities.getMaxWayNodes() : 2000L;
            int max = (int)(0.9 * (double)maxwaynodes);
            for (Way w3 : dataSet.getWays().stream().filter(w -> w.getNodesCount() > max).collect(Collectors.toList())) {
                ArrayList<Node> atNodes = new ArrayList<Node>();
                if (w3.isClosed()) {
                    atNodes.add(w3.getNode(0));
                }
                double n = Math.ceil((double)w3.getNodesCount() / (double)max);
                int i = 1;
                while ((double)i < n) {
                    atNodes.add(w3.getNode((int)((double)i / n * (double)w3.getNodesCount())));
                    ++i;
                }
                SplitWayCommand res = SplitWayCommand.split((Way)w3, atNodes, Collections.emptyList());
                if (res == null) continue;
                res.executeCommand();
            }
            for (Relation r : dataSet.getRelations()) {
                OsmPrimitive outer;
                if (!r.isMultipolygon() || r.getMembersCount() != 1 || (outer = r.getMember(0).getMember()).isTagged()) continue;
                r.remove("type");
                r.removeMember(0);
                outer.setKeys(r.getKeys());
                dataSet.removePrimitive((PrimitiveId)r);
            }
        }
    }
}

