/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.tofix;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.geojson.GeoJsonObject;
import org.geojson.GeometryCollection;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.io.UploadDialog;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.mappaint.mapcss.ExpressionFactory;
import org.openstreetmap.josm.plugins.geojson.DataSetBuilder;
import org.openstreetmap.josm.plugins.geojson.GeoJsonLayer;
import org.openstreetmap.josm.plugins.tofix.TofixDraw;
import org.openstreetmap.josm.plugins.tofix.TofixNewLayer;
import org.openstreetmap.josm.plugins.tofix.bean.AccessToProject;
import org.openstreetmap.josm.plugins.tofix.bean.ItemBean;
import org.openstreetmap.josm.plugins.tofix.controller.ItemController;
import org.openstreetmap.josm.plugins.tofix.util.Download;
import org.openstreetmap.josm.tools.Logging;

public class TofixProject {
    ItemController itemController = new ItemController();
    Bounds bounds = null;
    Bounds bounds_default = null;
    DataSetBuilder dataSetBuilder = new DataSetBuilder();
    MapView mv = null;
    TofixNewLayer tofixLayer = new TofixNewLayer(ExpressionFactory.Functions.tr((String[])new String[]{"Tofix:<Layer>"}));

    public AccessToProject work(ItemBean item, AccessToProject accessToTask, double downloadSize, boolean isCheckedDownloadOSMData, boolean isCheckedEditableData) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            GeoJsonObject object = (GeoJsonObject)mapper.readValue(item.getFeatureCollection().toString(), GeoJsonObject.class);
            GeometryCollection geoJsonObject = new GeometryCollection();
            DataSetBuilder.BoundedDataSet data = new DataSetBuilder().build(object);
            if (isCheckedEditableData) {
                GeoJsonLayer layer = new GeoJsonLayer(ExpressionFactory.Functions.tr((String[])new String[]{"Tofix:editable"}) + accessToTask.getProject_name() + "-" + item.getId(), data);
                layer.setBackgroundLayer(true);
                MainApplication.getLayerManager().addLayer((Layer)layer);
            } else {
                this.checkTofixLayer();
                this.tofixLayer.setName(ExpressionFactory.Functions.tr((String[])new String[]{"Tofix:" + accessToTask.getProject_name()}));
                TofixDraw.draw(this.tofixLayer, data);
            }
            if (isCheckedDownloadOSMData) {
                Download.download(data.getBounds(), 0L, downloadSize);
            }
        }
        catch (Exception e) {
            Logging.error((String)"Error while reading json file!");
            Logging.error((Throwable)e);
        }
        UploadDialog.getUploadDialog().getChangeset().getCommentsCount();
        return accessToTask;
    }

    public final void checkTofixLayer() {
        if (!MainApplication.getLayerManager().containsLayer((Layer)this.tofixLayer)) {
            MainApplication.getLayerManager().addLayer((Layer)this.tofixLayer);
        }
    }
}

