/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.utilsplugin2.actions;

import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.UndoRedoHandler;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.tools.Geometry;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class AddIntersectionsAction
extends JosmAction {
    public AddIntersectionsAction() {
        super(I18n.tr((String)"Add nodes at intersections", (Object[])new Object[0]), "addintersect", I18n.tr((String)"Add missing nodes at intersections of selected ways.", (Object[])new Object[0]), Shortcut.registerShortcut((String)"tools:addintersect", (String)I18n.tr((String)"Tool: {0}", (Object[])new Object[]{I18n.tr((String)"Add nodes at intersections", (Object[])new Object[0])}), (int)73, (int)5005), true);
        this.putValue("help", HelpUtil.ht((String)"/Action/AddIntersections"));
    }

    public void actionPerformed(ActionEvent arg0) {
        if (!this.isEnabled()) {
            return;
        }
        List ways = OsmPrimitive.getFilteredList((Collection)this.getLayerManager().getEditDataSet().getSelected(), Way.class);
        if (ways.isEmpty()) {
            new Notification(I18n.tr((String)"Please select one or more ways with intersections of segments.", (Object[])new Object[0])).setIcon(1).show();
            return;
        }
        LinkedList cmds = new LinkedList();
        Geometry.addIntersections((List)ways, (boolean)false, cmds);
        if (!cmds.isEmpty()) {
            UndoRedoHandler.getInstance().add((Command)new SequenceCommand(I18n.tr((String)"Add nodes at intersections", (Object[])new Object[0]), cmds));
            HashSet<Node> nodes = new HashSet<Node>(10);
            for (Command cmd : cmds) {
                if (!(cmd instanceof AddCommand)) continue;
                Collection pp = cmd.getParticipatingPrimitives();
                for (OsmPrimitive p : pp) {
                    if (!(p instanceof Node) || !p.isNew()) continue;
                    nodes.add((Node)p);
                }
                if (nodes.isEmpty()) continue;
                this.getLayerManager().getEditDataSet().setSelected(nodes);
            }
        }
    }

    protected void updateEnabledState() {
        this.updateEnabledStateOnCurrentSelection();
    }

    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        this.setEnabled(selection != null && !selection.isEmpty());
    }
}

