/*
 * Decompiled with CFR 0.152.
 */
package org.j7zip.SevenZip.Compression.Branch;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.j7zip.Common.RecordVector;
import org.j7zip.SevenZip.Common.InBuffer;
import org.j7zip.SevenZip.Compression.LZ.OutWindow;
import org.j7zip.SevenZip.Compression.RangeCoder.BitDecoder;
import org.j7zip.SevenZip.Compression.RangeCoder.Decoder;
import org.j7zip.SevenZip.ICompressCoder2;
import org.j7zip.SevenZip.ICompressProgressInfo;

public class BCJ2_x86_Decoder
implements ICompressCoder2 {
    public static final int kNumMoveBits = 5;
    InBuffer _mainInStream = new InBuffer();
    InBuffer _callStream = new InBuffer();
    InBuffer _jumpStream = new InBuffer();
    BitDecoder[] _statusE8Decoder = new BitDecoder[256];
    BitDecoder _statusE9Decoder = new BitDecoder(5);
    BitDecoder _statusJccDecoder = new BitDecoder(5);
    OutWindow _outStream = new OutWindow();
    Decoder _rangeDecoder = new Decoder();

    int CodeReal(RecordVector<InputStream> inStreams, Object useless1, int numInStreams, RecordVector<OutputStream> outStreams, Object useless2, int numOutStreams, ICompressProgressInfo progress) throws IOException {
        if (numInStreams != 4 || numOutStreams != 1) {
            return -2147024809;
        }
        this._mainInStream.Create(65536);
        this._callStream.Create(0x100000);
        this._jumpStream.Create(65536);
        this._rangeDecoder.Create(0x100000);
        this._outStream.Create(65536);
        this._mainInStream.SetStream((InputStream)inStreams.get(0));
        this._callStream.SetStream((InputStream)inStreams.get(1));
        this._jumpStream.SetStream((InputStream)inStreams.get(2));
        this._rangeDecoder.SetStream((InputStream)inStreams.get(3));
        this._outStream.SetStream((OutputStream)outStreams.get(0));
        this._mainInStream.Init();
        this._callStream.Init();
        this._jumpStream.Init();
        this._rangeDecoder.Init();
        this._outStream.Init();
        for (int i = 0; i < 256; ++i) {
            this._statusE8Decoder[i] = new BitDecoder(5);
            this._statusE8Decoder[i].Init();
        }
        this._statusE9Decoder.Init();
        this._statusJccDecoder.Init();
        int prevByte = 0;
        int processedBytes = 0;
        while (true) {
            boolean status;
            if (processedBytes > 0x100000 && progress != null) {
                long nowPos64 = this._outStream.GetProcessedSize();
                int res = progress.SetRatioInfo(-1L, nowPos64);
                if (res != 0) {
                    return res;
                }
                processedBytes = 0;
            }
            ++processedBytes;
            int b = this._mainInStream.read();
            if (b == -1) {
                return this.Flush();
            }
            this._outStream.WriteByte(b);
            if (b != 232 && b != 233 && (prevByte != 15 || (b & 0xF0) != 128)) {
                prevByte = b;
                continue;
            }
            if (b == 232) {
                status = this._statusE8Decoder[prevByte].Decode(this._rangeDecoder) == 1;
            } else if (b == 233) {
                status = this._statusE9Decoder.Decode(this._rangeDecoder) == 1;
            } else {
                boolean bl = status = this._statusJccDecoder.Decode(this._rangeDecoder) == 1;
            }
            if (status) {
                int src;
                int b0;
                if (b == 232) {
                    b0 = this._callStream.read();
                    src = b0 << 24;
                    b0 = this._callStream.read();
                    src |= b0 << 16;
                    b0 = this._callStream.read();
                    src |= b0 << 8;
                    b0 = this._callStream.read();
                    if (b0 == -1) {
                        return 1;
                    }
                    src |= b0;
                } else {
                    b0 = this._jumpStream.read();
                    src = b0 << 24;
                    b0 = this._jumpStream.read();
                    src |= b0 << 16;
                    b0 = this._jumpStream.read();
                    src |= b0 << 8;
                    b0 = this._jumpStream.read();
                    if (b0 == -1) {
                        return 1;
                    }
                    src |= b0;
                }
                int dest = src - ((int)this._outStream.GetProcessedSize() + 4);
                this._outStream.WriteByte(dest);
                this._outStream.WriteByte(dest >> 8);
                this._outStream.WriteByte(dest >> 16);
                this._outStream.WriteByte(dest >> 24);
                prevByte = dest >> 24 & 0xFF;
                processedBytes += 4;
                continue;
            }
            prevByte = b;
        }
    }

    public int Flush() throws IOException {
        this._outStream.Flush();
        return 0;
    }

    @Override
    public int Code(RecordVector<InputStream> inStreams, Object useless_inSizes, int numInStreams, RecordVector<OutputStream> outStreams, Object useless_outSizes, int numOutStreams, ICompressProgressInfo progress) throws IOException {
        try {
            int n = this.CodeReal(inStreams, useless_inSizes, numInStreams, outStreams, useless_outSizes, numOutStreams, progress);
            return n;
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            this.ReleaseStreams();
        }
    }

    void ReleaseStreams() throws IOException {
        this._mainInStream.ReleaseStream();
        this._callStream.ReleaseStream();
        this._jumpStream.ReleaseStream();
        this._rangeDecoder.ReleaseStream();
        this._outStream.ReleaseStream();
    }

    @Override
    public void close() throws IOException {
        this.ReleaseStreams();
    }
}

