/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.hssf.record.StandardRecord;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellRangeAddressList;
import org.apache.poi.util.LittleEndianOutput;

public final class MergeCellsRecord
extends StandardRecord {
    public static final short sid = 229;
    private CellRangeAddress[] _regions;
    private final int _startIndex;
    private final int _numberOfRegions;

    public MergeCellsRecord(CellRangeAddress[] cellRangeAddressArray, int n, int n2) {
        this._regions = cellRangeAddressArray;
        this._startIndex = n;
        this._numberOfRegions = n2;
    }

    public MergeCellsRecord(RecordInputStream recordInputStream) {
        int n = recordInputStream.readUShort();
        CellRangeAddress[] cellRangeAddressArray = new CellRangeAddress[n];
        for (int i = 0; i < n; ++i) {
            cellRangeAddressArray[i] = new CellRangeAddress(recordInputStream);
        }
        this._numberOfRegions = n;
        this._startIndex = 0;
        this._regions = cellRangeAddressArray;
    }

    public short getNumAreas() {
        return (short)this._numberOfRegions;
    }

    public CellRangeAddress getAreaAt(int n) {
        return this._regions[this._startIndex + n];
    }

    @Override
    protected int getDataSize() {
        return CellRangeAddressList.getEncodedSize(this._numberOfRegions);
    }

    @Override
    public short getSid() {
        return 229;
    }

    @Override
    public void serialize(LittleEndianOutput littleEndianOutput) {
        int n = this._numberOfRegions;
        littleEndianOutput.writeShort(n);
        for (int i = 0; i < this._numberOfRegions; ++i) {
            this._regions[this._startIndex + i].serialize(littleEndianOutput);
        }
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[MERGEDCELLS]").append("\n");
        stringBuffer.append("     .numregions =").append(this.getNumAreas()).append("\n");
        for (int i = 0; i < this._numberOfRegions; ++i) {
            CellRangeAddress cellRangeAddress = this._regions[this._startIndex + i];
            stringBuffer.append("     .rowfrom =").append(cellRangeAddress.getFirstRow()).append("\n");
            stringBuffer.append("     .rowto   =").append(cellRangeAddress.getLastRow()).append("\n");
            stringBuffer.append("     .colfrom =").append(cellRangeAddress.getFirstColumn()).append("\n");
            stringBuffer.append("     .colto   =").append(cellRangeAddress.getLastColumn()).append("\n");
        }
        stringBuffer.append("[MERGEDCELLS]").append("\n");
        return stringBuffer.toString();
    }

    @Override
    public Object clone() {
        int n = this._numberOfRegions;
        CellRangeAddress[] cellRangeAddressArray = new CellRangeAddress[n];
        for (int i = 0; i < cellRangeAddressArray.length; ++i) {
            cellRangeAddressArray[i] = this._regions[this._startIndex + i].copy();
        }
        return new MergeCellsRecord(cellRangeAddressArray, 0, n);
    }
}

