/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.osmrec.features;

import de.bwaldvogel.liblinear.FeatureNode;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.openstreetmap.josm.plugins.osmrec.container.OSMWay;

public class ClassFeatures {
    private int directClassID = 0;

    public void createClassFeatures(OSMWay wayNode, Map<String, String> mappings, Map<String, Integer> mappingsWithIDs, Map<String, List<String>> indirectClasses, Map<String, Integer> indirectClassesIDs) {
        TreeSet<Integer> sortedIndirectIDs = new TreeSet<Integer>();
        TreeSet<Integer> sortedDirectIDs = new TreeSet<Integer>();
        for (Map.Entry<String, String> wayTagKeyValue : wayNode.getTagKeyValue().entrySet()) {
            String key = wayTagKeyValue.getKey() + " " + wayTagKeyValue.getValue();
            for (Map.Entry<String, String> tagMappedToClass : mappings.entrySet()) {
                if (!key.equals(tagMappedToClass.getKey())) continue;
                String className = tagMappedToClass.getValue();
                this.directClassID = mappingsWithIDs.get(className);
                sortedDirectIDs.add(this.directClassID);
                List<String> superClassesList = indirectClasses.get(className);
                if (superClassesList == null) continue;
                for (String superClass : superClassesList) {
                    Integer indirectID = indirectClassesIDs.get(superClass);
                    if (indirectID == null || sortedIndirectIDs.contains(indirectID)) continue;
                    sortedIndirectIDs.add(indirectID);
                }
            }
        }
        wayNode.setClassIDs(sortedDirectIDs);
        for (Integer dirID : sortedDirectIDs) {
            wayNode.getFeatureNodeList().add(new FeatureNode(dirID, 1.0));
        }
        for (Integer indID : sortedIndirectIDs) {
            wayNode.getFeatureNodeList().add(new FeatureNode(indID, 1.0));
        }
        wayNode.setClassID(this.directClassID);
    }
}

