/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.tofix.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonReader;
import org.openstreetmap.josm.gui.mappaint.mapcss.ExpressionFactory;
import org.openstreetmap.josm.plugins.tofix.util.Config;
import org.openstreetmap.josm.tools.HttpClient;
import org.openstreetmap.josm.tools.Logging;

public class Status {
    public static boolean serverStatus() {
        return Status.testStatus(Config.getHOST());
    }

    public static boolean testStatus(String url) {
        try {
            HttpURLConnection con = (HttpURLConnection)new URL(url).openConnection();
            con.connect();
            if (con.getResponseCode() == 200) {
                BufferedReader br = new BufferedReader(new InputStreamReader(con.getInputStream(), StandardCharsets.UTF_8));
                String responseString = "";
                while (br.ready()) {
                    responseString = br.readLine();
                }
                JsonReader reader = Json.createReader((Reader)new StringReader(responseString));
                JsonObject statusObject = reader.readObject();
                Logger.getLogger(Class.class.getName()).log(Level.INFO, "{0} -> {1} -> {2}", new Object[]{ExpressionFactory.Functions.tr((String[])new String[]{"API server status : " + statusObject.getString("status")}), url, con.getResponseCode()});
                return true;
            }
            Logger.getLogger(Class.class.getName()).log(Level.INFO, "{0} -> {1} -> {2}", new Object[]{ExpressionFactory.Functions.tr((String[])new String[]{"API did not respond!"}), url, con.getResponseCode()});
            return false;
        }
        catch (Exception ex) {
            Logger.getLogger(Class.class.getName()).log(Level.INFO, "{0} -> {1} ({2})", new Object[]{ExpressionFactory.Functions.tr((String[])new String[]{"API did not respond!"}), url, ExpressionFactory.Functions.tr((String[])new String[]{"connection refused"})});
            return false;
        }
    }

    public static boolean isInternetReachable() {
        try {
            HttpClient.create((URL)new URL("http://www.openstreetmap.org")).connect().disconnect();
            return true;
        }
        catch (IOException e) {
            Logging.log((Level)Logging.LEVEL_ERROR, (String)"Couldn't connect to the osm server. Please check your internet connection.", (Throwable)e);
            return false;
        }
    }
}

