/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.tofix;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Line2D;
import java.util.List;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.data.osm.visitor.paint.MapRendererFactory;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.dialogs.LayerListPopup;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.plugins.geojson.DataSetBuilder;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class TofixNewLayer
extends Layer
implements ActionListener {
    DataSetBuilder.BoundedDataSet boundedDataSet;
    float width;

    public TofixNewLayer(String name) {
        super(name);
    }

    public Icon getIcon() {
        return ImageProvider.get((String)"icontofix_layer");
    }

    public String getToolTipText() {
        return I18n.tr((String)"Layer to draw OSM error", (Object[])new Object[0]);
    }

    public boolean isMergable(Layer other) {
        return false;
    }

    public void setBoundedDataSet(DataSetBuilder.BoundedDataSet boundedDataSet) {
        this.boundedDataSet = boundedDataSet;
        this.invalidate();
    }

    public void paint(Graphics2D g, MapView mv, Bounds bounds) {
        DataSet dataset = this.boundedDataSet.getDataSet();
        Stroke stroke = g.getStroke();
        if (dataset == null) {
            return;
        }
        this.width = MapRendererFactory.getInstance().isWireframeMapRendererActive() ? 1.0f : 3.0f;
        g.setColor(new Color(254, 30, 123));
        g.setStroke(new BasicStroke(this.width));
        for (OsmPrimitive primitive : dataset.allPrimitives()) {
            Node node;
            if (primitive instanceof Way) {
                Way way = (Way)primitive;
                List nodes = way.getNodes();
                if (nodes.size() < 2) {
                    return;
                }
                for (int i = 0; i <= way.getNodes().size() - 2; ++i) {
                    Node node1 = way.getNode(i);
                    Node node2 = way.getNode(i + 1);
                    Point pnt1 = mv.getPoint(node1.getCoor());
                    Point pnt2 = mv.getPoint(node2.getCoor());
                    g.draw(new Line2D.Double(pnt1.x, pnt1.y, pnt2.x, pnt2.y));
                }
                continue;
            }
            if (!(primitive instanceof Node) || !(node = (Node)primitive).getParentWays().isEmpty()) continue;
            Point pnt = mv.getPoint(node.getCoor());
            g.drawOval(pnt.x - 20, pnt.y - 20, 40, 40);
        }
        g.setStroke(stroke);
    }

    public void visitBoundingBox(BoundingXYVisitor v) {
    }

    public Object getInfoComponent() {
        return this.getToolTipText();
    }

    public Action[] getMenuEntries() {
        return new Action[]{LayerListDialog.getInstance().createShowHideLayerAction(), Layer.SeparatorLayerAction.INSTANCE, Layer.SeparatorLayerAction.INSTANCE, new LayerListPopup.InfoAction((Layer)this)};
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JOptionPane.showConfirmDialog(null, e.getSource());
    }

    public void mergeFrom(Layer layer) {
    }
}

