/*
 * Decompiled with CFR 0.152.
 */
package pdfimport.pdfbox.operators;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.graphics.xobject.PDXObject;
import org.apache.pdfbox.pdmodel.graphics.xobject.PDXObjectForm;
import org.apache.pdfbox.pdmodel.graphics.xobject.PDXObjectImage;
import org.apache.pdfbox.util.Matrix;
import org.apache.pdfbox.util.PDFOperator;
import org.apache.pdfbox.util.operator.OperatorProcessor;
import pdfimport.pdfbox.PageDrawer;

public class Invoke
extends OperatorProcessor {
    @Override
    public void process(PDFOperator operator, List<COSBase> arguments) throws IOException {
        PageDrawer drawer = (PageDrawer)this.context;
        PDPage page = drawer.getPage();
        COSName objectName = (COSName)arguments.get(0);
        Map<String, PDXObject> xobjects = drawer.getResources().getXObjects();
        PDXObject xobject = xobjects.get(objectName.getName());
        if (xobject instanceof PDXObjectImage) {
            drawer.drawImage();
        } else if (xobject instanceof PDXObjectForm) {
            Matrix matrix;
            PDXObjectForm form = (PDXObjectForm)xobject;
            COSStream invoke = (COSStream)form.getCOSObject();
            PDResources pdResources = form.getResources();
            if (pdResources == null) {
                pdResources = page.findResources();
            }
            if ((matrix = form.getMatrix()) != null) {
                Matrix xobjectCTM = matrix.multiply(this.context.getGraphicsState().getCurrentTransformationMatrix());
                this.context.getGraphicsState().setCurrentTransformationMatrix(xobjectCTM);
            }
            this.getContext().processSubStream(page, pdResources, invoke);
        }
    }
}

