/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.pointinfo;

import java.awt.Component;
import java.awt.GridBagLayout;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.preferences.DefaultTabPreferenceSetting;
import org.openstreetmap.josm.gui.preferences.PreferenceTabbedPane;
import org.openstreetmap.josm.plugins.pointinfo.PointInfoPlugin;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class PointInfoPreference
extends DefaultTabPreferenceSetting {
    private final JComboBox<String> module = new JComboBox();
    private final JCheckBox autoMode = new JCheckBox(I18n.tr((String)"Automatically detect the module", (Object[])new Object[0]));

    public PointInfoPreference() {
        super("pointinfo", I18n.tr((String)"Point information settings", (Object[])new Object[0]), I18n.tr((String)"Settings for the point information plugin.", (Object[])new Object[0]), true);
    }

    public String getIconName() {
        return "info-sml.png";
    }

    public void addGui(PreferenceTabbedPane gui) {
        JPanel panel = new JPanel(new GridBagLayout());
        this.autoMode.setSelected(Main.pref.getBoolean("plugin.pointinfo.automode", false));
        this.autoMode.setToolTipText(I18n.tr((String)"Try to guess the appropriate module from the location. If it fails, use the module selected below.", (Object[])new Object[0]));
        panel.add((Component)this.autoMode, GBC.eol().insets(0, 0, 0, 0));
        for (String modName : PointInfoPlugin.getModules()) {
            this.module.addItem(modName);
        }
        this.module.setSelectedItem(Main.pref.get("plugin.pointinfo.module", "RUIAN"));
        this.module.setToolTipText(I18n.tr((String)"The module called to get the point information.", (Object[])new Object[0]));
        panel.add((Component)new JLabel(I18n.tr((String)"Module", (Object[])new Object[0])), GBC.std());
        panel.add(this.module, GBC.eol().fill(2).insets(5, 0, 0, 5));
        panel.add(Box.createVerticalGlue(), GBC.eol().fill(3));
        this.createPreferenceTabWithScrollPane(gui, panel);
    }

    public boolean ok() {
        Main.pref.putBoolean("plugin.pointinfo.automode", this.autoMode.isSelected());
        Main.pref.put("plugin.pointinfo.module", (String)this.module.getSelectedItem());
        return false;
    }
}

