/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.function;

import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.CoordinateSequenceFilter;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryComponentFilter;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Polygon;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.geotools.filter.FunctionExpressionImpl;
import org.geotools.filter.capability.FunctionNameImpl;
import org.geotools.filter.function.FilterFunction_offset;
import org.geotools.filter.function.GeometryTransformation;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.filter.capability.FunctionName;

public class FilterFunction_isometric
extends FunctionExpressionImpl
implements GeometryTransformation {
    public static FunctionName NAME = new FunctionNameImpl("isometric", Geometry.class, FunctionNameImpl.parameter("geometry", Geometry.class), FunctionNameImpl.parameter("extrusion", Double.class));

    public FilterFunction_isometric() {
        super(NAME);
    }

    @Override
    public Object evaluate(Object feature) {
        Geometry geom = this.getExpression(0).evaluate(feature, Geometry.class);
        Double extrusion = this.getExpression(1).evaluate(feature, Double.class);
        if (geom != null && extrusion != null) {
            SegmentExtractorFilter extractor = new SegmentExtractorFilter();
            geom.apply((GeometryComponentFilter)extractor);
            List<Polygon> faces = extractor.getFaces(geom.getFactory(), extrusion);
            if (geom instanceof Polygon) {
                Polygon offseted = (Polygon)geom.clone();
                offseted.apply((CoordinateSequenceFilter)new FilterFunction_offset.OffsetOrdinateFilter(0.0, extrusion));
                faces.add(0, (Polygon)geom);
                faces.add(offseted);
            } else if (geom instanceof GeometryCollection) {
                GeometryCollection gc = (GeometryCollection)geom;
                for (int i = 0; i < gc.getNumGeometries(); ++i) {
                    Geometry g = gc.getGeometryN(i);
                    if (!(g instanceof Polygon)) continue;
                    Polygon offseted = (Polygon)g.clone();
                    offseted.apply((CoordinateSequenceFilter)new FilterFunction_offset.OffsetOrdinateFilter(0.0, extrusion));
                    faces.add(0, (Polygon)g);
                    faces.add(offseted);
                }
            }
            Polygon[] polyArray = faces.toArray(new Polygon[faces.size()]);
            return geom.getFactory().createMultiPolygon(polyArray);
        }
        return null;
    }

    @Override
    public ReferencedEnvelope invert(ReferencedEnvelope renderingEnvelope) {
        Double offsetY = this.getExpression(1).evaluate(null, Double.class);
        if (offsetY != null) {
            ReferencedEnvelope offseted = new ReferencedEnvelope(renderingEnvelope);
            offseted.translate(0.0, offsetY);
            return offseted;
        }
        return null;
    }

    static class Segment
    implements Comparable<Segment> {
        double x0;
        double y0;
        double x1;
        double y1;

        public Segment(double x0, double y0, double x1, double y1) {
            this.x0 = x0;
            this.y0 = y0;
            this.x1 = x1;
            this.y1 = y1;
        }

        @Override
        public int compareTo(Segment other) {
            double otherMaxX;
            double otherMaxY;
            double maxY = Math.max(this.y0, this.y1);
            if (maxY > (otherMaxY = Math.max(other.y0, other.y1))) {
                return -1;
            }
            if (maxY < otherMaxY) {
                return 1;
            }
            double maxX = Math.max(this.x0, this.x1);
            if (maxX > (otherMaxX = Math.max(other.x0, other.x1))) {
                return 1;
            }
            if (maxX < otherMaxX) {
                return -1;
            }
            return 0;
        }
    }

    static class SegmentExtractorFilter
    implements GeometryComponentFilter {
        List<Segment> segments = new ArrayList<Segment>();

        SegmentExtractorFilter() {
        }

        public void filter(Geometry geom) {
            if (geom instanceof LineString) {
                this.extractSegments(((LineString)geom).getCoordinateSequence());
            }
        }

        private void extractSegments(CoordinateSequence cs) {
            for (int i = 0; i < cs.size() - 1; ++i) {
                this.segments.add(new Segment(cs.getX(i), cs.getY(i), cs.getX(i + 1), cs.getY(i + 1)));
            }
        }

        List<Polygon> getFaces(GeometryFactory gf, double extrude) {
            Collections.sort(this.segments);
            ArrayList<Polygon> result = new ArrayList<Polygon>();
            for (Segment segment : this.segments) {
                CoordinateSequence cs = JTS.createCS(gf.getCoordinateSequenceFactory(), 5, 2);
                cs.setOrdinate(0, 0, segment.x0);
                cs.setOrdinate(0, 1, segment.y0);
                cs.setOrdinate(3, 0, segment.x0);
                cs.setOrdinate(3, 1, segment.y0 + extrude);
                cs.setOrdinate(2, 0, segment.x1);
                cs.setOrdinate(2, 1, segment.y1 + extrude);
                cs.setOrdinate(1, 0, segment.x1);
                cs.setOrdinate(1, 1, segment.y1);
                cs.setOrdinate(4, 0, segment.x0);
                cs.setOrdinate(4, 1, segment.y0);
                result.add(gf.createPolygon(gf.createLinearRing(cs), null));
            }
            return result;
        }
    }
}

