/*
 * Decompiled with CFR 0.152.
 */
package relcontext.actions;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import relcontext.ChosenRelation;
import relcontext.ChosenRelationListener;

public class DuplicateChosenRelationAction
extends AbstractAction
implements ChosenRelationListener {
    private final ChosenRelation rel;

    public DuplicateChosenRelationAction(ChosenRelation rel) {
        super(I18n.tr((String)"Duplicate relation", (Object[])new Object[0]));
        this.putValue("SmallIcon", ImageProvider.get((String)"duplicate"));
        this.putValue("ShortDescription", I18n.tr((String)"Create a copy of this relation and open it in another editor window", (Object[])new Object[0]));
        this.rel = rel;
        rel.addChosenRelationListener(this);
        this.setEnabled(rel.get() != null);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        DataSet ds = MainApplication.getLayerManager().getEditDataSet();
        if (ds != null) {
            Relation r = this.rel.get();
            Relation copy = new Relation(r, true);
            MainApplication.undoRedo.add((Command)new AddCommand(ds, (OsmPrimitive)copy));
            this.rel.set(copy);
            ds.setSelected(new PrimitiveId[]{copy});
        }
    }

    @Override
    public void chosenRelationChanged(Relation oldRelation, Relation newRelation) {
        this.setEnabled(newRelation != null);
    }
}

